/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.svtb.AbstractSVAPatternDetector;

@CheckVersion(value="17.1.24")
@CheckID(value="SVTB.29.6")
@CheckName(value="SVTB.29.6")
@CheckTitle(value="Banned concurrent assert expressions")
@CheckDescription(value="Do not use expressions matched by <expressionPatterns> in concurrent assertions.")
public class Check_SVTB_29_6
extends AbstractSVAPatternDetector {
    @CheckParameter(defaultValue="", description="Comma separated list of expression patterns.", name="expressionPatterns", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pExpressionPatternsValue;
    @CheckParameter(defaultValue="concurrent_assert", description="Comma separated list of: concurrent_assert, concurrent_assume, concurrent_cover_sequence, concurrent_cover_property, expect, immediate_assert, immediate_assume, immediate_cover, restrict, sequence, property.", name="assertionKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAssertionKindValue = new HashSet();
    @CheckParameter(defaultValue="Pattern ''{0}'' found in assert expression ''{1}''!", description="Error message format, where ''{0}'' is replaced with the matching expression pattern and ''{1}'' is replaced with the matched expression.", name="failureMessageFormat", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pFailureMessageFormatValue;

    public Check_SVTB_29_6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Set<Integer> numericalAssertKind = this.getNumericalAssertKind(this.pAssertionKindValue);
        Set<Integer> numericalPropertySequenceKind = this.getNumericalPropertySequenceKind(this.pAssertionKindValue);
        this.detectPattern(this.fOVMProject, this.pExpressionPatternsValue, this.pFailureMessageFormatValue, numericalAssertKind, numericalPropertySequenceKind);
    }
}

