/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

@CheckVersion(value="17.1.26")
@CheckID(value="SVTB.29.7")
@CheckName(value="SVTB.29.7")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.FIELD})
@CheckTitle(value="Banned variables")
@CheckDescription(value="Do not use variables matched by <bannedVariables> parameter.\n\nCheck supports pre-waiving.")
public class Check_SVTB_29_7
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of fully qualified variables names.", name="bannedVariables", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pBannedVariablesValue;

    public Check_SVTB_29_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<IHidObject>(){
            private RfNamedElement scope;
            private ParserPath parserPath;

            public boolean visit(IHidObject hidObject) {
                switch (hidObject.getHidKind()) {
                    case HID: {
                        if (Check_SVTB_29_7.this.checkPrewaivers(this.parserPath)) {
                            return true;
                        }
                        if (!(((RfHid)hidObject).getElement() instanceof RfField)) {
                            return true;
                        }
                        Check_SVTB_29_7.this.notifyCheckAlive();
                        HidOccurrence occurrence = ((RfHid)hidObject).getOccurrence();
                        if (occurrence == null) {
                            return true;
                        }
                        RfField element = (RfField)((RfHid)hidObject).getElement();
                        if (!Check_SVTB_29_7.this.pBannedVariablesValue.contains(element.getFullName())) {
                            return true;
                        }
                        Check_SVTB_29_7.this.addHit(this.scope.getDeclaration().getDefFile().getParserPath(), occurrence, "Banned variable '" + LintUtils.getNamedElementFullName(element) + "'!");
                        return true;
                    }
                }
                return true;
            }

            public void setHolder(IHidHolder holder) {
                this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
    }

    private boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

