/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;

@CheckVersion(value="19.1.23")
@CheckID(value="SVTB.29.8")
@CheckName(value="SVTB.29.8")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.RANDOMIZATION})
@CheckTitle(value="Banned randcase")
@CheckDescription(value="Do not use randcase.\n\nExamples:\nmodule a;\n\ttask foo;\n\t\tint data;\n\t\trandcase // not allowed\n\t\t\t1 : data = 1;\n\t\t\t2 : data = 2;\n\t\t\t3 : data = 3;\n\t\tendcase\n\tendtask\nendmodule")
public class Check_SVTB_29_8
extends OVMComplianceCheck {
    public Check_SVTB_29_8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> actionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        for (RfActionBlock actionBlock : actionBlocks) {
            this.notifyCheckAlive();
            if (!actionBlock.isRandCase()) continue;
            this.addHit(actionBlock, "Banned randcase statement used!");
        }
    }
}

