/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;

@CheckVersion(value="19.1.23")
@CheckID(value="SVTB.29.9")
@CheckName(value="SVTB.29.9")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.RANDOMIZATION})
@CheckTitle(value="Banned randsequence")
@CheckDescription(value="Do not use randsequence.\n\nExamples:\nmodule a;\n\tinitial\n\t\trepeat(8)\n\t\t\trandsequence( main ) // not allowed\n\t\t\t\tmain : one | two | three ;\n\t\t\t\tone : {$display(\"one\");};\n\t\t\t\ttwo : {$display(\"two\");};\n\t\t\t\tthree: {$display(\"three\");};\n\t\t\tendsequence\nendmodule")
public class Check_SVTB_29_9
extends OVMComplianceCheck {
    public Check_SVTB_29_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> actionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        for (RfActionBlock actionBlock : actionBlocks) {
            this.notifyCheckAlive();
            if (!actionBlock.isRandsequenceStatement()) continue;
            this.addHit(actionBlock, "Banned randsequence statement used!");
        }
    }
}

