/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractOneEntityPerFileCheck;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.2.1")
@CheckName(value="SVTB.2.1")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.CLASS, RuleLabel.INTERFACE, RuleLabel.PACKAGE, RuleLabel.MODULE})
@CheckTitle(value="Only One class, interface, package, or module per File and Extern Implementations")
@CheckDescription(value="All files shall contain one and only one class, interface, package, or module.\n\nExtern implementations are accepted in the same file with the class declaration, for example:\n\n class c;\n   extern function int foo();\n endclass\n function int c::foo();\n endfunction\n\nInner entities are allowed, for example:\n\n package p1;\n   class c1;\n   endclass\n endpackage\n\n class c2;\n   class c3;\n   endclass\n endclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_2_1
extends AbstractOneEntityPerFileCheck {
    public Check_SVTB_2_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashMap<ParserPath, ArrayList<RfNamedElement>> fileEntitiesMap = new HashMap<ParserPath, ArrayList<RfNamedElement>>();
        NullProtectedList<RfNamedElement> allComponents = new NullProtectedList<RfNamedElement>();
        allComponents.addAll(this.fOVMProject.getAllNonXVMClasses());
        allComponents.addAll(this.fOVMProject.getAllModules());
        allComponents.addAll(this.fOVMProject.getAllInterfaces());
        allComponents.addAll(this.fOVMProject.getAllPackages());
        for (RfNamedElement rfNamedElement : allComponents) {
            ParserPath parserPath = rfNamedElement.getFile().getParserPath();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            ArrayList<RfNamedElement> entitiesPerFile = (ArrayList<RfNamedElement>)fileEntitiesMap.get(parserPath);
            if (entitiesPerFile == null) {
                entitiesPerFile = new ArrayList<RfNamedElement>();
            }
            boolean isAdded = false;
            RfDefElement rfDefElement = rfNamedElement.getDeclaration();
            if (rfDefElement == null) continue;
            for (RfNamedElement entity : entitiesPerFile) {
                RfDefElement entityDefElement = entity.getDeclaration();
                if (entityDefElement == null || !rfDefElement.equals(entityDefElement)) continue;
                isAdded = true;
                break;
            }
            if (isAdded) continue;
            entitiesPerFile.add(rfNamedElement);
            fileEntitiesMap.put(parserPath, entitiesPerFile);
        }
        this.notifyCheckAlive();
        NullProtectedList<RfNamedElement> allExternalMethods = new NullProtectedList<RfNamedElement>();
        allExternalMethods.addAll(this.fOVMProject.getAllFunctions());
        allExternalMethods.addAll(this.fOVMProject.getAllTasks());
        Iterator iterator = allExternalMethods.iterator();
        while (iterator.hasNext()) {
            RfNamedElement rfNamedElement = (RfNamedElement)iterator.next();
            if (rfNamedElement.isExtern()) continue;
            iterator.remove();
        }
        this.notifyCheckAlive();
        for (RfNamedElement externMethod : allExternalMethods) {
            RfNamedElement scope;
            Collection defs = externMethod.getDeclarations();
            if (defs == null) continue;
            Iterator iter = defs.iterator();
            if (defs.size() != 2) continue;
            RfDefElement funcImplementation = (RfDefElement)iter.next();
            if (funcImplementation instanceof RfFunctionDef && ((RfFunctionDef)funcImplementation).isPrototype()) {
                funcImplementation = (RfDefElement)iter.next();
            }
            ParserPath parserPath = funcImplementation.getParserPath();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            ArrayList<RfNamedElement> blockNames = fileEntitiesMap.get(parserPath);
            if (blockNames == null) {
                blockNames = new ArrayList();
            }
            if (!blockNames.contains(scope = externMethod.getEnclosingScope())) {
                blockNames.add(scope);
            }
            fileEntitiesMap.put(parserPath, blockNames);
        }
        this.notifyCheckAlive();
        this.checkOnePerFile(fileEntitiesMap);
    }
}

