/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractHeaderCheck;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.2.10")
@CheckName(value="SVTB.2.10")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.COMMENT})
@CheckTitle(value="File Header")
@CheckDescription(value="Header must be used in every file.\nThis rule fails if all of the reference header files and the <headerValue> contain at least one line that is not found in the checked file.\nBoth the reference header and the header lines are trimmed and case is ignored when <patternMatch> is false.\n\nCheck supports pre-waiving.")
public class Check_SVTB_2_10
extends AbstractHeaderCheck {
    public Check_SVTB_2_10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void analyzeHeaders(Map<String, String[]> headerLines, Map<String, Pattern[]> headerPatterns) throws IOException {
        File file = null;
        String line = null;
        HashSet<ParserPath> fileNames = this.fOVMProject.getAllImportedFiles();
        for (ParserPath fileName : fileNames) {
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileName, this)) continue;
            file = new File(fileName.path);
            if (!file.canRead()) {
                this.addHit(fileName, 1, "Failed reading file '" + fileName + "'!", null);
                continue;
            }
            boolean reportFile = true;
            int hitLine = 0;
            String message = "Invalid header!";
            for (String headerFilePath : this.pHeaderFilePathValue) {
                boolean validHeader = true;
                Throwable throwable = null;
                Object var15_16 = null;
                try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                    int lastMatch = 0;
                    int currentLine = 0;
                    int i = 0;
                    while (i < headerLines.get(headerFilePath).length) {
                        block17: {
                            block16: {
                                line = bufferedReader.readLine();
                                if (line == null) {
                                    message = "Invalid header! Expecting header line " + (i + 1) + " :'" + headerLines.get(headerFilePath)[i] + "'.";
                                    hitLine = lastMatch + 1;
                                    validHeader = false;
                                    break;
                                }
                                ++currentLine;
                                if ((!this.pPatternMatchValue || headerPatterns.get(headerFilePath) == null || headerPatterns.get(headerFilePath)[i].matcher(line).matches()) && (this.pPatternMatchValue || DVTStringUtil.replaceAll((Pattern)WHITESPACE_PATTERN, (CharSequence)line.toLowerCase(), (String)" ").trim().equals(headerLines.get(headerFilePath)[i]))) break block16;
                                if (this.pSkipMismatchedLinesValue) {
                                    --i;
                                    break block17;
                                } else {
                                    message = "Invalid header! Expecting '" + headerLines.get(headerFilePath)[i] + "'.";
                                    hitLine = i + 1;
                                    validHeader = false;
                                    break;
                                }
                            }
                            lastMatch = currentLine;
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                if (!validHeader) continue;
                reportFile = false;
            }
            if (!reportFile) continue;
            if (headerLines.size() == 1) {
                this.addHit(fileName, hitLine, message, null);
                continue;
            }
            this.addHit(fileName, 1, "Invalid header! None of the specified headers matches.", null);
        }
    }
}

