/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_2_12;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractIfndefGuardsCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.2.12")
@CheckName(value="SVTB.2.12")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.CONDITIONAL_DIRECTIVE, RuleLabel.INCLUDE_GUARD})
@CheckTitle(value="Use `include guards")
@CheckDescription(value="Use `include guards.\n\nExample my_agent.sv:\n ... // header here (only comments or spaces allowed)\n`ifndef PREFIX_MY_AGENT_SV_SUFFIX\n`define PREFIX_MY_AGENT_SV_SUFFIX\n ... // code here\n`endif // PREFIX_MY_AGENT_SV_SUFFIX\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_2_12.class)
public class Check_SVTB_2_12
extends AbstractIfndefGuardsCheck {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    @CheckParameter(defaultValue="", description="PREFIX_ above.", name="definePrefix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pPrefixValue;
    @CheckParameter(defaultValue="", description="_SUFFIX above.", name="defineSuffix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pSuffixValue;
    @CheckParameter(defaultValue="filenameUpper", description="filenameUpper, filenameLower, or filenameAsIs. All dots '.' in the file name are replaced with underscore '_'.", name="defineBasename", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pBasenameValue;
    @CheckParameter(defaultValue="false", description="Do not use the file extension in the define name.", name="ignoreExtension", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pIgnoreExtensionValue;
    @CheckParameter(defaultValue="", description="Apply only if file contains module, package, class, interface. When empty, check all files.", name="iffFileContains", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pFileContainsValue;
    @CheckParameter(defaultValue="true", description="Check endif comment.", name="checkEndIfComment", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckEndIfCommentValue;
    @CheckParameter(defaultValue="_", description="Replacement for the dot before the file extension.", name="dotReplacement", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pDodReplacementValue;
    @CheckParameter(defaultValue="define", description="Specify the format for the `endif comment. Comma separated list of define, `ifndef define.", name="endIfComment", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pEndIfCommentValue;
    @CheckParameter(defaultValue=".*", description="Specify files to check. Comma separated list of patterns.", name="filePatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private Set<Pattern> pFilePatternsValue;
    @CheckParameter(defaultValue="true", description="When true, if a file is included in different scopes in the same library, it will not be checked.", name="skipFilesIncludedInDifferentScopes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipFilesIncludedInDifferentScopes;

    public Check_SVTB_2_12(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public boolean shouldCheck(ParserPath fileName) {
        for (Pattern pattern : this.pFilePatternsValue) {
            if (pattern == null) continue;
            try {
                if (!pattern.matcher(fileName.path).matches()) continue;
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private String getDefineName(File aFile, String aPrefix, String aProcessing, String aSuffix, String dotReplacement, boolean ignoreExtension) {
        if (aFile != null) {
            String fileName = aFile.getName();
            if (ignoreExtension && fileName.contains(".")) {
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
            }
            fileName = fileName.replace(".", dotReplacement);
            if ("filenameUpper".equals(aProcessing)) {
                fileName = fileName.toUpperCase();
            } else if ("filenameLower".equals(aProcessing)) {
                fileName = fileName.toLowerCase();
            }
            return String.valueOf(aPrefix) + fileName + aSuffix;
        }
        return null;
    }

    private void collectFiles(HashSet<ParserPath> aSet, Collection<? extends RfNamedElement> aCollection) {
        for (RfNamedElement rfNamedElement : aCollection) {
            ParserPath newKey = rfNamedElement.getFile().getParserPath();
            if (aSet.contains(newKey)) continue;
            aSet.add(newKey);
        }
    }

    @Override
    public Set<ParserPath> collectFiles() {
        LinkedHashSet<ParserPath> filesToCheck = new LinkedHashSet<ParserPath>();
        if (this.pFileContainsValue.contains("module")) {
            this.collectFiles(filesToCheck, this.fOVMProject.getAllModules());
        }
        if (this.pFileContainsValue.contains("package")) {
            this.collectFiles(filesToCheck, this.fOVMProject.getAllPackages());
        }
        if (this.pFileContainsValue.contains("class")) {
            this.collectFiles(filesToCheck, this.fOVMProject.getAllNonXVMClasses());
        }
        if (this.pFileContainsValue.contains("interface")) {
            this.collectFiles(filesToCheck, this.fOVMProject.getAllInterfaces());
        }
        if (this.pFileContainsValue.isEmpty()) {
            filesToCheck = new LinkedHashSet<ParserPath>(this.fOVMProject.getAllImportedFiles());
        }
        if (this.pSkipFilesIncludedInDifferentScopes) {
            Map<ParserPath, Map<RfLibrary, Set<RfNamedElement>>> nrOfDiffIncludingScopesByLibrary = this.computeNrOfDiffIncludingScopes();
            HashSet<ParserPath> filesWithDiffIncludeScopes = new HashSet<ParserPath>();
            block0: for (Map.Entry<ParserPath, Map<RfLibrary, Set<RfNamedElement>>> parserEntry : nrOfDiffIncludingScopesByLibrary.entrySet()) {
                for (Map.Entry<RfLibrary, Set<RfNamedElement>> libEntry : parserEntry.getValue().entrySet()) {
                    if (libEntry.getValue().size() <= 1) continue;
                    filesWithDiffIncludeScopes.add(parserEntry.getKey());
                    continue block0;
                }
            }
            filesToCheck.removeAll(filesWithDiffIncludeScopes);
        }
        return filesToCheck;
    }

    private Map<ParserPath, Map<RfLibrary, Set<RfNamedElement>>> computeNrOfDiffIncludingScopes() {
        HashMap<ParserPath, Map<RfLibrary, Set<RfNamedElement>>> diffLibraryScopes = new HashMap<ParserPath, Map<RfLibrary, Set<RfNamedElement>>>();
        VlogPreprocessingInfo preprocessingTable = this.fOVMProject.getRfProject().getPreprocessingTable();
        VlogFileInstance topFile = preprocessingTable.getTopFileInstance();
        if (topFile == null) {
            return null;
        }
        ArrayList<VlogFileInstance> includedfiles = new ArrayList<VlogFileInstance>();
        includedfiles.addAll(topFile.getIncludedInstances());
        int i = 0;
        while (i < includedfiles.size()) {
            VlogFileInstance instance = (VlogFileInstance)includedfiles.get(i);
            String name = instance.getShortFileName();
            List<VlogFileInstance> includedInstances = instance.getIncludedInstances();
            if (name.startsWith("__vlog__") && name.endsWith(".libfile")) {
                includedfiles.addAll(includedInstances);
            }
            ParserPath parserPath = instance.getParserPath();
            File file = new File(parserPath.path);
            if (file.exists()) {
                RfNamedElement semanticScope;
                RfLibrary libraryScope;
                HashSet<RfNamedElement> includeScopes;
                includedfiles.addAll(includedInstances);
                HashMap<RfLibrary, HashSet<RfNamedElement>> libraryScopes = (HashMap<RfLibrary, HashSet<RfNamedElement>>)diffLibraryScopes.get(parserPath);
                if (libraryScopes == null) {
                    libraryScopes = new HashMap<RfLibrary, HashSet<RfNamedElement>>();
                    diffLibraryScopes.put(parserPath, libraryScopes);
                }
                if ((includeScopes = (HashSet<RfNamedElement>)libraryScopes.get(libraryScope = (semanticScope = instance.getSemanticScope()).getEnclosingLibrary())) == null) {
                    includeScopes = new HashSet<RfNamedElement>();
                    libraryScopes.put(libraryScope, includeScopes);
                }
                includeScopes.add(instance.getSemanticScope());
                this.notifyCheckAlive();
            }
            ++i;
        }
        return diffLibraryScopes;
    }

    private String getEndifHitMessage(String defineName) {
        String patternMessage = "";
        if (this.pEndIfCommentValue.contains("define")) {
            patternMessage = String.valueOf(patternMessage) + "`endif // " + defineName + " or ";
        }
        if (this.pEndIfCommentValue.contains("`ifndef define")) {
            patternMessage = String.valueOf(patternMessage) + "`endif // `ifndef " + defineName + " or ";
        }
        if (patternMessage.length() > 4) {
            patternMessage = patternMessage.substring(0, patternMessage.length() - 4);
        }
        return patternMessage;
    }

    @Override
    public String getDefineName(File file) {
        return this.getDefineName(file, this.pPrefixValue, this.pBasenameValue, this.pSuffixValue, this.pDodReplacementValue, this.pIgnoreExtensionValue);
    }

    @Override
    public void addHitForGuard(String guard, ParserPath fileName, int line, String defineName) {
        switch (guard) {
            case "`ifndef": {
                this.addHit(fileName, line, "Expecting `ifndef " + defineName + " !", null, new VerissimoAutofixAdditionalInfo(defineName, "`ifndef"));
                return;
            }
            case "`define": {
                this.addHit(fileName, line, "Expecting `define " + defineName + " !", null, new VerissimoAutofixAdditionalInfo(defineName, "`define"));
                return;
            }
            case "`endif": {
                Matcher matcher;
                String hitMessage = this.getEndifHitMessage(defineName);
                int firstWhitespaceIndex = hitMessage.indexOf("\\s");
                String guardText = hitMessage;
                if (firstWhitespaceIndex != -1) {
                    guardText = guardText.substring(0, firstWhitespaceIndex);
                }
                if ((matcher = WHITESPACE_PATTERN.matcher(hitMessage)).find()) {
                    guardText = hitMessage.substring(0, matcher.start());
                }
                this.addHit(fileName, line, "Expecting " + hitMessage + "!", null, new VerissimoAutofixAdditionalInfo(defineName, guardText));
                return;
            }
        }
    }

    @Override
    protected void checkEndifComment(LiteralToken endifToken, ParserPath parserPath, String defineName) {
        if (this.pCheckEndIfCommentValue) {
            LiteralToken token1 = this.getWSParser().getNextToken(endifToken, parserPath);
            LiteralToken token2 = this.getWSParser().getNextToken(token1, parserPath);
            if (token1 == null || token2 == null || !token1.getStringToken().equals("//") || token1.getLineNumber() != endifToken.getLineNumber() || token2.getLineNumber() != endifToken.getLineNumber() || token1.getZone() == SVTBWhitespaceParser.ZoneType.CODE || token2.getZone() == SVTBWhitespaceParser.ZoneType.CODE) {
                this.addHitForGuard("`endif", parserPath, endifToken.getLineNumber(), defineName);
                return;
            }
            if (this.pEndIfCommentValue.contains("define") && token2.getStringToken().equals(defineName)) {
                return;
            }
            if (this.pEndIfCommentValue.contains("`ifndef define")) {
                LiteralToken token3 = this.getWSParser().getNextToken(token2, parserPath);
                LiteralToken token4 = this.getWSParser().getNextToken(token3, parserPath);
                if (token2.getStringToken().equals("`ifndef") && token3.getStringToken().equals(defineName) && token3.getLineNumber() == endifToken.getLineNumber() && (token4 == null || token4.getLineNumber() != token3.getLineNumber())) {
                    return;
                }
            }
            this.addHitForGuard("`endif", parserPath, endifToken.getLineNumber(), defineName);
        }
    }

    @Override
    protected void checkDefineGuard(ParserPath parserPath, String defineName, LiteralToken ifndefIdentifier) {
        LiteralToken defineToken = this.getWSParser().getNextCodeToken(ifndefIdentifier, parserPath);
        if (defineToken == null || !defineToken.getStringToken().equals("`define")) {
            this.addHitForGuard("`define", parserPath, ifndefIdentifier.getLineNumber() + 1, defineName);
            return;
        }
        LiteralToken defineIdentifier = this.getWSParser().getNextCodeToken(defineToken, parserPath);
        if (defineIdentifier == null || !defineIdentifier.getStringToken().equals(defineName)) {
            this.addHitForGuard("`define", parserPath, defineToken.getLineNumber(), defineName);
        }
    }

    @Override
    protected LiteralToken checkAndGetIfndefIdentifier(LiteralToken ifndefToken, ParserPath parserPath, String defineName) {
        LiteralToken ifndefIdentifier = this.getWSParser().getNextCodeToken(ifndefToken, parserPath);
        if (ifndefIdentifier == null || !ifndefIdentifier.getStringToken().equals(defineName)) {
            this.addHitForGuard("`ifndef", parserPath, ifndefToken.getLineNumber(), defineName);
            return null;
        }
        return ifndefIdentifier;
    }

    @Override
    protected void checkOutsideGuards(CodePreprocFileInfo preprocInfo, ParserPath parserPath, String defineName) {
        if (preprocInfo == null) {
            return;
        }
        TreeSet<Integer> lines = preprocInfo.getLines();
        if (lines == null) {
            return;
        }
        ArrayList<Integer> linesList = new ArrayList<Integer>(lines);
        int level = 0;
        boolean hasIfndefGuard = false;
        for (Integer line : linesList) {
            block1: for (LiteralToken token : this.getWSParser().getTokensOnLine(parserPath, line)) {
                String tokenString = token.getStringToken();
                if (token.getZone() != SVTBWhitespaceParser.ZoneType.CODE) continue;
                for (String directiveType : this.conditionalCompilerDirectives) {
                    if (!tokenString.contains(directiveType)) continue;
                    if (directiveType.equals("`ifdef") || directiveType.equals("`ifndef")) {
                        if (level == 0 && hasIfndefGuard) {
                            this.addHit(parserPath, (int)line, "Multiple `ifndef guards in the same file!", null, null);
                        }
                        ++level;
                        hasIfndefGuard = true;
                        continue block1;
                    }
                    if (!directiveType.equals("`endif")) continue;
                    --level;
                    continue block1;
                }
            }
        }
    }
}

