/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractIfndefGuardsCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;

@CheckVersion(value="18.1.19")
@CheckID(value="SVTB.2.12.1")
@CheckName(value="SVTB.2.12.1")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.CONDITIONAL_DIRECTIVE, RuleLabel.INCLUDE_GUARD})
@CheckTitle(value="Mandatory `ifndef guards for each file")
@CheckDescription(value="Use `ifndef guards.\n\nExample:\n`ifndef text_macro_identifier\n ... // code here\n`endif\n\nCheck supports pre-waiving.")
public class Check_SVTB_2_12_1
extends AbstractIfndefGuardsCheck {
    public Check_SVTB_2_12_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public Set<ParserPath> collectFiles() {
        return this.fOVMProject.getAllImportedFiles();
    }

    @Override
    public boolean shouldCheck(ParserPath fileName) {
        return true;
    }

    @Override
    public void addHitForGuard(String guard, ParserPath fileName, int line, String defineName) {
        switch (guard) {
            case "`ifndef": {
                this.addHit(fileName, line, "Expecting `ifndef!", null);
                return;
            }
            case "`define": {
                return;
            }
            case "`endif": {
                this.addHit(fileName, line, "Expecting `endif!", null);
                return;
            }
        }
    }

    @Override
    public String getDefineName(File file) {
        return "";
    }

    @Override
    protected void checkEndifComment(LiteralToken endifToken, ParserPath parserPath, String defineName) {
    }

    @Override
    protected void checkDefineGuard(ParserPath parserPath, String defineName, LiteralToken ifndefIdentifier) {
    }

    @Override
    protected LiteralToken checkAndGetIfndefIdentifier(LiteralToken ifndefToken, ParserPath parserPath, String defineName) {
        return new LiteralToken(-1);
    }

    @Override
    protected void checkOutsideGuards(CodePreprocFileInfo preprocInfo, ParserPath parserPath, String defineName) {
        if (preprocInfo == null) {
            return;
        }
        TreeSet<Integer> lines = preprocInfo.getLines();
        if (lines == null) {
            return;
        }
        ArrayList<Integer> linesList = new ArrayList<Integer>(lines);
        LiteralToken lastGuardToken = null;
        int lastLine = -1;
        int level = 0;
        for (Integer line : linesList) {
            block1: for (LiteralToken token : this.getWSParser().getTokensOnLine(parserPath, line)) {
                boolean checkCode;
                String tokenString = token.getStringToken();
                boolean bl = checkCode = lastGuardToken != null && level == 0;
                if (token.getZone() != SVTBWhitespaceParser.ZoneType.CODE) continue;
                for (String directiveType : this.conditionalCompilerDirectives) {
                    if (!tokenString.contains(directiveType)) continue;
                    if (directiveType.equals("`ifdef") || directiveType.equals("`ifndef")) {
                        if (checkCode && !token.equals(this.getWSParser().getNextCodeToken(lastGuardToken, parserPath))) {
                            this.addHit(parserPath, lastLine, "There is code outside guards " + (lastLine == line ? "on line " + line : "between lines " + lastLine + " and " + line) + "!", null);
                        }
                        if (level == 0 && directiveType.equals("`ifdef")) {
                            this.addHitForGuard("`ifndef", parserPath, token.getLineNumber(), defineName);
                        }
                        ++level;
                        continue block1;
                    }
                    if (!directiveType.equals("`endif")) continue;
                    --level;
                    lastGuardToken = token;
                    lastLine = token.getLineNumber();
                    continue block1;
                }
            }
        }
    }
}

