/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="16.1.22")
@CheckID(value="SVTB.2.13")
@CheckName(value="SVTB.2.13")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.DIRECTIVE, RuleLabel.TIMESCALE})
@CheckTitle(value="The same `timescale values must be used in every file")
@CheckDescription(value="All files must use the `timescale directive with the same values.\n\nImplementation Notes:\nThe linter checks that every file has at least one `timescale directive and that the values are identical across files.\nMost frequently used `timescale values will be considered reference values.")
public class Check_SVTB_2_13
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="Specifies if all files must have a `timescale directive.", name="mandatoryTimescale", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pMandatoryTimescaleValue;

    public Check_SVTB_2_13(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(37);
    }

    @Override
    public void performCheckImpl() {
        HashSet<ParserPath> files = this.fOVMProject.getAllImportedFiles();
        if (files.isEmpty()) {
            return;
        }
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(37);
        HashMap<String, Object[]> timescaleFrequency = new HashMap<String, Object[]>();
        for (ParserPath file : files) {
            this.notifyCheckAlive();
            List<SVTBIssues> timescales = allIssues.get(file);
            if (timescales == null) continue;
            for (SVTBIssues timescale : timescales) {
                String timescaleValue = timescale.getInfo();
                if (timescaleValue == null) continue;
                Object[] values = (Object[])timescaleFrequency.get(timescaleValue = timescaleValue.replaceAll("\\s+", ""));
                if (values == null) {
                    values = new Object[]{0, timescale.getInfo().replaceAll("\\s+", " ")};
                    timescaleFrequency.put(timescaleValue, values);
                }
                values[0] = (Integer)values[0] + 1;
            }
        }
        String[] mostFrequentTimescale = this.getMostFrequentTimescale(timescaleFrequency);
        for (ParserPath file : files) {
            this.notifyCheckAlive();
            List<SVTBIssues> timescales = allIssues.get(file);
            if (this.pMandatoryTimescaleValue && (timescales == null || timescales.isEmpty())) {
                this.addHit(file, 1, "File doesn't contain any `timescale directives!", null);
                continue;
            }
            if (timescales == null || timescales.isEmpty()) continue;
            for (SVTBIssues timescale : timescales) {
                String timescaleValue = timescale.getInfo();
                if (timescaleValue == null || timescaleValue.replaceAll("\\s+", "").equals(mostFrequentTimescale[0])) continue;
                this.addHit(file, timescale.getLine(), String.valueOf(timescaleValue.replaceAll("\\s+", " ")) + " is differrent than the most frequently used " + mostFrequentTimescale[1] + "!", timescale.getReparseInfo());
            }
        }
    }

    private String[] getMostFrequentTimescale(Map<String, Object[]> map) {
        int maxOccurence = Integer.MIN_VALUE;
        String[] result = new String[2];
        for (Map.Entry<String, Object[]> entry : map.entrySet()) {
            int value = (Integer)entry.getValue()[0];
            if (value <= maxOccurence) continue;
            maxOccurence = value;
            result[0] = entry.getKey();
            result[1] = (String)entry.getValue()[1];
        }
        return result;
    }
}

