/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;

@CheckVersion(value="17.1.2")
@CheckID(value="SVTB.2.14")
@CheckName(value="SVTB.2.14")
@CheckLabel(labels={RuleLabel.FILE})
@CheckTitle(value="Mandatory compiled files")
@CheckDescription(value="All of the specified <files> must be compiled.\n\nExample:\n /absolute/path\n$VAR/some/path")
public class Check_SVTB_2_14
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of file full paths.", name="files", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pFilesValue;
    @CheckParameter(defaultValue="false", description="The paths given to the 'files' parameter will be considered relative to the project root.", name="useRelativePaths", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pUseRelativePaths;
    private Set<ParserPath> paths = new HashSet<ParserPath>();

    public Check_SVTB_2_14(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    private void checkFilesParameter() {
        for (String fileString : this.pFilesValue) {
            String replacedFileString = LintUtils.replaceAllSystemVariables(this.fOVMProject.getProject(), fileString, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED);
            if (replacedFileString == null || replacedFileString.isEmpty()) continue;
            File file = new File(replacedFileString);
            if (!file.exists() && this.pUseRelativePaths) {
                file = new File(this.fOVMProject.getProject().getLocation().toFile(), replacedFileString);
            }
            if (!file.exists()) {
                this.signalParamError("Specified file " + replacedFileString + " does not exist", false);
                continue;
            }
            if (this.pUseRelativePaths) {
                this.paths.add(new ParserPath(this.fOVMProject.getProject().getLocation().toFile() + "/" + replacedFileString));
                continue;
            }
            this.paths.add(new ParserPath(replacedFileString));
        }
    }

    @Override
    public void performCheckImpl() {
        this.checkFilesParameter();
        if (this.paths.isEmpty()) {
            return;
        }
        List<ParserPath> files = this.fOVMProject.getAllFilesInOrder();
        if (files.isEmpty()) {
            this.addHit(new ParserPath("none"), 0, "No compiled files in project!", null);
            return;
        }
        HashSet<ParserPath> compiledFiles = new HashSet<ParserPath>(files);
        for (ParserPath path : this.paths) {
            this.notifyCheckAlive();
            if (compiledFiles.contains(path)) continue;
            this.addHit(new ParserPath("none"), 0, "Mandatory file '" + path.path + "' is not compiled!", null);
        }
    }
}

