/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import antlr.Token;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;

@CheckVersion(value="17.1.24")
@CheckID(value="SVTB.2.15")
@CheckName(value="SVTB.2.15")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.INCLUDE})
@CheckTitle(value="Do not explicitly include files inside argument files")
@CheckDescription(value="Do not explicitly include files matched by <includedFilePatterns> inside argument files matched by <argumentFilePatterns>.")
public class Check_SVTB_2_15
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of regexes matching argument files to look into.", name="argumentFilePatterns", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.CSL_REGEX)
    private Set<Pattern> pArgumentFilePatternsValue;
    @CheckParameter(defaultValue="", description="Comma separated list of regexes matching included files to search for.", name="includedFilePatterns", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.CSL_REGEX)
    private Set<Pattern> pIncludedFilePatternsValue;

    public Check_SVTB_2_15(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List invocations = BuildConfigManager.getInvocations((IProject)this.fOVMProject.getProject());
        if (invocations == null || invocations.isEmpty()) {
            return;
        }
        for (Invocation invocation : invocations) {
            List allProperties = invocation.getProperties();
            if (allProperties == null) {
                return;
            }
            for (BuildConfigProperty property : allProperties) {
                String includedFilePath;
                int argsFileLine;
                Token argsFile = (Token)property.getAttribute("ATTRIBUTE_TOKEN");
                if (argsFile == null) continue;
                this.notifyCheckAlive();
                String argsFilePath = argsFile.getFilename();
                if (argsFilePath == null || argsFilePath.isEmpty() || (argsFileLine = argsFile.getLine()) <= 0 || (includedFilePath = property.getValue()) == null || includedFilePath.isEmpty() || !this.matchArgsFile(argsFilePath) || !this.matchIncludedFile(includedFilePath)) continue;
                this.addHit(new ParserPath(argsFilePath), argsFileLine, "Arguments file includes '" + new File(includedFilePath).getName() + "'!", null);
            }
        }
    }

    private boolean matchArgsFile(String filePath) {
        for (Pattern filePattern : this.pArgumentFilePatternsValue) {
            if (!Pattern.matches(filePattern.toString(), filePath)) continue;
            return true;
        }
        return false;
    }

    private boolean matchIncludedFile(String includePath) {
        for (Pattern includePattern : this.pIncludedFilePatternsValue) {
            if (!Pattern.matches(includePattern.toString(), includePath)) continue;
            return true;
        }
        return false;
    }
}

