/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.SVTBCharParser;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;

@CheckVersion(value="18.1.5")
@CheckID(value="SVTB.2.16")
@CheckName(value="SVTB.2.16")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.CONDITIONAL_DIRECTIVE, RuleLabel.INCLUDE_GUARD})
@CheckTitle(value="Do not use `include guards")
@CheckDescription(value="Do not use `include guards.\n\nNot allowed:\n`ifndef FILE_NAME_DEFINE\n`define FILE_NAME_DEFINE\n ... // code here\n`endif // FILE_NAME_DEFINE\n\nCheck supports pre-waiving.")
public class Check_SVTB_2_16
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="Check only files included in a package.", name="checkOnlyFilesIncludedInPackage", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckOnlyFilesIncludedInPackageValue;

    public Check_SVTB_2_16(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(120);
        aRfProject.lintTrackP2LInfo(121);
    }

    @Override
    public void performCheckImpl() {
        Map<ParserPath, List<SVTBIssues>> firstLines = this.fOVMProject.getSVTBCharIssuesWithKind(SVTBCharParser.Config.DEFAULT, 120, true, this);
        Map<ParserPath, List<SVTBIssues>> lastLines = this.fOVMProject.getSVTBCharIssuesWithKind(SVTBCharParser.Config.DEFAULT, 121, true, this);
        HashSet filesToCheck = new LinkedHashSet<ParserPath>();
        if (this.pCheckOnlyFilesIncludedInPackageValue) {
            this.getAllFilesIncludedInPackages(filesToCheck);
        } else {
            filesToCheck = this.fOVMProject.getAllImportedFiles();
        }
        block7: for (ParserPath fileName : filesToCheck) {
            File file;
            int lastLineWithCode;
            int firstLineWithCode;
            List<SVTBIssues> lastLineIssues;
            List<SVTBIssues> firstLineIssues;
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileName, this) || (firstLineIssues = firstLines.get(fileName)) == null || firstLineIssues.size() != 1 || (lastLineIssues = lastLines.get(fileName)) == null || lastLineIssues.size() != 1 || (firstLineWithCode = firstLineIssues.get(0).getLine()) < 1 || (lastLineWithCode = lastLineIssues.get(0).getLine()) < 1 || !(file = new File(fileName.path)).canRead()) continue;
            try {
                Throwable throwable = null;
                Object var12_14 = null;
                try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                    String ifndefLine = null;
                    boolean lookForFirstLine = true;
                    int currentLine = 0;
                    String line = null;
                    while ((line = bufferedReader.readLine()) != null) {
                        ++currentLine;
                        if (lookForFirstLine) {
                            if (currentLine != firstLineWithCode) continue;
                            if (!line.contains("`ifndef")) continue block7;
                            ifndefLine = line;
                            lookForFirstLine = false;
                            continue;
                        }
                        if (currentLine != lastLineWithCode) continue;
                        if (!line.contains("`endif")) continue block7;
                        this.addHit(fileName, firstLineWithCode, "File contains include guard '" + ifndefLine + "'!", null);
                        continue block7;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public void getAllFilesIncludedInPackages(HashSet<ParserPath> filesIncludedInPackages) {
        VlogPreprocessingInfo preprocessingTable = this.fOVMProject.getRfProject().getPreprocessingTable();
        VlogFileInstance topFile = preprocessingTable.getTopFileInstance();
        if (topFile == null) {
            return;
        }
        this.collectIncludedFiles(topFile, filesIncludedInPackages);
    }

    private void collectIncludedFiles(VlogFileInstance root, HashSet<ParserPath> fAllFilesInIncludeOrder) {
        List<VlogFileInstance> files = root.getIncludedInstances();
        if (files != null && !files.isEmpty()) {
            for (VlogFileInstance file : files) {
                if (file.getSemanticScope() instanceof RfPackage) {
                    fAllFilesInIncludeOrder.add(file.getParserPath());
                }
                this.collectIncludedFiles(file, fAllFilesInIncludeOrder);
            }
        }
    }
}

