/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBCharParser;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.CodePreprocLineInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="20.1.41")
@CheckID(value="SVTB.2.16.1")
@CheckName(value="SVTB.2.16.1")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.CONDITIONAL_DIRECTIVE})
@CheckTitle(value="Banned `ifdef and `ifndef")
@CheckDescription(value="Do not use `ifdef and `ifndef compiler directives.\n\nThe only exception is when using compile guards.\n\nAllowed:\n`ifdef FILE_NAME_DEFINE\n ... // code here\n`endif // FILE_NAME_DEFINE\n\nNot allowed:\n ... // code here\n`ifdef EXAMPLE\n ... // code here\n`endif\n ... // code here")
public class Check_SVTB_2_16_1
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of allowed macro names.", name="allowedMacroNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pAllowedMacroNames;
    @CheckParameter(defaultValue="false", description="When true, check nested macros inside inactive blocks of code.", name="checkNestedMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckNestedMacros;
    @CheckParameter(defaultValue="", description="Comma separated list of allowed macro name patterns.", name="allowedMacroPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pAllowedMacroPatterns;
    protected static final int ERROR = -1;
    private static String IFDEF = "ifdef";
    private static String IFNDEF = "ifndef";
    private static String ENDIF = "endif";
    private static Set<String> allowedMacros = new HashSet<String>();
    private static Map<ParserPath, List<MacroInfo>> nestedMacros = new HashMap<ParserPath, List<MacroInfo>>();

    static {
        allowedMacros.add(IFDEF);
        allowedMacros.add(IFNDEF);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(120);
        aRfProject.lintTrackP2LInfo(121);
    }

    public Check_SVTB_2_16_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Map<ParserPath, Integer> firstLineByParserPath = this.getFirstLineByParserPath();
        Map<ParserPath, Integer> lastLineByParserPath = this.getLastLineByParserPath();
        Map<ParserPath, CollectedMacros> macros = this.handlePreprocessingTableMacros(firstLineByParserPath, lastLineByParserPath);
        this.addHitsOnMacros(macros);
    }

    private void addHitsOnMacros(Map<ParserPath, CollectedMacros> compilationGuards) {
        for (Map.Entry<ParserPath, CollectedMacros> entry : compilationGuards.entrySet()) {
            ParserPath path = entry.getKey();
            CollectedMacros value = entry.getValue();
            List<MacroInfo> macros = value.getMacros();
            for (MacroInfo macro : macros) {
                this.addHit(path, macro.getLine(), "`" + macro.getDirective() + " found at offset " + macro.getColumn() + " on line!", null);
            }
        }
    }

    private Map<ParserPath, CollectedMacros> handlePreprocessingTableMacros(Map<ParserPath, Integer> firstCodeLine, Map<ParserPath, Integer> lastCodeLine) {
        HashMap<ParserPath, CollectedMacros> compileGuards = new HashMap<ParserPath, CollectedMacros>();
        List<ParserPath> allFilesInProject = this.fOVMProject.getAllFilesInOrder();
        for (ParserPath path : allFilesInProject) {
            TreeSet<Integer> lines;
            Integer lastLine;
            this.notifyCheckAlive();
            CodePreprocFileInfo preprocInfo = this.fOVMProject.getRfProject().getPreprocessingTable().getCodePreprocFileInfos().get(path);
            if (preprocInfo == null) continue;
            compileGuards.putIfAbsent(path, new CollectedMacros());
            Integer firstLine = firstCodeLine.get(path);
            if (firstLine == null || (lastLine = lastCodeLine.get(path)) == null || (lines = preprocInfo.getLines()) == null) continue;
            for (Integer line : lines) {
                List<MacroInfo> nestedMacrosForPath;
                CodePreprocLineInfo info = preprocInfo.getInfo(line);
                String directive = this.getDirective(path, info);
                if (!this.isDirective(directive)) continue;
                boolean isPossibleCompileGuard = false;
                if (line.equals(firstLine) && directive.equals(IFNDEF)) {
                    ((CollectedMacros)compileGuards.get(path)).setFirst(info.getLine(), info.getColumn(), directive);
                    isPossibleCompileGuard = true;
                }
                if (line.equals(lastLine) && directive.equals(ENDIF)) {
                    ((CollectedMacros)compileGuards.get(path)).setLast(info.getLine(), info.getColumn(), directive);
                    isPossibleCompileGuard = true;
                }
                if (this.pCheckNestedMacros && (nestedMacrosForPath = nestedMacros.get(path)) != null) {
                    for (MacroInfo macroInfo : nestedMacrosForPath) {
                        ((CollectedMacros)compileGuards.get(path)).addMacro(macroInfo.getLine(), macroInfo.getColumn(), macroInfo.getDirective());
                    }
                }
                if (isPossibleCompileGuard || directive.equals(ENDIF)) continue;
                ((CollectedMacros)compileGuards.get(path)).addMacro(info.getLine(), info.getColumn(), directive);
            }
        }
        return compileGuards;
    }

    private boolean isDirective(String directive) {
        if (directive == null) {
            return false;
        }
        return allowedMacros.contains(directive) || directive.equals(ENDIF);
    }

    private Map<ParserPath, Integer> getFirstLineByParserPath() {
        Map<ParserPath, List<SVTBIssues>> lines = this.fOVMProject.getSVTBCharIssuesWithKind(SVTBCharParser.Config.DEFAULT, 120, true, this);
        return this.getLinesByParserPath(lines);
    }

    private Map<ParserPath, Integer> getLastLineByParserPath() {
        Map<ParserPath, List<SVTBIssues>> lines = this.fOVMProject.getSVTBCharIssuesWithKind(SVTBCharParser.Config.DEFAULT, 121, true, this);
        return this.getLinesByParserPath(lines);
    }

    private Map<ParserPath, Integer> getLinesByParserPath(Map<ParserPath, List<SVTBIssues>> lines) {
        Set<Map.Entry<ParserPath, List<SVTBIssues>>> entrySet = lines.entrySet();
        HashMap<ParserPath, Integer> result = new HashMap<ParserPath, Integer>();
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : entrySet) {
            SVTBIssues issue;
            ParserPath path = entry.getKey();
            List<SVTBIssues> lineList = entry.getValue();
            if (lineList == null || lineList.size() != 1 || (issue = lineList.get(0)) == null) continue;
            int line = issue.getLine();
            result.put(path, line);
        }
        return result;
    }

    public String getDirective(ParserPath path, CodePreprocLineInfo info) {
        int line = info.getLine();
        int column = info.getColumn();
        int type = info.getType();
        for (LiteralToken token : this.getWSParser().getTokensOnLine(path, line)) {
            if (token.getLineNumber() != line) continue;
            if (column >= (String.valueOf(token.getOffsetLine()) + token.getStringToken()).length() && token.isLastTokenOnLine()) {
                return ENDIF;
            }
            if (token.getOffsetLine() != column - 1) continue;
            String directive = token.getStringToken().substring(1);
            if ((directive.equals(IFDEF) || directive.equals(IFNDEF)) && (this.pAllowedMacroNames.contains(this.getWSParser().getNextToken(token, path).getStringToken()) || this.isMatchInSet(this.getWSParser().getNextToken(token, path).getStringToken()))) {
                return null;
            }
            if (!this.isDirective(directive)) continue;
            if (this.pCheckNestedMacros && type == 1) {
                this.checkNestedMacros(path, token);
            }
            return directive;
        }
        return null;
    }

    public void checkNestedMacros(ParserPath path, LiteralToken token) {
        LiteralToken currentToken = this.getWSParser().getNextToken(token, path);
        int openedMacros = 0;
        while (!(currentToken == null || currentToken.getStringToken().equals("`" + ENDIF) && openedMacros <= 0)) {
            LiteralToken nextToken = this.getWSParser().getNextToken(currentToken, path);
            if (nextToken == null) {
                return;
            }
            String directive = currentToken.getStringToken().substring(1);
            if (directive.equals(ENDIF)) {
                --openedMacros;
            } else if (this.isDirective(directive) && !nextToken.getStringToken().isEmpty()) {
                nestedMacros.putIfAbsent(path, new LinkedList());
                nestedMacros.get(path).add(new MacroInfo(currentToken.getLineNumber(), currentToken.getOffsetLine() + 1, directive));
            }
            currentToken = nextToken;
        }
    }

    private boolean isMatchInSet(String input) {
        for (Pattern pattern : this.pAllowedMacroPatterns) {
            if (!pattern.matcher(input).matches()) continue;
            return true;
        }
        return false;
    }

    static class CollectedMacros {
        private MacroInfo macroOnFirstLine;
        private MacroInfo macroOnLastLine;
        private List<MacroInfo> otherMacros = new ArrayList<MacroInfo>();

        CollectedMacros() {
        }

        public List<MacroInfo> getMacros() {
            if (this.macroOnFirstLine != null && this.macroOnLastLine != null) {
                return this.otherMacros;
            }
            if (this.macroOnLastLine == null && this.macroOnFirstLine != null) {
                this.otherMacros.add(this.macroOnFirstLine);
            }
            return this.otherMacros;
        }

        public void setFirst(int line, int column, String directive) {
            this.macroOnFirstLine = new MacroInfo(line, column, directive);
        }

        public void setLast(int line, int column, String directive) {
            this.macroOnLastLine = new MacroInfo(line, column, directive);
        }

        public void addMacro(int line, int column, String directive) {
            this.otherMacros.add(new MacroInfo(line, column, directive));
        }

        public int getFirstLine() {
            if (this.macroOnFirstLine == null) {
                return -1;
            }
            return this.macroOnFirstLine.getLine();
        }

        public int getLastLine() {
            if (this.macroOnLastLine == null) {
                return -1;
            }
            return this.macroOnLastLine.getLine();
        }
    }

    static class MacroInfo {
        private int line;
        private int column;
        private String directive;

        public MacroInfo(int line, int column, String directive) {
            this.line = line;
            this.column = column;
            this.directive = directive;
        }

        public int getLine() {
            return this.line;
        }

        public Integer getColumn() {
            return this.column;
        }

        public String getDirective() {
            return this.directive;
        }
    }
}

