/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.35")
@CheckID(value="SVTB.2.17")
@CheckName(value="SVTB.2.17")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.DIRECTIVE})
@CheckTitle(value="Do not use directives in files containing elements")
@CheckDescription(value="Do not use <directives> in files matching <filePatterns> containing any of the <elementKinds> declarations.\n\nCheck supports pre-waiving.")
public class Check_SVTB_2_17
extends OVMComplianceCheck {
    @CheckParameter(defaultValue=".*\\.svh", description="Specify which files to check. Comma separated list of patterns.", name="filePatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pFilePatterns;
    @CheckParameter(defaultValue="class", description="Comma separated list of elements that must be declared in a file in order to check that file for banned directives.", name="elementKinds", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pElementKinds;
    @CheckParameter(defaultValue="import, include", description="Comma separated list of banned directives: import, include.", name="directives", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pDirectives;

    public Check_SVTB_2_17(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(120);
        aRfProject.lintTrackP2LInfo(121);
    }

    @Override
    public void performCheckImpl() {
        List<ParserPath> allFilesInOrder = this.fOVMProject.getAllFilesInOrder();
        HashSet<ParserPath> filesOfInterest = new HashSet<ParserPath>();
        block2: for (ParserPath parserPath : allFilesInOrder) {
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            for (Pattern filePattern : this.pFilePatterns) {
                String filename;
                int beginIndex = parserPath.path.lastIndexOf(47);
                if (beginIndex == -1 || (filename = parserPath.path.substring(beginIndex + 1, parserPath.path.length())) == null || filename.isEmpty() || !filePattern.matcher(filename).matches()) continue;
                filesOfInterest.add(parserPath);
                continue block2;
            }
        }
        HashMap<ParserPath, HashMap<ParserPath, List<Integer>>> filesWithIncludes = new HashMap<ParserPath, HashMap<ParserPath, List<Integer>>>();
        if (this.pDirectives.contains("include")) {
            HashMap<ParserPath, HashMap<ParserPath, List<Integer>>> allFilesWithIncludes = this.fOVMProject.getAllFilesWithIncludes();
            filesWithIncludes.putAll(allFilesWithIncludes);
            filesWithIncludes.keySet().retainAll(filesOfInterest);
        }
        HashMap<ParserPath, HashSet<Integer>> filesWithImports = new HashMap<ParserPath, HashSet<Integer>>();
        if (this.pDirectives.contains("import")) {
            this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitorImplementation(filesOfInterest, filesWithImports));
        }
        HashMap<ParserPath, String> fileContainingElements = new HashMap<ParserPath, String>();
        if (!filesWithImports.isEmpty() || !filesWithIncludes.isEmpty()) {
            try {
                this.fOVMProject.getRfProject().accept(new IRfDefElementVisitorImplementation(filesOfInterest, fileContainingElements));
            }
            catch (Exception e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        for (Map.Entry entrySet : fileContainingElements.entrySet()) {
            HashSet<Integer> importLines = filesWithImports.get(entrySet.getKey());
            HashMap includeLines = (HashMap)filesWithIncludes.get(entrySet.getKey());
            if (importLines != null) {
                for (Integer n : importLines) {
                    this.addHit((ParserPath)entrySet.getKey(), n, "File containing " + (String)entrySet.getValue() + " uses 'import' directive!", null);
                }
            }
            if (includeLines == null) continue;
            for (Map.Entry entry : includeLines.entrySet()) {
                for (Integer includedLine : (List)entry.getValue()) {
                    this.addHit((ParserPath)entrySet.getKey(), includedLine, "File containing " + (String)entrySet.getValue() + " uses 'include' directive!", null);
                }
            }
        }
    }

    private final class IHidVisitorImplementation
    implements IHidVisitor<RfHidOperator> {
        private final HashSet<ParserPath> filesOfInterest;
        private final HashMap<ParserPath, HashSet<Integer>> filesWithImports;
        private ParserPath parserPath;

        private IHidVisitorImplementation(HashSet<ParserPath> filesOfInterest, HashMap<ParserPath, HashSet<Integer>> filesWithImports) {
            this.filesOfInterest = filesOfInterest;
            this.filesWithImports = filesWithImports;
        }

        public boolean visit(RfHidOperator hidOperator) {
            if (!this.filesOfInterest.contains(this.parserPath)) {
                return true;
            }
            if (!hidOperator.hasOccurrence(HidOperatorQualifier.IS_IMPORT)) {
                return true;
            }
            HashSet<Integer> entry = this.filesWithImports.get(this.parserPath);
            if (entry == null) {
                entry = new HashSet();
                entry.add(hidOperator.getOccurrence().getLine());
                this.filesWithImports.put(this.parserPath, entry);
            } else {
                entry.add(hidOperator.getOccurrence().getLine());
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }

    private final class IRfDefElementVisitorImplementation
    implements IRfDefElementVisitor {
        private final HashSet<ParserPath> filesOfInterest;
        private final HashMap<ParserPath, String> fileContainingElements;

        private IRfDefElementVisitorImplementation(HashSet<ParserPath> filesOfInterest, HashMap<ParserPath, String> fileContainingElements) {
            this.filesOfInterest = filesOfInterest;
            this.fileContainingElements = fileContainingElements;
        }

        @Override
        public boolean visit(RfDefElement defElement) throws Exception {
            return false;
        }

        @Override
        public void preVisit(RfDefElement defElement) throws Exception {
            RfFileDef defFile = defElement.getDefFile();
            if (defFile == null) {
                return;
            }
            Check_SVTB_2_17.this.notifyCheckAlive();
            if (this.fileContainingElements.containsKey(defFile.getParserPath())) {
                return;
            }
            if (!this.filesOfInterest.contains(defFile.getParserPath())) {
                return;
            }
            RfNamedElement namedElement = defElement.getNamedElement();
            if (Check_SVTB_2_17.this.pElementKinds.contains("class") && namedElement instanceof RfClass) {
                this.fileContainingElements.put(defFile.getParserPath(), "a class");
            } else if (Check_SVTB_2_17.this.pElementKinds.contains("module") && namedElement instanceof RfModule) {
                this.fileContainingElements.put(defFile.getParserPath(), "a module");
            } else if (Check_SVTB_2_17.this.pElementKinds.contains("package") && namedElement instanceof RfPackage) {
                this.fileContainingElements.put(defFile.getParserPath(), "a package");
            } else if (Check_SVTB_2_17.this.pElementKinds.contains("interface") && namedElement instanceof RfInterface) {
                this.fileContainingElements.put(defFile.getParserPath(), "an interface");
            }
        }

        @Override
        public void postVisit(RfDefElement defElement) throws Exception {
        }
    }
}

