/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;

@CheckVersion(value="19.1.50")
@CheckID(value="SVTB.2.18")
@CheckName(value="SVTB.2.18")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Directory and file name pattern")
@CheckDescription(value="The names of directories should match <dirPatterns> and the names of files should match <filePatterns>.\n\nCheck supports pre-waiving.")
public class Check_SVTB_2_18
extends OVMComplianceCheck {
    @CheckParameter(defaultValue=".*", description="Comma separated list of patterns for directory names.", name="dirPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pDirPatterns;
    @CheckParameter(defaultValue=".*\\.(sv|v)", description="Comma separated list of patterns for file names.", name="filePatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pFilePatterns;

    public Check_SVTB_2_18(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<ParserPath> files = this.fOVMProject.getAllFilesInOrder();
        HashSet<String> failedDirectories = new HashSet<String>();
        for (ParserPath parserPath : files) {
            File directoryFile;
            if (parserPath.path.indexOf("__vlog__") != -1) continue;
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            String fileFullPath = parserPath.path;
            File file = new File(fileFullPath);
            String fileName = file.getName();
            if (!this.fileHasMatch(fileName)) {
                this.addHit(parserPath, 0, "File " + fileName + " does not match any of the specified patterns for files!", null);
            }
            if ((directoryFile = file.getParentFile()) == null) continue;
            String directoryName = directoryFile.getName();
            String directoryPath = directoryFile.getPath();
            if (!failedDirectories.contains(directoryName) && this.directoryHasMatch(directoryName)) continue;
            this.addHit(new ParserPath(directoryPath), 0, "Directory " + directoryPath + " does not match any of the specified patterns for directories!", null);
            failedDirectories.add(directoryName);
        }
    }

    private boolean fileHasMatch(String file) {
        return this.isMatchInSet(file, this.pFilePatterns);
    }

    private boolean directoryHasMatch(String directory) {
        return this.isMatchInSet(directory, this.pDirPatterns);
    }

    private boolean isMatchInSet(String input, Set<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(input).matches()) continue;
            return true;
        }
        return false;
    }
}

