/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClassDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="20.1.1")
@CheckID(value="SVTB.2.19")
@CheckName(value="SVTB.2.19")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.FORWARD_TYPEDEF, RuleLabel.CLASS})
@CheckTitle(value="Add header typedefs for files with multiple classes ")
@CheckDescription(value="Files containing multiple classes should start by declaring forward typedefs for all the classes.\n\nCheck supports pre-waiving.")
public class Check_SVTB_2_19
extends OVMComplianceCheck {
    private Map<RfFileDef, Set<RfForwardTypedef>> typedefsInFileHeader = new HashMap<RfFileDef, Set<RfForwardTypedef>>();
    private Map<RfFileDef, Integer> classesInFile = new HashMap<RfFileDef, Integer>();
    @CheckParameter(defaultValue="false", description="When true, the classes declared inside macros are skipped.", name="skipClassesDeclaredInMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipClassesDeclaredInMacros;

    public Check_SVTB_2_19(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.typedefsInFileHeader.clear();
        this.classesInFile.clear();
        for (RfNamedElement element : this.fOVMProject.getAllNonXVMClasses()) {
            ParserPath parserPath;
            RfClass current;
            RfFileDef file;
            if (!(element instanceof RfClass) || (file = (current = (RfClass)element).getFile()) == null || (parserPath = file.getParserPath()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            this.notifyCheckAlive();
            this.computeTypedefsAndNumberOfClasses(file);
            Integer nrOfClasses = this.classesInFile.get(file);
            if (nrOfClasses < 2) continue;
            RfForwardTypedef declaration = current.getTypedefDeclaration();
            if (declaration == null) {
                this.addHit(element, "Class '" + LintUtils.getNamedElementFullName(current) + "' does not have a corresponding typedef in the file!");
                continue;
            }
            Set<RfForwardTypedef> typedefsInHeader = this.typedefsInFileHeader.get(file);
            if (typedefsInHeader.contains(declaration)) continue;
            this.addHit(element, "Class '" + LintUtils.getNamedElementFullName(current) + "' should be declared at the beginning of the file using a forward typedef!");
        }
    }

    private void computeTypedefsAndNumberOfClasses(RfFileDef file) {
        if (this.classesInFile.containsKey(file) && this.typedefsInFileHeader.containsKey(file)) {
            return;
        }
        int numberOfClasses = 0;
        Collection<RfDefElement> defElements = file.getChildren();
        if (defElements == null || defElements.isEmpty()) {
            return;
        }
        HashSet<RfForwardTypedef> typedefsInHeader = new HashSet<RfForwardTypedef>();
        boolean collectTypedefs = true;
        for (RfDefElement defElement : defElements) {
            if (defElement.getReparseInfo() != null) {
                RfNamedElement element = defElement.getNamedElement();
                if (this.pSkipClassesDeclaredInMacros || this.fOVMProject.isOVMElement(element)) continue;
            }
            if (collectTypedefs) {
                RfNamedElement namedElement = defElement.getNamedElement();
                if (!(namedElement instanceof RfForwardTypedef)) {
                    collectTypedefs = false;
                } else {
                    typedefsInHeader.add((RfForwardTypedef)namedElement);
                }
            }
            if (!(defElement instanceof RfClassDef)) continue;
            ++numberOfClasses;
        }
        this.classesInFile.put(file, numberOfClasses);
        this.typedefsInFileHeader.put(file, typedefsInHeader);
    }
}

