/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.2.2")
@CheckName(value="SVTB.2.2")
@CheckLabel(labels={RuleLabel.FILE})
@CheckTitle(value="Use only legal file extensions")
@CheckDescription(value="Use 'allowedExtensions' for source code files.\n\nCheck supports pre-waiving.")
public class Check_SVTB_2_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue=".sv, .svh", description="Comma separated list of allowed extensions.", name="allowedExtensions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pAllowedExtensionsValue;
    @CheckParameter(defaultValue="included_and_top", description="Specify which files to check, included, top or included_and_top files.", name="checkFiles", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    protected String pCheckFiles;
    @CheckParameter(defaultValue="", description="Comma separated list of include scopes to be checked: module, interface, package, class. All the files included in the specified scopes must have an allowed extension.When empty, all included files are checked.", name="checkIncludedScopes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pCheckIncludedScopes;

    public Check_SVTB_2_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if ("top".equals(this.pCheckFiles)) {
            this.checkFiles(this.fOVMProject.getAllTopFiles(), "Top");
        } else if ("included".equals(this.pCheckFiles)) {
            this.checkFiles(this.getIncludedFiles(this.fOVMProject.getAllIncludedFiles()), "Included");
        } else if ("included_and_top".equals(this.pCheckFiles)) {
            HashSet<ParserPath> topFiles = new HashSet<ParserPath>(this.fOVMProject.getAllTopFiles());
            HashSet<ParserPath> includedFiles = new HashSet<ParserPath>(this.getIncludedFiles(this.fOVMProject.getAllIncludedFiles()));
            HashSet<ParserPath> bothFiles = new HashSet<ParserPath>(topFiles);
            bothFiles.retainAll(includedFiles);
            topFiles.removeAll(bothFiles);
            includedFiles.removeAll(bothFiles);
            this.checkFiles(topFiles, "Top");
            this.checkFiles(includedFiles, "Included");
            this.checkFiles(bothFiles, "Top and included");
        }
    }

    private Set<ParserPath> getIncludedFiles(HashMap<ParserPath, Set<Class<? extends RfNamedElement>>> allIncludedFiles) {
        if (this.pCheckIncludedScopes.isEmpty()) {
            return allIncludedFiles.keySet();
        }
        HashSet<ParserPath> result = new HashSet<ParserPath>();
        HashSet<Class> checkedScopes = new HashSet<Class>();
        if (this.pCheckIncludedScopes.contains("module")) {
            checkedScopes.add(RfModule.class);
        }
        if (this.pCheckIncludedScopes.contains("interface")) {
            checkedScopes.add(RfInterface.class);
        }
        if (this.pCheckIncludedScopes.contains("class")) {
            checkedScopes.add(RfClass.class);
        }
        if (this.pCheckIncludedScopes.contains("package")) {
            checkedScopes.add(RfPackage.class);
        }
        for (Map.Entry<ParserPath, Set<Class<? extends RfNamedElement>>> entry : allIncludedFiles.entrySet()) {
            if (Collections.disjoint((Collection)entry.getValue(), checkedScopes)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    void checkFiles(Set<ParserPath> files, String kind) {
        String allowedExtensionsString = StringUtils.join(this.pAllowedExtensionsValue, (String)", ");
        for (ParserPath parserPath : files) {
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            this.notifyCheckAlive();
            boolean hasAllowedExtension = false;
            for (String allowedExtension : this.pAllowedExtensionsValue) {
                if (!parserPath.path.endsWith(allowedExtension)) continue;
                hasAllowedExtension = true;
                break;
            }
            if (hasAllowedExtension) continue;
            this.addHit(parserPath, 0, String.valueOf(kind) + " file is not using one of the allowed extensions '" + allowedExtensionsString + "'!", null);
        }
    }
}

