/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.universalchardet.UniversalDetector;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;

@CheckVersion(value="20.1.36")
@CheckID(value="SVTB.2.20")
@CheckName(value="SVTB.2.20")
@CheckLabel(labels={RuleLabel.FILE})
@CheckTitle(value="File encoding must be the same in all files")
@CheckDescription(value="All files must have the same encoding. Some tools may have issues processing files with different encodings.\n\nImplementation Notes:\nThis check finds the most frequently used file encoding in the project and considers it as reference.\n\nCheck supports pre-waiving.")
public class Check_SVTB_2_20
extends OVMComplianceCheck {
    public Check_SVTB_2_20(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<ParserPath> files = this.fOVMProject.getAllFilesInOrder();
        HashMap<String, Integer> encodings = new HashMap<String, Integer>();
        HashMap<ParserPath, String> encodingForFile = new HashMap<ParserPath, String>();
        for (ParserPath parserPath : files) {
            this.notifyCheckAlive();
            try {
                File file;
                String encoding;
                if (parserPath.path.indexOf("__vlog__") != -1 || this.checkPreWaivers(parserPath) || (encoding = UniversalDetector.detectCharset((File)(file = new File(parserPath.getCanonicalPath())))) == null) continue;
                encodingForFile.put(parserPath, encoding);
                encodings.putIfAbsent(encoding, 0);
                Integer count = (Integer)encodings.get(encoding);
                encodings.put(encoding, count + 1);
            }
            catch (FileNotFoundException e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            catch (IOException e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        Integer mostOccurences = 0;
        Integer allOccurences = 0;
        String encodingMostOccured = "";
        for (Map.Entry pair : encodings.entrySet()) {
            allOccurences = allOccurences + (Integer)pair.getValue();
            if ((Integer)pair.getValue() <= mostOccurences) continue;
            mostOccurences = (Integer)pair.getValue();
            encodingMostOccured = (String)pair.getKey();
        }
        for (Map.Entry pair : encodingForFile.entrySet()) {
            if (((String)pair.getValue()).equals(encodingMostOccured)) continue;
            this.addHit((ParserPath)pair.getKey(), 0, "Encoding: " + (String)pair.getValue() + " is differrent than the most frequently used " + encodingMostOccured + "!", null);
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

