/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.DVTProblemMatcher;
import ro.amiq.dvt.model.problems.VlogProblemKinds;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;

@CheckVersion(value="20.1.39")
@CheckID(value="SVTB.2.21")
@CheckName(value="SVTB.2.21")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.CONDITIONAL_DIRECTIVE})
@CheckTitle(value="Conditional preprocessing blocks must not cross file boundaries")
@CheckDescription(value="`ifdef/`ifndef compiler directives should have their corresponding `endif directive in the same file.")
public class Check_SVTB_2_21
extends OVMComplianceCheck {
    public Check_SVTB_2_21(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String noEndIfErrorMessage = "No matching `endif (unexpected EOF)";
        String noIfDefErrorMessage = "Unexpected `endif (no starting `ifdef/`ifndef found)";
        String noIfDefForElseErrorMessage = "Unexpected `else (no starting `ifdef/`ifndef found)";
        Collection allSyntaxErrors = DVTProblemManager.getInstance().getAllProblems(this.getIProject(), DVTProblemMatcher.all().setKind(VlogProblemKinds.SYNTAX_ERROR.getId()), null);
        for (DVTProblem issue : allSyntaxErrors) {
            String issueMessage = this.getIssueMessage(issue);
            ParserPath parserPath = new ParserPath(issue.getPath());
            int line = issue.getLine();
            if (issueMessage.equals(noEndIfErrorMessage)) {
                this.addHit(parserPath, line, "No matching `endif found in file: " + LintUtils.getFileShortName(parserPath.path) + "!", null);
                continue;
            }
            if (issueMessage.equals(noIfDefErrorMessage)) {
                this.addHit(parserPath, line, "No matching `ifdef/`ifndef found in file: " + LintUtils.getFileShortName(parserPath.path) + "!", null);
                continue;
            }
            if (!issueMessage.equals(noIfDefForElseErrorMessage)) continue;
            this.addHit(parserPath, line, "No matching `ifdef/`ifndef found in file: " + LintUtils.getFileShortName(parserPath.path) + "!", null);
        }
    }

    private String getIssueMessage(DVTProblem issue) {
        String message = issue.getMessage();
        if (message.contains(": ")) {
            message = message.substring(message.indexOf(": ") + 2);
        }
        return message;
    }
}

