/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClassDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInterfaceDef;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModuleDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPackageDef;
import ro.amiq.vlogdt.model.reflection.RfProgramDef;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.2.3")
@CheckName(value="SVTB.2.3")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Filename must match the defined entity name")
@CheckDescription(value="Filename must match the defined entity name.\n\nExamples:\nA file that contains class \"packet\" must be named packet.sv\nA file that contains module \"clockgen\" must be named clockgen.sv\nA file that contains package \"collection_pkg\" must be named collection_pkg.sv, when the purpose of the file is to collect a number of classes declared in separate files into a package using includes.\nA file named \"my_file.sv\" that contains package \"my_pkg\" with 2 member classes: \"my_cls1\" and \"my_cls2\" will flag each class and package accordingly\n\tIf the skipClassesInPackages parameter is set to true in the previous example, the name of the file should have been \"my_pkg.sv\"\n\nException: A package \"classy_pkg\" file that contains a declaration and implementation of ONLY ONE class \"classy\" must be named classy.sv\n\nExamples:\nmy_file.sv:\n\npackage my_pkg;// NOT ALLOWED iff skipClassesInPackages is true\n  class my_class; // NOT ALLOWED my_class.sv != my_file.sv\n  endclass\nendpackage\n\nCheck supports pre-waiving.")
public class Check_SVTB_2_3
extends OVMComplianceCheck {
    @CheckParameter(defaultValue=".sv, .svh", description="Comma separated list of allowed extensions.", name="allowedExtensions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pAllowedExtensionsValue;
    @CheckParameter(defaultValue="", description="Apply only for elements of type 'module, interface, program, package, class'. If empty, all elements with the exception of programs are checked.", name="elementKinds", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pElementKindsValue;
    @CheckParameter(defaultValue="false", description="When true, the check enforces name matching only for files with single element kind", name="checkFilesWithSingleElementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckFilesWithSingleElementKind;
    @CheckParameter(defaultValue="false", description="When true, the children of a class are allowed in the same file with the class.", name="allowChildren", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowChildren;
    @CheckParameter(defaultValue="false", description="When true, the naming exception for classes inside  packages is skipped, and the file should take the name of the enclosing package.", name="skipClassesInPackages", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipClassesInPackages;
    @CheckParameter(defaultValue="", description="Comma separated list of regex that match the file name for library files.", name="libraryFilePatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pLibraryFilePatterns;
    private Map<ParserPath, RfClass> pathToTopClass;

    public Check_SVTB_2_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        ParserPath parserPath;
        RfFileDef file;
        this.pathToTopClass = new HashMap<ParserPath, RfClass>();
        NullProtectedList<RfNamedElement> allComponents = new NullProtectedList<RfNamedElement>();
        if (this.pElementKindsValue.isEmpty() || this.pElementKindsValue.contains("class")) {
            allComponents.addAll(this.fOVMProject.getAllNonXVMClasses());
        }
        if (this.pElementKindsValue.isEmpty() || this.pElementKindsValue.contains("module")) {
            allComponents.addAll(this.fOVMProject.getAllModules());
        }
        if (this.pElementKindsValue.isEmpty() || this.pElementKindsValue.contains("interface")) {
            allComponents.addAll(this.fOVMProject.getAllInterfaces());
        }
        if (this.pElementKindsValue.contains("program")) {
            allComponents.addAll(this.fOVMProject.getAllPrograms());
        }
        if (allComponents.isEmpty() && this.fOVMProject.getAllPackages().isEmpty()) {
            return;
        }
        HashMap<ParserPath, List<RfClass>> pathToClass = new HashMap<ParserPath, List<RfClass>>();
        if (!this.pLibraryFilePatterns.isEmpty() && this.pAllowChildren) {
            for (RfNamedElement component : allComponents) {
                if (!(component instanceof RfClass)) continue;
                ParserPath parserPath2 = component.getFile().getParserPath();
                if (!pathToClass.containsKey(parserPath2)) {
                    pathToClass.put(parserPath2, new ArrayList<RfClass>(Arrays.asList((RfClass)component)));
                    continue;
                }
                ((List)pathToClass.get(parserPath2)).add((RfClass)component);
            }
        }
        boolean isChild = false;
        for (RfNamedElement component : allComponents) {
            this.notifyCheckAlive();
            if (component == null || (file = component.getFile()) == null) continue;
            parserPath = file.getParserPath();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            RfNamedElement enclScope = component.getEnclosingScope();
            String filename = component.getDeclaration().getDefFile().getName();
            if (this.pSkipClassesInPackages && component instanceof RfClass && enclScope instanceof RfPackage && filename.equals(enclScope.getDeclaration().getDefFile().getName())) continue;
            StringBuilder hitMessage = new StringBuilder("");
            if (!this.pLibraryFilePatterns.isEmpty() && this.pAllowChildren && this.checkForBaseClass(component, filename, pathToClass, this.pathToTopClass, parserPath, hitMessage) || !(enclScope instanceof RfLibrary) && !(enclScope instanceof RfPackage) && enclScope.getFile().getParserPath().equals((Object)parserPath) || this.checkFileName(filename, this.pAllowedExtensionsValue, component.getName()) || this.pCheckFilesWithSingleElementKind && !this.isSingleElementKindInFile(file)) continue;
            isChild = false;
            if (this.pAllowChildren && component instanceof RfClass) {
                RfClass clazz = (RfClass)component;
                RfClass topClass = this.findTopClass(clazz);
                if (topClass == null) {
                    topClass = clazz;
                }
                if (this.checkFileName(topClass.getFile().getName(), this.pAllowedExtensionsValue, topClass.getName()) || !clazz.equals(topClass) && LintUtils.isSubClassOf(clazz, topClass)) {
                    isChild = true;
                }
            }
            if (hitMessage.isEmpty()) {
                if (enclScope instanceof RfPackage && filename.equals(enclScope.getDeclaration().getDefFile().getName()) && enclScope.getClassesWithPrefix("", 2, 1).size() > 1) {
                    hitMessage.append("Filename '" + filename + "' does not match the name of '" + component.getName() + "', the class must be declared in its own file!");
                } else {
                    hitMessage.append("Filename '" + filename + "' does not match the name of '" + component.getName() + "'!");
                }
            }
            if (this.pAllowChildren && (!this.pAllowChildren || isChild)) continue;
            this.addHit(component, hitMessage.toString());
        }
        if (this.pElementKindsValue.isEmpty() || this.pElementKindsValue.contains("package")) {
            for (RfPackage pack : this.fOVMProject.getAllPackages()) {
                boolean checkPackage;
                this.notifyCheckAlive();
                if (pack == null || (file = pack.getFile()) == null) continue;
                parserPath = file.getParserPath();
                if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
                String filename = pack.getDeclaration().getDefFile().getName();
                List<RfClass> classes = pack.getClassesWithPrefix("", 2, 1);
                boolean bl = checkPackage = classes.size() != 1 || !filename.equals(classes.get(0).getDeclaration().getDefFile().getName());
                if (!this.pSkipClassesInPackages && !checkPackage || this.checkFileName(filename, this.pAllowedExtensionsValue, pack.getName())) continue;
                String hitMessage = "Filename '" + filename + "' does not match package '" + pack.getName() + "' name!";
                if (this.pCheckFilesWithSingleElementKind && !this.isSingleElementKindInFile(file)) continue;
                this.addHit(pack, hitMessage);
            }
        }
    }

    private RfClass findTopClass(RfClass clazz) {
        ParserPath parserPath = clazz.getDeclaration().getParserPath();
        RfClass topClass = this.pathToTopClass.get(parserPath);
        if (topClass == null) {
            while (clazz.getParent() != null) {
                if ((clazz = clazz.getParent()).getFile().getParserPath() != parserPath) continue;
                topClass = clazz.getGenericClass();
            }
            this.pathToTopClass.put(parserPath, topClass);
        }
        return topClass;
    }

    private boolean checkForBaseClass(RfNamedElement component, String filename, Map<ParserPath, List<RfClass>> pathToClass, Map<ParserPath, RfClass> pathToTopClass, ParserPath parserPath, StringBuilder hitMessage) {
        if (pathToClass.isEmpty()) {
            return false;
        }
        if (component instanceof RfClass) {
            RfClass baseClass = (RfClass)component;
            ParserPath file = component.getFile().getParserPath();
            if (file == null || pathToClass.get(file).size() <= 1) {
                return false;
            }
            int noOfChildren = this.getChildrenFromSameFile(pathToClass.get(file), baseClass);
            if (noOfChildren != 0) {
                if (pathToClass.get(file).size() != noOfChildren) {
                    return false;
                }
                if (pathToTopClass.get(parserPath) == null) {
                    pathToTopClass.put(parserPath, baseClass);
                }
                for (Pattern pattern : this.pLibraryFilePatterns) {
                    if (!pattern.matcher(filename).matches()) continue;
                    return true;
                }
                hitMessage.append("Filename '" + filename + "' does not match any of the specified patterns '" + DVTStringUtil.join(this.pLibraryFilePatterns, (String)",") + "' name!");
                this.addHit(component, hitMessage.toString());
                return true;
            }
        }
        return false;
    }

    private int getChildrenFromSameFile(List<RfClass> classes, RfClass baseClass) {
        int noOfChildren = 0;
        for (RfClass clazz : classes) {
            if (!LintUtils.isSubClassOf(clazz, baseClass)) continue;
            ++noOfChildren;
        }
        return noOfChildren;
    }

    private boolean isSingleElementKindInFile(RfFileDef file) {
        Collection<RfDefElement> defElems = file.getChildren();
        if (defElems == null || defElems.isEmpty()) {
            return true;
        }
        HashSet defElementSet = new HashSet();
        for (RfDefElement defElem : defElems) {
            if (!(defElem instanceof RfClassDef) && !(defElem instanceof RfPackageDef) && !(defElem instanceof RfModuleDef) && !(defElem instanceof RfInterfaceDef) && !(defElem instanceof RfProgramDef)) continue;
            defElementSet.add(defElem.getClass());
        }
        return defElementSet.size() <= 1;
    }

    private boolean checkFileName(String aFileName, Set<String> aAllowedExtensions, String aEntityName) {
        if (aFileName == null || aAllowedExtensions == null || aEntityName == null) {
            return false;
        }
        boolean ok = false;
        for (String allowedExtension : aAllowedExtensions) {
            if (allowedExtension == null || !aFileName.equals(String.valueOf(aEntityName) + allowedExtension)) continue;
            ok = true;
            break;
        }
        return ok;
    }
}

