/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypeAliasDef;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.2.5")
@CheckName(value="SVTB.2.5")
@CheckTitle(value="Forward typedef class declaration")
@CheckDescription(value="Use typedef for required classes from the same package.\nIf class requires a forward declaration due to any dependency, a \"typedef class\" statement should be added immediately before class declaration.\nFor example:\nIn class_b.sv:\ntypdef class class_a;\nclass class_b;\nclass_a m_a_h;\nendclass: class_b\nIn class_a.sv\ntypdef class class_b;\nclass class_a;\nclass_b m_b_h;\nendclass: class_a\n\nImplementation Notes:\nThe rule fails if:\n- An unknown type is used\n- A class type is used, but it is defined later in the compilation order, without being forward declared using typedef\n- The typedef is not placed immediately before the class that uses it\n\nExtern functions or tasks are checked at the declaration time.")
public class Check_SVTB_2_5
extends OVMComplianceCheck {
    private Map<ParserPath, List<SVTBIssues>> fAllTypedefClassIssues;
    private HashSet<SVTBIssues> fVerifiedTypedefClasses;

    public Check_SVTB_2_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(119);
    }

    @Override
    public void performCheckImpl() {
        this.fAllTypedefClassIssues = this.fOVMProject.getSVTBIssuesWithKind(119);
        this.fVerifiedTypedefClasses = new HashSet();
        for (RfNamedElement eachNamedElement : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            RfClass eachClass = (RfClass)eachNamedElement;
            if (eachClass.getDeclaration() == null) continue;
            int eachClassFileIndex = this.getFileIndex(eachClass.getFile().getParserPath());
            this.checkDataType(eachClass.getExtendedType(), eachClass, eachClass, eachClassFileIndex, eachClass.getLine(), null);
            this.checkElements(eachClass.getFields(), eachClass, eachClassFileIndex, null);
            this.checkElements(eachClass.getTypeAliases(), eachClass, eachClassFileIndex, null);
            this.checkElements(eachClass.getParametersWithPrefix("", 128, 2, 1), eachClass, eachClassFileIndex, null);
            this.checkFunctions(eachClass.getConstructorsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE), eachClass, eachClassFileIndex);
            this.checkFunctions(eachClass.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE), eachClass, eachClassFileIndex);
            this.checkFunctions(eachClass.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE), eachClass, eachClassFileIndex);
        }
    }

    private void checkElements(Collection<? extends RfNamedElement> aElements, RfClass aInsideClass, int aInsideClassFileIndex, RfDefElement aFunctionImpl) {
        if (aElements == null) {
            return;
        }
        for (RfNamedElement rfNamedElement : aElements) {
            if (rfNamedElement.isPredefined() || rfNamedElement instanceof RfResultImplicitVariable || rfNamedElement instanceof RfField var7_7 && eachField.isFromEmbeddedCovergroupDef() || !(rfNamedElement instanceof RfAssociatedType)) continue;
            this.checkDataType(((RfAssociatedType)rfNamedElement).getDataType(), rfNamedElement, aInsideClass, aInsideClassFileIndex, rfNamedElement.getLine(), aFunctionImpl);
        }
    }

    private void checkFunctions(Collection<RfFunction> aFunctions, RfClass aInsideClass, int aInsideClassFileIndex) {
        if (aFunctions == null) {
            return;
        }
        for (RfFunction eachFunction : aFunctions) {
            this.notifyCheckAlive();
            if (eachFunction.isPredefined()) continue;
            if (eachFunction.isFunction()) {
                this.checkDataType(eachFunction.getDataType(), eachFunction, aInsideClass, aInsideClassFileIndex, eachFunction.getLine(), null);
            }
            RfDefElement functionImpl = eachFunction.getImplementation();
            int functionImplFileIndex = aInsideClassFileIndex;
            if (eachFunction.isExtern()) {
                if (functionImpl != null) {
                    functionImplFileIndex = this.getFileIndex(functionImpl.getParserPath());
                    this.checkElements(eachFunction.getVarsWithPrefix(functionImpl.getEndOffset(), "", 2), aInsideClass, functionImplFileIndex, functionImpl);
                    this.checkBlocks(eachFunction.getLocalMembers(RfActionBlock.class), aInsideClass, functionImplFileIndex, functionImpl);
                }
            } else {
                functionImpl = eachFunction.getDeclaration();
                if (functionImpl != null) {
                    this.checkElements(eachFunction.getVarsWithPrefix(functionImpl.getEndOffset(), "", 2), aInsideClass, functionImplFileIndex, null);
                    this.checkBlocks(eachFunction.getLocalMembers(RfActionBlock.class), aInsideClass, functionImplFileIndex, null);
                }
            }
            this.checkElements(eachFunction.getArgumentsWithPrefix("", 2), aInsideClass, aInsideClassFileIndex, null);
        }
    }

    private void checkBlocks(Collection<RfActionBlock> aBlocks, RfClass aInsideClass, int aInsideClassFileIndex, RfDefElement aFunctionImpl) {
        if (aBlocks == null) {
            return;
        }
        for (RfActionBlock elem : aBlocks) {
            this.notifyCheckAlive();
            if (elem.getDeclaration() != null) {
                this.checkElements(elem.getLocalVarsWithPrefix(elem.getDeclaration().getEndOffset(), "", 2), aInsideClass, aInsideClassFileIndex, aFunctionImpl);
            }
            this.checkBlocks(elem.getLocalMembers(RfActionBlock.class), aInsideClass, aInsideClassFileIndex, aFunctionImpl);
        }
    }

    private void checkDataType(DataType aDT, RfNamedElement aUsedElement, RfClass aInsideClass, int aInsideClassFileIndex, int aUsedAtLine, RfDefElement aFunctionImpl) {
        Map<String, ArgInfo> namedParams;
        List<DataType> orderedParams;
        if (aDT == null || aDT.getType() == null || aDT.getType().length() == 0) {
            return;
        }
        if (aDT.isVirtualInterface()) {
            return;
        }
        if (aDT.getPackageScope() != null) {
            return;
        }
        RfNamedElement usedElementType = this.checkTypeName(aDT.getType(), aDT.isEscaped(), aUsedElement, aInsideClass, aInsideClassFileIndex, aUsedAtLine, aFunctionImpl);
        if (usedElementType != null && usedElementType instanceof RfTypeAlias) {
            aDT.setParamAssignments(((RfTypeAlias)usedElementType).getDataType());
        }
        if ((orderedParams = aDT.getOrderedParamAssignments()) != null) {
            for (DataType odt : orderedParams) {
                this.checkDataType(odt, aUsedElement, aInsideClass, aInsideClassFileIndex, aUsedAtLine, aFunctionImpl);
            }
        }
        if ((namedParams = aDT.getNamedParamAssignments()) != null) {
            for (ArgInfo ndt : namedParams.values()) {
                this.checkDataType(ndt.getDataType(), aUsedElement, aInsideClass, aInsideClassFileIndex, aUsedAtLine, aFunctionImpl);
            }
        }
    }

    protected boolean isSimpleIdentifier(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        return Character.isJavaIdentifierStart(str.charAt(0));
    }

    private RfNamedElement checkTypeName(String aDTType, boolean isEscaped, RfNamedElement aUsedElement, RfClass aInsideClass, int aInsideClassFileIndex, int aUsedAtLine, RfDefElement aFunctionImpl) {
        if (aDTType.startsWith("enum/") || aDTType.startsWith("union/") || aDTType.startsWith("struct/") || "void".equals(aDTType)) {
            return null;
        }
        if (!isEscaped && !this.isSimpleIdentifier(aDTType)) {
            return null;
        }
        RfNamedElement usedElementType = LintUtils.getTypeFromString(aInsideClass, aDTType, false);
        if (usedElementType == null) {
            usedElementType = aInsideClass.getParameterWithPrefix(aDTType, 128, 1, 3);
        }
        if (usedElementType == null) {
            this.addHit(aUsedElement, "'" + aDTType + "' is unknown");
            return null;
        }
        if (!(usedElementType instanceof RfClass)) {
            return usedElementType;
        }
        if (usedElementType.getDeclaration() == null) {
            return usedElementType;
        }
        if (!this.areInTheSamePackage(aInsideClass, (RfClass)usedElementType)) {
            return usedElementType;
        }
        int usedElementTypeFileIndex = this.getFileIndex(usedElementType.getFile().getParserPath());
        if (usedElementTypeFileIndex < aInsideClassFileIndex) {
            return usedElementType;
        }
        if (usedElementTypeFileIndex == aInsideClassFileIndex && usedElementType.getLine() < aUsedAtLine) {
            return usedElementType;
        }
        RfFileDef typedefBeforeFile = null;
        int typedefBeforeLine = -1;
        int typedefBeforeOffset = -1;
        if (aFunctionImpl != null) {
            typedefBeforeFile = aFunctionImpl.getDefFile();
            typedefBeforeLine = aFunctionImpl.getStartLine();
            typedefBeforeOffset = aFunctionImpl.getStartOffset();
        } else {
            RfDefElement declaration = aInsideClass.getDeclaration();
            if (declaration == null) {
                return null;
            }
            typedefBeforeFile = declaration.getDefFile();
            typedefBeforeLine = declaration.getStartLine();
            typedefBeforeOffset = declaration.getStartOffset();
        }
        SVTBIssues typedefClass = this.getTypedefClassInFileBeforeLine(typedefBeforeFile.getParserPath(), typedefBeforeLine, usedElementType.getName());
        if (typedefClass == null) {
            this.addHit(aUsedElement, "'typedef class " + usedElementType.getName() + "' needed before this use");
            return usedElementType;
        }
        if (this.fVerifiedTypedefClasses.contains(typedefClass)) {
            return usedElementType;
        }
        this.fVerifiedTypedefClasses.add(typedefClass);
        if (this.anyDefElementsBetweenLines(typedefBeforeFile, typedefClass.getLine(), typedefClass.getOffset(), typedefBeforeLine, typedefBeforeOffset)) {
            if (aFunctionImpl != null) {
                this.addHit(aUsedElement, "'typedef class " + aDTType + "' should be placed immediately before function implementation '" + aInsideClass.getName() + "::" + aFunctionImpl.getName() + "' that uses it");
            } else {
                this.addHit(aUsedElement, "'typedef class " + aDTType + "' should be placed immediately before class '" + aInsideClass.getName() + "' that uses it");
            }
        }
        return usedElementType;
    }

    private int getFileIndex(ParserPath fileFullPath) {
        List<ParserPath> allFilesInOrder = this.fOVMProject.getAllFilesInOrder();
        if (allFilesInOrder == null) {
            return -1;
        }
        return allFilesInOrder.indexOf(fileFullPath);
    }

    private RfPackage getPackage(RfClass classs) {
        RfNamedElement scope = classs.getEnclosingScope();
        while (scope != null) {
            if (scope instanceof RfPackage) {
                return (RfPackage)scope;
            }
            scope = scope.getEnclosingScope();
        }
        return null;
    }

    private boolean areInTheSamePackage(RfClass class1, RfClass class2) {
        RfPackage package1 = this.getPackage(class1);
        RfPackage package2 = this.getPackage(class2);
        if (package1 == null && package2 == null) {
            return true;
        }
        if (package1 == null || package2 == null) {
            return false;
        }
        return package1.equals(package2);
    }

    private SVTBIssues getTypedefClassInFileBeforeLine(ParserPath parserPath, int line, String className) {
        if (this.fAllTypedefClassIssues == null) {
            return null;
        }
        List<SVTBIssues> issues = this.fAllTypedefClassIssues.get(parserPath);
        if (issues == null || issues.isEmpty()) {
            return null;
        }
        for (SVTBIssues issue : issues) {
            if (issue.getLine() >= line || !className.equals(issue.getInfo())) continue;
            return issue;
        }
        return null;
    }

    private boolean anyDefElementsBetweenLines(RfFileDef file, int typedefLine, int typedefOffset, int useClassLine, int useClassOffset) {
        if (typedefLine == useClassLine) {
            return false;
        }
        if (useClassLine - typedefLine == 1) {
            return false;
        }
        RfDefElement defScope = file.getScope(typedefOffset, true);
        if (!(defScope instanceof RfFileDef) && defScope.getEndOffset() < useClassOffset) {
            return true;
        }
        Collection<RfDefElement> fileChildren = defScope.getChildren();
        if (fileChildren == null || fileChildren.isEmpty()) {
            return false;
        }
        for (RfDefElement child : fileChildren) {
            int childStartLine;
            if (child instanceof RfTypeAliasDef && ((RfTypeAliasDef)child).isForwardTypeDef() || (childStartLine = child.getStartLine()) <= typedefLine || childStartLine >= useClassLine) continue;
            return true;
        }
        return false;
    }
}

