/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractOneEntityPerFileCheck;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.2.6")
@CheckName(value="SVTB.2.6")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.CLASS, RuleLabel.INTERFACE, RuleLabel.PACKAGE, RuleLabel.MODULE})
@CheckTitle(value="Only One class, interface, package, or module per File")
@CheckDescription(value="All files shall contain one and only one class, interface, package, or module.\nExtern implementations are not checked.\n\nCheck supports pre-waiving.")
public class Check_SVTB_2_6
extends AbstractOneEntityPerFileCheck {
    public Check_SVTB_2_6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashMap<ParserPath, ArrayList<RfNamedElement>> fileEntitiesMap = new HashMap<ParserPath, ArrayList<RfNamedElement>>();
        NullProtectedList<RfNamedElement> allComponents = new NullProtectedList<RfNamedElement>();
        allComponents.addAll(this.fOVMProject.getAllNonXVMClasses());
        allComponents.addAll(this.fOVMProject.getAllModules());
        allComponents.addAll(this.fOVMProject.getAllInterfaces());
        allComponents.addAll(this.fOVMProject.getAllPackages());
        for (RfNamedElement rfNamedElement : allComponents) {
            ParserPath parserPath = rfNamedElement.getFile().getParserPath();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            ArrayList<RfNamedElement> entitiesPerFile = fileEntitiesMap.get(parserPath);
            if (entitiesPerFile == null) {
                entitiesPerFile = new ArrayList();
            }
            entitiesPerFile.add(rfNamedElement);
            fileEntitiesMap.put(parserPath, entitiesPerFile);
        }
        this.notifyCheckAlive();
        this.checkOnePerFile(fileEntitiesMap);
    }
}

