/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractPatternCheck;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.2.7")
@CheckName(value="SVTB.2.7")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Directory - File - Element Naming")
@CheckDescription(value="All <elementKind> elements in a path named <dirPattern> must be named <elementPattern> and defined in a file named <filePattern>.\nFor example all classes in .*/vips/(id1) must be named (id1)_(id2) and defined in a file named (id1)_(id2)\\.sv.\n\nImplementation Details:\nPatterns are matched in the dir, file, element order. As (id)s get matched, they are replaced in the following patterns.\nTake care when using patterns like (id1)_(id2), where any other id piece can stand for _.\nAs underscore is part of (id), unless the order above disambiguates, you may get unexpected results.\n\nCheck supports pre-waiving.")
public class Check_SVTB_2_7
extends AbstractPatternCheck {
    @CheckParameter(defaultValue="", description="A regexp with (id)s.", name="dirPattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pDirPatternValue;
    @CheckParameter(defaultValue="", description="A regexp with (id)s.", name="filePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pFilePatternValue;
    @CheckParameter(defaultValue="", description="A regexp with '(id)'s.", name="elementPattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pElementPatternValue;
    @CheckParameter(defaultValue="module, package, class, interface", description="Apply only for elements of type 'module, package, class, interface'.", name="elementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pElementKindValue;

    public Check_SVTB_2_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        AbstractPatternCheck.LocalMatcher dirMatcher = new AbstractPatternCheck.LocalMatcher(this.pDirPatternValue);
        AbstractPatternCheck.LocalMatcher fileMatcher = new AbstractPatternCheck.LocalMatcher(this.pFilePatternValue);
        AbstractPatternCheck.LocalMatcher elementMatcher = new AbstractPatternCheck.LocalMatcher(this.pElementPatternValue);
        NullProtectedList<RfNamedElement> elementsToCheck = new NullProtectedList<RfNamedElement>();
        if (this.pElementKindValue == null || this.pElementKindValue.isEmpty() || this.pElementKindValue.contains("module")) {
            elementsToCheck.addAll(this.fOVMProject.getAllModules());
        }
        if (this.pElementKindValue == null || this.pElementKindValue.isEmpty() || this.pElementKindValue.contains("package")) {
            elementsToCheck.addAll(this.fOVMProject.getAllPackages());
        }
        if (this.pElementKindValue == null || this.pElementKindValue.isEmpty() || this.pElementKindValue.contains("class")) {
            elementsToCheck.addAll(this.fOVMProject.getAllNonXVMClasses());
        }
        if (this.pElementKindValue == null || this.pElementKindValue.isEmpty() || this.pElementKindValue.contains("interface")) {
            elementsToCheck.addAll(this.fOVMProject.getAllInterfaces());
        }
        for (RfNamedElement element : elementsToCheck) {
            String mismatchMsg;
            this.notifyCheckAlive();
            ParserPath parserPath = element.getFile().getParserPath();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            File elementFile = new File(parserPath.path);
            String fileDir = elementFile.getParent();
            String fileName = elementFile.getName();
            String elementName = element.getName();
            HashMap<String, String> idNameValueMap = new HashMap<String, String>();
            HashMap<String, String> idNameLocationMap = new HashMap<String, String>();
            if (!dirMatcher.match(fileDir) || (mismatchMsg = dirMatcher.checkIdValues(idNameValueMap, idNameLocationMap, "Dir")) != null) continue;
            fileMatcher.recomputePattern(idNameValueMap);
            if (!fileMatcher.match(fileName)) {
                this.addHit(parserPath, 1, "File pattern '" + this.pFilePatternValue + "'" + this.getHitDetails(fileMatcher, idNameValueMap) + " mismatch!", null);
            } else {
                mismatchMsg = fileMatcher.checkIdValues(idNameValueMap, idNameLocationMap, "File");
                if (mismatchMsg != null) {
                    this.addHit(parserPath, 1, mismatchMsg, null);
                }
            }
            elementMatcher.recomputePattern(idNameValueMap);
            if (!elementMatcher.match(elementName)) {
                this.addHit(parserPath, element.getLine(), "Element pattern '" + this.pElementPatternValue + "'" + this.getHitDetails(elementMatcher, idNameValueMap) + " mismatch for '" + elementName + "'!", null);
                continue;
            }
            mismatchMsg = elementMatcher.checkIdValues(idNameValueMap, idNameLocationMap, "Element");
            if (mismatchMsg == null) continue;
            this.addHit(parserPath, element.getLine(), mismatchMsg, null);
        }
    }

    private String getHitDetails(AbstractPatternCheck.LocalMatcher matcher, HashMap<String, String> idNameValueMap) {
        if (idNameValueMap == null || idNameValueMap.isEmpty()) {
            return "";
        }
        if (matcher.getOriginalIdNames().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String idName : matcher.getOriginalIdNames()) {
            String idValue = idNameValueMap.get(idName);
            if (idValue == null) continue;
            sb.append(" ").append(idName).append(" = ").append(idValue).append(",");
        }
        if (sb.length() == 0) {
            return "";
        }
        return ", where" + sb.toString();
    }
}

