/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.File;
import java.io.FileFilter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractPatternCheck;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.2.8")
@CheckName(value="SVTB.2.8")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Directory Contains File")
@CheckDescription(value="In all paths named <dirPattern> there must be a file named <filePattern>. Only directories with compiled sources are checked.\nFor example in folders .*/vips/(id1) there must be a file named (id1)_README.txt\n\nImplementation Details:\nPatterns are matched in the dir, file order. As (id)s get matched, they are replaced in the following patterns.\nTake care when using patterns like (id1)_(id2), where any other id piece can stand for _.\nAs underscore is part of (id), unless the order above disambiguates, you may get unexpected results.\n\nCheck supports pre-waiving.")
public class Check_SVTB_2_8
extends AbstractPatternCheck {
    private Comparator<ParserPath> alphabeticalPathOrder = new Comparator<ParserPath>(){

        @Override
        public int compare(ParserPath o1, ParserPath o2) {
            return o1.path.compareTo(o2.path);
        }
    };
    @CheckParameter(defaultValue="", description="A regexp with (id)s.", name="dirPattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pDirPatternValue;
    @CheckParameter(defaultValue="", description="A regexp with (id)s.", name="filePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pFilePatternValue;
    @CheckParameter(defaultValue="", description="Check for dir if specified. When empty, check for files.", name="isDir", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pIsDirValue;

    public Check_SVTB_2_8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        AbstractPatternCheck.LocalMatcher dirMatcher = new AbstractPatternCheck.LocalMatcher(this.pDirPatternValue);
        final AbstractPatternCheck.LocalMatcher fileMatcher = new AbstractPatternCheck.LocalMatcher(this.pFilePatternValue);
        final boolean lookForDir = this.pIsDirValue != null && !this.pIsDirValue.isEmpty();
        TreeSet<ParserPath> sortedFilePaths = new TreeSet<ParserPath>(this.alphabeticalPathOrder);
        sortedFilePaths.addAll(this.fOVMProject.getAllImportedFiles());
        HashSet<String> checkedDirs = new HashSet<String>();
        for (ParserPath filePath : sortedFilePaths) {
            String mismatchMsg;
            File file;
            String checkDir;
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(filePath, this) || checkedDirs.contains(checkDir = (file = new File(filePath.path)).getParent())) continue;
            checkedDirs.add(checkDir);
            HashMap<String, String> idNameValueMap = new HashMap<String, String>();
            HashMap<String, String> idNameLocationMap = new HashMap<String, String>();
            if (!dirMatcher.match(checkDir) || (mismatchMsg = dirMatcher.checkIdValues(idNameValueMap, idNameLocationMap, "Dir")) != null) continue;
            fileMatcher.recomputePattern(idNameValueMap);
            String expectedFileName = fileMatcher.getUserPatternString();
            if (expectedFileName == null) continue;
            File[] matchedFiles = null;
            try {
                File dir = new File(checkDir);
                matchedFiles = dir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File aFile) {
                        if (lookForDir && !aFile.isDirectory()) {
                            return false;
                        }
                        if (!lookForDir && aFile.isDirectory()) {
                            return false;
                        }
                        return fileMatcher.match(aFile.getName());
                    }
                });
            }
            catch (Exception e) {
                this.fOVMProject.notifyCheckException(this, e);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            if (matchedFiles != null && matchedFiles.length != 0) continue;
            this.addHit(filePath, 1, String.valueOf(lookForDir ? "Dir" : "File") + " matching '" + expectedFileName + "' not found in '" + checkDir + "'!", null);
        }
    }
}

