/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractPatternCheck;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.2.9")
@CheckName(value="SVTB.2.9")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.NAME, RuleLabel.STYLING})
@CheckTitle(value="Directory - File - Element Existence")
@CheckDescription(value="In a path named <dirPattern> there must be an <elementKind> element named <elementPattern> and defined in a file named <filePattern>.\nOnly directories with compiled sources are checked.\nFor example in .*/vips/(id1) there must be a package named (id1)_pkg defined in a file named (id1)_pkg\\.sv.\nFor example in .*/tb there must be a module named tb_top(?:_(config))? defined in a file named tb_top(?:_(config))?.sv.\n\nImplementation Details:\nPatterns are matched in the dir, file, element order. As (id)s get matched, they are replaced in the following patterns.\nTake care when using patterns like (id1)_(id2), where any other id piece can stand for _.\nAs underscore is part of (id), unless the order above disambiguates, you may get unexpected results.\n\nCheck supports pre-waiving.")
public class Check_SVTB_2_9
extends AbstractPatternCheck {
    @CheckParameter(defaultValue="", description="A regexp with (id)s.", name="dirPattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pDirPatternValue;
    @CheckParameter(defaultValue="", description="A regexp with (id)s.", name="filePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pFilePatternValue;
    @CheckParameter(defaultValue="", description="A regexp with (id)s.", name="elementPattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pElementPatternValue;
    @CheckParameter(defaultValue="module", description="One of module, package, class, interface.", name="elementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pElementKindValue;

    public Check_SVTB_2_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        AbstractPatternCheck.LocalMatcher dirMatcher = new AbstractPatternCheck.LocalMatcher(this.pDirPatternValue);
        AbstractPatternCheck.LocalMatcher fileMatcher = null;
        if (this.pFilePatternValue != null) {
            fileMatcher = new AbstractPatternCheck.LocalMatcher(this.pFilePatternValue);
        }
        AbstractPatternCheck.LocalMatcher elementMatcher = null;
        if (this.pElementPatternValue != null) {
            elementMatcher = new AbstractPatternCheck.LocalMatcher(this.pElementPatternValue);
        }
        NullProtectedList<RfNamedElement> elementsToCheck = new NullProtectedList<RfNamedElement>();
        if (this.pElementKindValue == null || this.pElementKindValue.isEmpty()) {
            this.pElementKindValue = "module";
        }
        if ("module".equals(this.pElementKindValue)) {
            elementsToCheck.addAll(this.fOVMProject.getAllModules());
        }
        if ("package".equals(this.pElementKindValue)) {
            elementsToCheck.addAll(this.fOVMProject.getAllPackages());
        }
        if ("class".equals(this.pElementKindValue)) {
            elementsToCheck.addAll(this.fOVMProject.getAllNonXVMClasses());
        }
        if ("interface".equals(this.pElementKindValue)) {
            elementsToCheck.addAll(this.fOVMProject.getAllInterfaces());
        }
        HashSet<ParserPath> filePaths = this.fOVMProject.getAllImportedFiles();
        HashSet<String> checkedDirs = new HashSet<String>();
        for (ParserPath filePath : filePaths) {
            String mismatchMsg;
            File file;
            String checkDir;
            this.notifyCheckAlive();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(filePath, this) || checkedDirs.contains(checkDir = (file = new File(filePath.path)).getParent())) continue;
            checkedDirs.add(checkDir);
            HashMap<String, String> idNameValueMap = new HashMap<String, String>();
            HashMap<String, String> idNameLocationMap = new HashMap<String, String>();
            if (!dirMatcher.match(checkDir) || (mismatchMsg = dirMatcher.checkIdValues(idNameValueMap, idNameLocationMap, "Dir")) != null) continue;
            boolean elementFound = false;
            if (fileMatcher == null || elementMatcher == null) continue;
            fileMatcher.recomputePattern(idNameValueMap);
            ParserPath parserPath = null;
            for (RfNamedElement element : elementsToCheck) {
                this.notifyCheckAlive();
                HashMap<String, String> localIdNameValueMap = new HashMap<String, String>(idNameValueMap);
                HashMap<String, String> localIdNameLocationMap = new HashMap<String, String>(idNameLocationMap);
                parserPath = element.getFile().getParserPath();
                File elementFile = new File(parserPath.path);
                String fileDir = elementFile.getParent();
                if (!checkDir.equals(fileDir)) continue;
                String fileName = elementFile.getName();
                String elementName = element.getName();
                if (!fileMatcher.match(fileName) || (mismatchMsg = fileMatcher.checkIdValues(localIdNameValueMap, localIdNameLocationMap, "File")) != null) continue;
                elementMatcher.recomputePattern(localIdNameValueMap);
                if (!elementMatcher.match(elementName) || (mismatchMsg = elementMatcher.checkIdValues(localIdNameValueMap, localIdNameLocationMap, "Element")) != null) continue;
                elementFound = true;
                break;
            }
            if (elementFound) continue;
            this.addHit(new ParserPath(checkDir), 0, String.valueOf(this.pElementKindValue) + " '" + this.pElementPatternValue + "'" + " not found in '" + checkDir + "/" + this.pFilePatternValue + "'!", null);
        }
    }
}

