/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="18.1.9")
@CheckID(value="SVTB.30.10")
@CheckName(value="SVTB.30.10")
@CheckLabel(labels={RuleLabel.DEPRECATED_API, RuleLabel.PREDEFINED_METHOD, RuleLabel.ARGUMENT, RuleLabel.EVENT_CONTROL})
@CheckTitle(value="Do not use deprecated clocking event argument of $sampled")
@CheckDescription(value="The IEEE 1800-2005 version of the standard required that an explicit or inferred clocking event argument be provided for the $sampled assertion system function.\nIn IEEE 1800-2012 the semantics of $sampled have been changed to a form that does not depend on a clocking event. Therefore the clocking event argument of $sampled is deprecated.\n\nCheck supports pre-waiving.")
public class Check_SVTB_30_10
extends OVMComplianceCheck {
    public Check_SVTB_30_10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        FunctionCallVisitor functionVisitor = new FunctionCallVisitor();
        rfProject.visitHidObject(rfProject, functionVisitor);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class FunctionCallVisitor
    extends RfHidVisitor {
        private FunctionCallVisitor() {
        }

        public boolean visit(RfHid hid) {
            if (hid == null) {
                return true;
            }
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            if (!hidNamedElement.isPredefined()) {
                return true;
            }
            Check_SVTB_30_10.this.notifyCheckAlive();
            if (Check_SVTB_30_10.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (!(this.holder instanceof HidHolder)) {
                return true;
            }
            IRfNamedElement holderScope = ((HidHolder)this.holder).getScope();
            if (holderScope == null) {
                return true;
            }
            if (!(holderScope instanceof RfNamedElement)) {
                return true;
            }
            RfPackage enclosingPackage = (RfPackage)holderScope.getEnclosingScope(RfPackage.class);
            if (enclosingPackage != null && Check_SVTB_30_10.this.fOVMProject.isOVMElement(enclosingPackage)) {
                return true;
            }
            String predefinedFunctionName = ((RfPredefinedFunction)hidNamedElement).getFullName();
            if (!"$sampled".equals(predefinedFunctionName)) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            StringBuilder sb = new StringBuilder();
            for (MethodCall methodCall : methodCalls) {
                if (methodCall == null || methodCall.argumentValuesMap == null) continue;
                sb.setLength(0);
                if (methodCall.argumentValuesMap.size() <= 1) continue;
                sb.append('(');
                for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                    sb.append(HidUtils.toNiceString((IHidObject)((IHidObject)entry.getValue()))).append(',');
                }
                sb.setCharAt(sb.length() - 1, ')');
                Check_SVTB_30_10.this.addHit(this.parserPath, methodCall.occurrence, "Deprecated clocking event argument is used for '" + predefinedFunctionName + sb.toString() + "'!");
            }
            return true;
        }
    }
}

