/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractMethodCallCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.2")
@CheckID(value="SVTB.30.1.0")
@CheckName(value="SVTB.30.1.0")
@CheckLabel(labels={RuleLabel.DEPRECATED_API, RuleLabel.METHOD})
@CheckTitle(value="Do not use deprecated methods")
@CheckDescription(value="Do not use 'deprecatedMethods' or methods that contain ''deprecatedComments''.\n\n deprecatedMethods parameter examples: $stop, $display, std::randomize,\n pkg_1::task_2, pkg_1::class_2.class_3.function_4, interface_1.function_2, module_1.task_2, program_1.function_2,\n [fixed_size_array].min, [dynamic_array].min, [associative_array].min, [queue].min,\n [enum].num, [scalar].string.len.\n\n\n deprecatedComments parameter examples: @deprecated, DEPRECATED\n\nImplementation Notes:\n Do not use typedef names in method full names, as typedefs are solved before checking.\n\nCheck supports pre-waiving.")
public class Check_SVTB_30_1_0
extends AbstractMethodCallCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of deprecated method full names.", name="deprecatedMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pDeprecatedMethodsValue;
    @CheckParameter(defaultValue="deprecated, DEPRECATED", description="Comma separated list of comments that indicate deprecation.", name="deprecatedComments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pDeprecatedCommentsValue;
    @CheckParameter(defaultValue="false", description="When true the check will flag all other methods except for deprecatedMethods or methods that contain \"deprecatedComments\".", name="invertedFilter", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pInvertedFilterValue;
    @CheckParameter(defaultValue="", description="Regular expression of paths that contain deprecatedMethods or methods that contain \"deprecatedComments\".", name="allowedPaths", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    protected Pattern pAllowedPathsValue;
    boolean fCheckComments;
    HashSet<RfFunction> fDeprecatedFunctionsCache;

    public Check_SVTB_30_1_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fCheckComments = !this.pDeprecatedCommentsValue.isEmpty();
        this.fDeprecatedFunctionsCache = new HashSet();
        this.performCheckBase();
        this.fDeprecatedFunctionsCache = null;
    }

    @Override
    public void checkMethodCall(ParserPath aParserPath, RfHid aHid, RfFunction aCalledFunction, RfNamedElement scope) {
        if (aCalledFunction == null) {
            return;
        }
        String calledFunctionFullName = aCalledFunction.getFullName();
        if (this.fDeprecatedFunctionsCache.contains(aCalledFunction)) {
            this.addHit(aParserPath, aHid, this.makeMessage(calledFunctionFullName));
            return;
        }
        if (this.pInvertedFilterValue && aCalledFunction.isConstructor()) {
            return;
        }
        RfDefElement aCalledFunctionDeclaration = aCalledFunction.getDeclaration();
        if (!this.pAllowedPathsValue.pattern().isEmpty() && aCalledFunctionDeclaration != null && !this.pAllowedPathsValue.matcher(aCalledFunctionDeclaration.getParserPath().path).matches()) {
            return;
        }
        this.checkParents(aParserPath, aHid, aCalledFunction);
    }

    /*
     * Unable to fully structure code
     */
    private void checkParents(ParserPath aParserPath, RfHid aHid, RfFunction function) {
        functionName = function.getName();
        scope = function.getEnclosingScope();
        parentClass = null;
        if (scope instanceof RfClass) {
            parentClass = (RfClass)scope;
        }
        lastVirtualFunction = null;
        hitFunction = null;
        parentFunctions = new ArrayList<RfFunction>();
        candidate = function;
        if (candidate.isPredefined()) {
            if (this.isDeprecatedFunction(candidate) && !this.pInvertedFilterValue) {
                this.fDeprecatedFunctionsCache.add(candidate);
                this.addHit(aParserPath, aHid, this.makeMessage(function.getFullName()));
            }
            return;
        }
        if (parentClass != null) ** GOTO lbl39
        if (this.isDeprecatedFunction(candidate) != this.pInvertedFilterValue) {
            this.fDeprecatedFunctionsCache.add(candidate);
            this.addHit(aParserPath, aHid, this.makeMessage(function.getFullName()));
        }
        return;
        while (candidate != null) {
            parentFunctions.add(candidate);
            if (hitFunction == null && this.isDeprecatedFunction(candidate)) {
                hitFunction = candidate;
            }
            if (hitFunction != null && (candidate.hasVirtualQualifier() || candidate == function)) {
                lastVirtualFunction = candidate;
                break;
            }
            if (this.fDeprecatedFunctionsCache.contains(candidate) && candidate.hasVirtualQualifier()) {
                if (this.pInvertedFilterValue) break;
                lastVirtualFunction = candidate;
                hitFunction = candidate;
                break;
            }
            if ((parentClass = parentClass.getParent()) != null) {
                candidate = parentClass.getLocalMember(RfFunction.class, functionName, true);
            }
lbl39:
            // 4 sources

            if (parentClass != null) continue;
        }
        if (lastVirtualFunction != null && hitFunction != null && !this.pInvertedFilterValue) {
            for (RfFunction parentFunction : parentFunctions) {
                this.fDeprecatedFunctionsCache.add(parentFunction);
                if (hitFunction != parentFunction) continue;
                this.addHit(aParserPath, aHid, this.makeMessage(hitFunction.getFullName()));
                break;
            }
        }
        if (lastVirtualFunction == null && this.pInvertedFilterValue) {
            this.fDeprecatedFunctionsCache.add(function);
            this.addHit(aParserPath, aHid, this.makeMessage(function.getFullName()));
        }
    }

    private boolean isDeprecatedFunction(RfFunction candidate) {
        if (this.fCheckComments && !candidate.isPredefined()) {
            String calledFunctionComment = candidate.getComment();
            boolean foundDeprecatedComment = false;
            for (String deprecatedComment : this.pDeprecatedCommentsValue) {
                if (!calledFunctionComment.contains(deprecatedComment)) continue;
                foundDeprecatedComment = true;
                break;
            }
            if (foundDeprecatedComment) {
                return true;
            }
        }
        return this.pDeprecatedMethodsValue.contains(LintUtils.getNamedElementFullName(candidate));
    }

    @Override
    public void checkSystemCall(SVTBIssues issue, ParserPath filename, String systemId, IRfScopeElement scope) {
        if (issue == null) {
            return;
        }
        if (this.pDeprecatedMethodsValue.contains(systemId)) {
            this.addHit(filename, issue.getLine(), this.makeMessage(systemId), issue.getReparseInfo());
        }
    }

    protected String makeMessage(String calledFunctionFullName) {
        String result = "Deprecated method call '" + calledFunctionFullName + "()'!";
        if (!this.pInvertedFilterValue) {
            return result;
        }
        if (this.pDeprecatedCommentsValue == null || this.pDeprecatedCommentsValue.isEmpty()) {
            return result;
        }
        return "Non " + this.pDeprecatedCommentsValue.iterator().next() + " method call '" + calledFunctionFullName + "()'!";
    }
}

