/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractFieldAccessCheck;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="3.2")
@CheckID(value="SVTB.30.2.0")
@CheckName(value="SVTB.30.2.0")
@CheckLabel(labels={RuleLabel.DEPRECATED_API, RuleLabel.FIELD})
@CheckTitle(value="Do not use deprecated fields")
@CheckDescription(value="Do not use 'deprecatedFields' or fields that contain 'deprecatedComments'.\n\n deprecatedFields parameter examples: uvm_pkg::stop_timeout, uvm_pkg::uvm_component.enable_stop_interrupt,\n\n\n deprecatedComments parameter examples: @deprecated, DEPRECATED\n\nImplementation Notes:\n Do not use typedef names in field full names, as typedefs are solved before checking.\n\nCheck supports pre-waiving.")
public class Check_SVTB_30_2_0
extends AbstractFieldAccessCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of deprecated fields full names.", name="deprecatedFields", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pDeprecatedFieldsValue;
    @CheckParameter(defaultValue="deprecated,DEPRECATED.", description="Comma separated list of comments that indicate deprecation.", name="deprecatedComments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pDeprecatedCommentsValue;
    @CheckParameter(defaultValue="false", description="When true the check will flag all other fields except for deprecatedFields or fields that contain \"deprecatedComments\".", name="invertedFilter", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pInvertedFilterValue;
    @CheckParameter(defaultValue="", description="Regular expression of paths that contain deprecatedFields or fields that contain \"deprecatedComments\".", name="allowedPaths", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    protected Pattern pAllowedPathsValue;
    boolean fCheckComments;
    HashSet<RfField> fDeprecatedFieldsCache;

    public Check_SVTB_30_2_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fCheckComments = !this.pDeprecatedCommentsValue.isEmpty();
        this.fDeprecatedFieldsCache = new HashSet();
        this.performCheckBase();
        this.fDeprecatedFieldsCache = null;
    }

    @Override
    public void checkFieldAccess(ParserPath aParserPath, RfHid aHid, RfField aField) {
        Matcher m;
        if (aField == null) {
            return;
        }
        if (aField.isPredefined()) {
            return;
        }
        if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(aParserPath, this)) {
            return;
        }
        RfDefElement aFieldDeclaration = aField.getDeclaration();
        if (!this.pAllowedPathsValue.pattern().isEmpty() && aFieldDeclaration != null && !(m = this.pAllowedPathsValue.matcher(aFieldDeclaration.getParserPath().path)).matches()) {
            return;
        }
        String fieldFullName = aField.getFullName();
        if (this.fCheckComments) {
            if (this.fDeprecatedFieldsCache.contains(aField)) {
                this.addHit(aParserPath, aHid, this.makeMessage(fieldFullName));
            } else {
                String accessedFieldComment = aField.getComment();
                for (String deprecatedComment : this.pDeprecatedCommentsValue) {
                    if (this.pInvertedFilterValue == accessedFieldComment.contains(deprecatedComment)) continue;
                    this.fDeprecatedFieldsCache.add(aField);
                    this.addHit(aParserPath, aHid, this.makeMessage(fieldFullName));
                }
            }
        }
        if (!this.pInvertedFilterValue && this.pDeprecatedFieldsValue.contains(fieldFullName)) {
            this.addHit(aParserPath, aHid, this.makeMessage(fieldFullName));
        } else if (this.pInvertedFilterValue && !this.pDeprecatedFieldsValue.isEmpty() && !this.pDeprecatedFieldsValue.contains(fieldFullName)) {
            this.addHit(aParserPath, aHid, this.makeMessage(fieldFullName));
        }
    }

    private String makeMessage(String fieldFullName) {
        String result = "Deprecated field access '" + fieldFullName + "'!";
        if (!this.pInvertedFilterValue) {
            return result;
        }
        if (this.pDeprecatedCommentsValue == null || this.pDeprecatedCommentsValue.isEmpty()) {
            return result;
        }
        return "Non " + this.pDeprecatedCommentsValue.iterator().next() + " field access '" + fieldFullName + "'!";
    }
}

