/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractClassUseCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;

@CheckVersion(value="3.2")
@CheckID(value="SVTB.30.3.0")
@CheckName(value="SVTB.30.3.0")
@CheckLabel(labels={RuleLabel.DEPRECATED_API, RuleLabel.CLASS})
@CheckTitle(value="Do not use deprecated classes")
@CheckDescription(value="Do not use 'deprecatedClasses' or classes that contain 'deprecatedComments'.\n\nImplementation Notes:\nFor each class not in skipClassesWithPrefixes check that:\n - It does not extend from a deprecated class.\n - It does not have a type parameter of a deprecated class.\n - It does not contain fields of a deprecated class.\n - It does not contain methods with result or arguments of a deprecated class.\n The key type of associative arrays is also checked.\n\nCheck supports pre-waiving.")
public class Check_SVTB_30_3_0
extends AbstractClassUseCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of deprecated class full names.", name="deprecatedClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pDeprecatedClassesValue;
    @CheckParameter(defaultValue="deprecated,DEPRECATED.", description="Comma separated list of comments that indicate deprecation.", name="deprecatedComments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pDeprecatedCommentsValue;
    @CheckParameter(defaultValue="false", description="When true the check will flag all other classes except for deprecatedClasses or classes that contain \"deprecatedComments\".", name="invertedFilter", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pInvertedFilterValue;
    @CheckParameter(defaultValue="", description="Regular expression of paths that contain deprecatedClasses or classes that contain \"deprecatedComments\".", name="allowedPaths", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    protected Pattern pAllowedPathsValue;
    @CheckParameter(defaultValue="", description="Comma separated list of class prefixes to skip checking, for example uvm_pkg::uvm_.", name="skipClassesWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pSkipClassesWithPrefixesValue;
    boolean fCheckComments;
    HashSet<RfClass> fDeprecatedClassesCache;

    public Check_SVTB_30_3_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fCheckComments = !this.pDeprecatedCommentsValue.isEmpty();
        this.fDeprecatedClassesCache = new HashSet();
        this.performCheckBase();
        this.fDeprecatedClassesCache = null;
    }

    @Override
    protected boolean skipClass(RfClass aClass) {
        return LintUtils.startsWithPrefixes(aClass.getFullName(), this.pSkipClassesWithPrefixesValue);
    }

    @Override
    protected boolean isClassOKToUse(RfClass aEnclosingClass, RfClass aClass) {
        if (aEnclosingClass != null && aEnclosingClass == aClass) {
            return true;
        }
        RfDefElement aClassDeclaration = aClass.getDeclaration();
        if (!this.pAllowedPathsValue.pattern().isEmpty() && aClassDeclaration != null && !this.pAllowedPathsValue.matcher(aClassDeclaration.getParserPath().path).matches()) {
            return true;
        }
        RfClass checkedClass = aClass;
        if (aClass instanceof RfSpecializedClass) {
            checkedClass = aClass.getGenericClass();
        }
        if (this.fCheckComments && !checkedClass.isPredefined()) {
            if (this.fDeprecatedClassesCache.contains(checkedClass)) {
                return false;
            }
            String classComment = checkedClass.getComment();
            for (String deprecatedComment : this.pDeprecatedCommentsValue) {
                if (this.pInvertedFilterValue == classComment.contains(deprecatedComment)) continue;
                this.fDeprecatedClassesCache.add(checkedClass);
                return false;
            }
        }
        String classFullName = aClass.getFullName();
        if (!this.pInvertedFilterValue && this.pDeprecatedClassesValue.contains(classFullName)) {
            return false;
        }
        return !this.pInvertedFilterValue || this.pDeprecatedClassesValue.isEmpty() || this.pDeprecatedClassesValue.contains(classFullName);
    }

    @Override
    protected String getSpecificMessage() {
        if (!this.pInvertedFilterValue) {
            return "deprecated class type";
        }
        return "non " + this.pDeprecatedCommentsValue.iterator().next() + " class type";
    }

    @Override
    protected boolean isOnlyInheritance() {
        return false;
    }
}

