/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

@CheckVersion(value="3.2")
@CheckID(value="SVTB.30.4.0")
@CheckName(value="SVTB.30.4.0")
@CheckLabel(labels={RuleLabel.DEPRECATED_API, RuleLabel.MACRO})
@CheckTitle(value="Do not use deprecated macros")
@CheckDescription(value="Do not use 'deprecatedMacros' or macros that contain 'deprecatedComments'.\n\nImplementation Notes:\n Iterate over all classes and check that 'deprecatedMacros' or macros marked with 'deprecatedComments' are not used for class items, nor in any of its functions or tasks.\n\nCheck supports pre-waiving.")
public class Check_SVTB_30_4_0
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of deprecated macros, for example `deprecatedMacro1, `deprecatedMacro2.", name="deprecatedMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pDeprecatedMacrosValue;
    @CheckParameter(defaultValue="deprecated,DEPRECATED.", description="Comma separated list of comments that indicate deprecation.", name="deprecatedComments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pDeprecatedCommentsValue;
    @CheckParameter(defaultValue="", description="Comma separated list of class prefixes to skip checking, for example uvm_pkg::uvm_.", name="skipClassesWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pSkipClassesWithPrefixesValue;

    public Check_SVTB_30_4_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        if (this.pDeprecatedMacrosValue != null) {
            aRfProject.lintTrackMacrosByNames("all", this.pDeprecatedMacrosValue);
        }
        if (this.pDeprecatedCommentsValue != null) {
            aRfProject.lintTrackMacrosByDeprecatedComments(this.pDeprecatedCommentsValue);
        }
    }

    @Override
    public void performCheckImpl() {
        for (RfClass eachRfClass : this.fOVMProject.getAllClasses()) {
            this.notifyCheckAlive();
            RfFileDef fileDef = eachRfClass.getFile();
            if (fileDef == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this) || this.skipClass(eachRfClass)) continue;
            this.checkMacroCalls(eachRfClass.getMacroCallInfo());
            List<RfFunction> functions = eachRfClass.getLocalMembers(RfFunction.class);
            if (functions == null || !functions.isEmpty()) continue;
            for (RfFunction function : functions) {
                if (function == null || function.isPredefined()) continue;
                this.checkMacroCalls(function.getMacroCallInfo());
            }
        }
    }

    private boolean skipClass(RfClass aClass) {
        return LintUtils.startsWithPrefixes(aClass.getFullName(), this.pSkipClassesWithPrefixesValue);
    }

    private void checkMacroCalls(MacroCallInfo macroCallInfo) {
        List<MacroCallItem> bannedMacroCalls = LintUtils.getMacroCallsInSet(macroCallInfo, this.pDeprecatedMacrosValue, true, true);
        if (bannedMacroCalls == null || bannedMacroCalls.isEmpty()) {
            return;
        }
        for (MacroCallItem bannedMacroCall : bannedMacroCalls) {
            this.addHit(bannedMacroCall.getParserPath(), bannedMacroCall.getLineNumber(), "Deprecated macro " + bannedMacroCall.getName() + "!", bannedMacroCall.getReparseInfo());
        }
    }
}

