/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSpecializedTypeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;
import ro.amiq.dvt.ui.trace.connections.model.TCLogic;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.ReferencedInfo;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCoverbin;
import ro.amiq.vlogdt.model.reflection.RfCovercross;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfEventTrigger;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.RfWait;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="3.5.24")
@CheckID(value="SVTB.31.1.0")
@CheckName(value="SVTB.31.1.0")
@CheckLabel(labels={RuleLabel.DEAD_CODE})
@CheckTitle(value="Unused element")
@CheckDescription(value="Flags unused types (classes, modules...), functions, tasks, variables...\n\nImplementation Notes:\n This rule does not check macros.\n This rule does not check an unused function result implicit variable.\n The type parameter access analysis does not perform an elaborate semantic analysis. Any access to class.foo() via a type parameter is a valid access for any class that defines foo(). In the above context\n class c3;\n   task foo(); // is also used, although c1 is not 'used' with c3 as a parameter \n   endtask\n endclass\n\nThe type parameter access analysis does not analyze chained type parameter accesses like fT1.fT2.foo().\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_SVTB_31_1_0
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="uvm", description="Comma separated list of macro prefixes.", name="skipEntitiesDeclaredInsideMacrosWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipEntitiesDeclaredInsideMacrosWithPrefixesValue;
    @CheckParameter(defaultValue="uvm", description="Comma separated list of package prefixes.", name="skipEntitiesDeclaredInsidePackagesWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipEntitiesDeclaredInsidePackagesWithPrefixesValue;
    @CheckParameter(defaultValue="uvm", description="Comma separated list of package prefixes. Unused arguments defined in prefix_pkg::class.functions will not be flagged.", name="skipFunctionArgumentsDefinedInPackagesWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipFunctionArgumentsDefinedInPackagesWithPrefixesValue;
    @CheckParameter(defaultValue="false", description="When true, the public API is not checked.", name="skipPublicAPI", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipPublicAPIValue;
    @CheckParameter(defaultValue="false", description="When true, the arguments of public functions are not checked.", name="skipPublicFunctionArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipPublicFunctionArgumentsValue;
    @CheckParameter(defaultValue="false", description="When true, the protected API is not checked.", name="skipProtectedAPI", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipProtectedAPIValue;
    @CheckParameter(defaultValue="false", description="When true, the argument of protected functions is not checked.", name="skipProtectedFunctionArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipProtectedFunctionArgumentsValue;
    @CheckParameter(defaultValue="false", description="When true, the package API is not checked. INCLUDING API content, for example unused variables inside a package function. EXCEPTION: classes and their content is always checked.", name="skipPackageAPI", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipPackageAPIValue;
    @CheckParameter(defaultValue="false", description="When true, the global API is not checked. INCLUDING API content, for example unused variables inside a global function.", name="skipGlobalAPI", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipGlobalAPIValue;
    @CheckParameter(defaultValue="false", description="When true, all unused class variables or functions are also analyzed in the context of type param accesses. Useful for callback API. For example:\n    class c1 #(type T=int);\n      local T f1;\n      task test(); \n        f1.foo(); // in the context of this access \n      endtask\n    endclass\n    \n    class c2;\n      c1#(c2) f2;\n      task foo(); // re-analyze this function \n      endtask\n    endclass", name="analyzeTypeParameterAccess", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAnalyzeTypeParameterAccessValue;
    @CheckParameter(defaultValue="true", description="When true, unused export DPI functions are not reported.", name="skipExportDPIFunctions", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipExportDPIFunctionsValue;
    @CheckParameter(defaultValue="false", description="When true, unused modules are not reported.", name="skipModules", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipModulesValue;
    @CheckParameter(defaultValue="false", description="When true, classes used only in factory registration will be considered unused.", name="reportClassesUsedOnlyInFactoryRegistration", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pReportClassesUsedOnlyInFactoryRegistration;
    @CheckParameter(defaultValue="false", description="When true, unused virtual methods that classes must implement are not reported.", name="skipImplementedMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipImplementedMethods;
    @CheckParameter(defaultValue="false", description="When true, unused enum items and struct members are not reported.", name="skipEnumItemsAndStructMembers", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipEnumItemsAndStructMembers;
    private Map<IRfNamedElement, ReferencedInfo> referencedInfo = new IdentityHashMap<IRfNamedElement, ReferencedInfo>();
    private Map<ParserPath, Set<HidOccurrence>> fConstructorAssignments = new HashMap<ParserPath, Set<HidOccurrence>>();
    private Set<Class<?>> instanceHolderClasses = new HashSet();
    private Set<RfNamedElement> topModules;
    private Map<RfPort, Set<RfNamedElement>> implicitPortsWithScopesOfInstance = new HashMap<RfPort, Set<RfNamedElement>>();
    private Set<String> skipTypes = new HashSet<String>();
    private final HashSet<String> UVM_REGISTRATION_MACROS = new HashSet<String>(Arrays.asList("m_uvm_component_registry_internal", "m_uvm_object_registry_internal", "m_uvm_component_registry_param", "m_uvm_object_registry_param", "uvm_object_utils", "uvm_object_param_utils", "uvm_object_utils_begin", "uvm_object_param_utils_begin", "uvm_component_utils", "uvm_component_param_utils", "uvm_component_utils_begin", "uvm_component_param_utils_begin", "uvm_sequencer_utils", "uvm_sequencer_utils_begin", "uvm_sequencer_param_utils", "uvm_sequencer_param_utils_begin", "uvm_sequence_utils", "uvm_sequence_utils_begin", "uvm_object_registry", "uvm_component_registry"));
    private int ncalgCounter;
    private List<RfHid> fTypeAccessHids;
    private Map<String, List<RfHid>> fNameTAHidMap;
    private static final EnumSet<HidFlatteningOption> HID_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALLS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS);

    public Check_SVTB_31_1_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject;
        this.implicitPortsWithScopesOfInstance.clear();
        this.instanceHolderClasses.add(RfModule.class);
        this.instanceHolderClasses.add(RfInterface.class);
        this.instanceHolderClasses.add(RfProgram.class);
        this.topModules = LintUtils.getTopModules(this.fOVMProject);
        if (this.pAnalyzeTypeParameterAccessValue) {
            this.fTypeAccessHids = new ArrayList<RfHid>();
        }
        this.skipTypes.clear();
        if (this.pSkipEnumItemsAndStructMembers) {
            this.skipTypes.add("enum item");
            this.skipTypes.add("union member");
            this.skipTypes.add("struct member");
        }
        if ((rfProject = this.fOVMProject.getRfProject()) == null) {
            return;
        }
        IRfNamedElementVisitor neVisitor = namedElement -> {
            this.notifyCheckAliveLowGranularity();
            if (namedElement != null && !namedElement.isPredefined()) {
                RfInstanceHolder enclosingInstanceHolder = (RfInstanceHolder)namedElement.getEnclosingScope(this.instanceHolderClasses);
                if (enclosingInstanceHolder != null && !enclosingInstanceHolder.getSemanticEnable() && !namedElement.equals(enclosingInstanceHolder)) {
                    return true;
                }
                this.setReference(namedElement, ReferencedInfo.ReferenceEnum.NO_REFERENCE);
                this.resetLinterFlags(namedElement);
            }
            return true;
        };
        rfProject.accept(neVisitor);
        HidOperatorVisitor operatorVisitor = new HidOperatorVisitor(null){

            public boolean visit(HidOperator hidObject) {
                RfNamedElement elementInGenericScope;
                if (hidObject.hasOccurrence(HidOperatorQualifier.IS_PORT_CONNECTION) && this.scope instanceof RfInstance) {
                    Check_SVTB_31_1_0.this.checkIfIsNamedImplicitPortConnection(hidObject, (RfInstance)this.scope);
                }
                if (hidObject.hasQualifier(HidQualifierCache.IS_PATTERN_VALUE_QUALIFIER)) {
                    Check_SVTB_31_1_0.this.checkIfUsedInPatternAssignment(hidObject);
                }
                if (!hidObject.hasOccurrence(HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS) && !hidObject.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                    return true;
                }
                if (this.scope == null || !(this.scope instanceof RfNamedElement)) {
                    return true;
                }
                if (Check_SVTB_31_1_0.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                HidOperator hidOperator = hidObject;
                ListContainer rhValues = hidOperator.getRHValues();
                if (rhValues == null || rhValues.size() != 1) {
                    return true;
                }
                IHidObject rhValue = (IHidObject)rhValues.get(0);
                Hid parentHid = null;
                if (rhValue instanceof RfHidAccess) {
                    parentHid = ((RfHidAccess)rhValue).getParentHid();
                } else if (rhValue instanceof RfHid) {
                    parentHid = (RfHid)rhValue;
                }
                if (parentHid == null) {
                    return true;
                }
                IRfNamedElement hidNamedElement = parentHid.getElement();
                if (hidNamedElement == null) {
                    return true;
                }
                if (hidNamedElement instanceof RfNamedElement && (elementInGenericScope = ((RfNamedElement)hidNamedElement).getElementInGenericScope()) != null) {
                    hidNamedElement = elementInGenericScope;
                }
                if (!(hidNamedElement instanceof RfFunction)) {
                    return true;
                }
                RfFunction asignFunction = (RfFunction)hidNamedElement;
                if (!asignFunction.isConstructor()) {
                    return true;
                }
                Hid hid = parentHid.getParentHid();
                if (hid == null) {
                    return true;
                }
                IHidObject lhHidObject = hidOperator.getLHValue();
                RfNamedElement lhType = null;
                Check_SVTB_31_1_0.this.notifyCheckAlive();
                if (lhHidObject instanceof RfHid) {
                    IRfNamedElement lhElement = ((IHid)lhHidObject).getElement();
                    if (!(lhElement instanceof RfAssociatedType)) {
                        return true;
                    }
                    lhType = Check_SVTB_31_1_0.getAssociatedType((RfAssociatedType)lhElement, this.scope);
                } else if (lhHidObject instanceof RfHidImplicit) {
                    RfNamedElement element = (RfNamedElement)this.scope;
                    IRfNamedElement field = element.getMember(((RfHidImplicit)lhHidObject).getName(), null, null, true, false, false, false, false);
                    if (field == null) {
                        return true;
                    }
                    if (!(field instanceof RfField)) {
                        return true;
                    }
                    lhType = Check_SVTB_31_1_0.getAssociatedType((RfField)field, this.scope);
                }
                if (lhType == null) {
                    return true;
                }
                HidOccurrence ocurrence = ((RfHid)hid).getOccurrence();
                Set<HidOccurrence> constructorList = Check_SVTB_31_1_0.this.fConstructorAssignments.get(this.parserPath);
                if (constructorList == null) {
                    constructorList = new HashSet<HidOccurrence>();
                }
                constructorList.add(ocurrence);
                Check_SVTB_31_1_0.this.fConstructorAssignments.put(this.parserPath, constructorList);
                return true;
            }
        };
        rfProject.visitHidObject(rfProject, (IHidVisitor<?>)operatorVisitor);
        neVisitor = namedElement -> {
            this.notifyCheckAliveLowGranularity();
            if (this.checkPreWaivers(namedElement.getFile())) {
                return true;
            }
            if (namedElement != null && !namedElement.isPredefined()) {
                RfInstanceHolder enclosingInstanceHolder = (RfInstanceHolder)namedElement.getEnclosingScope(this.instanceHolderClasses);
                if (enclosingInstanceHolder != null && !enclosingInstanceHolder.getSemanticEnable() && !namedElement.equals(enclosingInstanceHolder)) {
                    return true;
                }
                if (namedElement instanceof RfClass) {
                    RfClass extendedClass;
                    RfField extendedParameter = ((RfClass)namedElement).getExtendedParameter();
                    if (extendedParameter != null) {
                        this.setReference(extendedParameter, ReferencedInfo.ReferenceEnum.REFERENCED);
                    }
                    if ((extendedClass = ((RfClass)namedElement).getParent()) != null) {
                        this.setReference(extendedClass, ReferencedInfo.ReferenceEnum.REFERENCED);
                    }
                }
                if (namedElement instanceof RfAssociatedType) {
                    RfField field;
                    RfNamedElement enclosingType;
                    DataType dataType;
                    if (namedElement instanceof RfFunction && ((RfFunction)namedElement).isConstructor()) {
                        return true;
                    }
                    RfAssociatedType associatedElement = (RfAssociatedType)namedElement;
                    IRfNamedElement associatedType = associatedElement.getAssociatedTypeNoLastLevelParams(RfTypesResolver.create((IRfScopeElement)namedElement.getEnclosingScope(), this.fOVMProject.getRfProject(), 10));
                    if (associatedType instanceof RfNamedElement && !(associatedType instanceof RfStruct)) {
                        if (associatedType instanceof IRfSpecializedTypeElement) {
                            IRfNamedElement genericElement = ((IRfSpecializedTypeElement)associatedType).getGenericElement();
                            if (genericElement != null) {
                                this.setReference(genericElement, ReferencedInfo.ReferenceEnum.REFERENCED);
                            }
                        } else if (associatedType instanceof RfClass) {
                            boolean selfReference = false;
                            RfNamedElement enclosingScope = namedElement.getEnclosingScope();
                            while (enclosingScope != null) {
                                if (enclosingScope.equals(associatedType)) {
                                    selfReference = true;
                                    break;
                                }
                                enclosingScope = enclosingScope.getEnclosingScope();
                            }
                            if (!selfReference) {
                                this.setReference(associatedType, ReferencedInfo.ReferenceEnum.REFERENCED);
                            }
                        } else {
                            this.setReference(associatedType, ReferencedInfo.ReferenceEnum.REFERENCED);
                        }
                    }
                    if (associatedType instanceof RfListType) {
                        while (associatedType instanceof RfListType) {
                            associatedType = ((RfListType)associatedType).getAssociatedTypeNoLastLevelParams(RfTypesResolver.create((IRfScopeElement)namedElement.getEnclosingScope(), this.fOVMProject.getRfProject(), 6));
                        }
                        if (associatedType instanceof RfNamedElement) {
                            this.setReference(associatedType, ReferencedInfo.ReferenceEnum.REFERENCED);
                        }
                    }
                    if ((dataType = associatedElement.getDataType()) != null && dataType.getType() != null && (enclosingType = namedElement.getClosestTypeContainer()) != null && (field = enclosingType.getLocalMember(RfField.class, dataType.getType(), false)) != null && field.isTypeParameter()) {
                        this.setReference(field, ReferencedInfo.ReferenceEnum.REFERENCED);
                    }
                }
            }
            return true;
        };
        rfProject.accept(neVisitor);
        RfHidVisitor hidVisitor = new RfHidVisitor(){
            private RfHid fPrevParentHid;

            public boolean visit(RfHid hid) {
                Check_SVTB_31_1_0.this.notifyCheckAliveLowGranularity();
                if (hid.hasOccurrence(HidQualifierCache.TYPEDEF_PROTOTYPE_QUALIFIER)) {
                    return true;
                }
                if (hid.hasQualifier(HidQualifierCache.NON_ANSI_PORT_REFERENCE)) {
                    return true;
                }
                IRfNamedElement hidNamedElement = hid.getElement();
                if (Check_SVTB_31_1_0.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (hidNamedElement instanceof RfNamedElement) {
                    RfField enumElement;
                    RfStruct enumType;
                    RfNamedElement elementInGenericScope = ((RfNamedElement)hidNamedElement).getElementInGenericScope();
                    if (elementInGenericScope != null) {
                        hidNamedElement = elementInGenericScope;
                    }
                    if (hidNamedElement instanceof RfResultImplicitVariable) {
                        RfFunction function = Check_SVTB_31_1_0.this.getFunctionFromResultImplicitVariable(hid);
                        if (function != null) {
                            Check_SVTB_31_1_0.this.setReference(function, ReferencedInfo.ReferenceEnum.REFERENCED);
                        } else {
                            Check_SVTB_31_1_0.this.setReference(hidNamedElement, ReferencedInfo.ReferenceEnum.REFERENCED);
                        }
                        return true;
                    }
                    if (hidNamedElement instanceof RfField && ((RfField)hidNamedElement).isEnumElement() && (enumType = (enumElement = (RfField)hidNamedElement).getEnclosingScope(RfStruct.class)) != null) {
                        Check_SVTB_31_1_0.this.setReference(enumType, ReferencedInfo.ReferenceEnum.REFERENCED);
                    }
                    HidOccurrence ocurrence = hid.getOccurrence();
                    Set<HidOccurrence> asignments = Check_SVTB_31_1_0.this.fConstructorAssignments.get(this.parserPath);
                    if (asignments != null && !asignments.isEmpty() && asignments.contains(ocurrence)) {
                        return true;
                    }
                    if (hidNamedElement instanceof RfFunction && ((RfFunction)hidNamedElement).isPredefined()) {
                        return true;
                    }
                    if (hidNamedElement instanceof RfFunction && ((HidHolder)this.holder).getScope() == hidNamedElement) {
                        return true;
                    }
                    IReparseInfo reparseInfo = hid.getReparseInfo();
                    if (Check_SVTB_31_1_0.this.pReportClassesUsedOnlyInFactoryRegistration && hidNamedElement instanceof RfClass && reparseInfo instanceof ReparseInfo) {
                        ReparseInfo.ReparseElement[] reparseStack = ((ReparseInfo)reparseInfo).getReparseStack();
                        int i = 0;
                        while (i < reparseStack.length) {
                            if (Check_SVTB_31_1_0.this.UVM_REGISTRATION_MACROS.contains(reparseStack[i].getReparseMacroName())) {
                                return true;
                            }
                            ++i;
                        }
                    }
                    Check_SVTB_31_1_0.this.setReference(hidNamedElement, ReferencedInfo.ReferenceEnum.REFERENCED);
                } else if (Check_SVTB_31_1_0.this.pAnalyzeTypeParameterAccessValue) {
                    HidAccess parentAccess = hid.getParentAccess();
                    if (parentAccess == null) {
                        return true;
                    }
                    RfHid parentHid = (RfHid)parentAccess.getParentHid();
                    if (parentHid == null) {
                        return true;
                    }
                    IRfNamedElement parentElement = parentHid.getElement();
                    if (parentElement == null || !(parentElement instanceof RfNamedElement)) {
                        return true;
                    }
                    RfNamedElement enclosingType = ((RfNamedElement)parentElement).getClosestTypeContainer();
                    if (enclosingType == null) {
                        return true;
                    }
                    if (enclosingType instanceof RfClass && (this.fPrevParentHid == null || this.fPrevParentHid != parentHid)) {
                        Check_SVTB_31_1_0.this.fTypeAccessHids.add(parentHid);
                        this.fPrevParentHid = parentHid;
                    }
                }
                return true;
            }
        };
        rfProject.visitHidObject(rfProject, hidVisitor);
        if (this.pAnalyzeTypeParameterAccessValue) {
            this.createNameTAHidMap();
            neVisitor = namedElement -> {
                this.notifyCheckAliveLowGranularity();
                if (this.checkPreWaivers(namedElement.getFile())) {
                    return true;
                }
                if (!(namedElement.isPredefined() || this.isReferenced(namedElement) || namedElement instanceof RfLibrary || namedElement instanceof RfProgram || namedElement instanceof RfPackage || namedElement instanceof RfEventTrigger || namedElement instanceof RfInstance || namedElement instanceof RfConstraint || namedElement instanceof RfCovercross || namedElement instanceof RfCoverpoint || namedElement instanceof RfActionBlock || namedElement instanceof RfAssertExpect || namedElement instanceof RfClockingBlock)) {
                    RfField field;
                    RfInstanceHolder enclosingInstanceHolder = (RfInstanceHolder)namedElement.getEnclosingScope(this.instanceHolderClasses);
                    if (enclosingInstanceHolder != null && !enclosingInstanceHolder.getSemanticEnable() && !namedElement.equals(enclosingInstanceHolder)) {
                        return true;
                    }
                    if (namedElement instanceof RfFunction) {
                        RfFunction function = (RfFunction)namedElement;
                        if (!function.isConstructor() && !this.isUsedFunction(function)) {
                            this.analyzeNameTAHids(function);
                        }
                    } else if (namedElement instanceof RfField && (field = (RfField)namedElement).isField() && field.getEnclosingScope() instanceof RfClass) {
                        this.analyzeNameTAHids(field);
                    }
                }
                return true;
            };
            rfProject.accept(neVisitor);
        }
        neVisitor = namedElement -> {
            this.notifyCheckAliveLowGranularity();
            if (this.checkPreWaivers(namedElement.getFile())) {
                return true;
            }
            if (LintUtils.isInsideMacroWithPrefix(namedElement, this.pSkipEntitiesDeclaredInsideMacrosWithPrefixesValue)) {
                return true;
            }
            if (LintUtils.isInsidePackageWithPrefix(namedElement, this.pSkipEntitiesDeclaredInsidePackagesWithPrefixesValue)) {
                return true;
            }
            if (!(namedElement == null || namedElement.isPredefined() || this.isReferenced(namedElement) || namedElement instanceof RfLibrary || namedElement instanceof RfForwardTypedef || namedElement instanceof RfProgram || namedElement instanceof RfPackage || namedElement instanceof RfEventTrigger || namedElement instanceof RfInstance || namedElement instanceof RfConstraint || namedElement instanceof RfCovercross || namedElement instanceof RfCoverpoint || namedElement instanceof RfActionBlock || namedElement instanceof RfAssertExpect || namedElement instanceof RfClockingBlock || namedElement instanceof RfGenerateBlock || namedElement instanceof RfWait || namedElement instanceof RfStruct || namedElement instanceof RfCoverbin)) {
                RfInstanceHolder enclosingInstanceHolder = (RfInstanceHolder)namedElement.getEnclosingScope(this.instanceHolderClasses);
                if (enclosingInstanceHolder != null && !enclosingInstanceHolder.getSemanticEnable() && !namedElement.equals(enclosingInstanceHolder)) {
                    return true;
                }
                if (!(namedElement instanceof RfResultImplicitVariable)) {
                    String elementKind = LintUtils.getElementKind(namedElement);
                    if (this.skipTypes.contains(elementKind)) {
                        return true;
                    }
                    if (namedElement instanceof RfClass) {
                        if (!this.isUsedClass((RfClass)namedElement)) {
                            this.localAddHit(namedElement, "Unused " + elementKind + " '" + namedElement.getFullName() + "'!");
                        }
                    } else if (namedElement instanceof RfFunction) {
                        RfFunction function = (RfFunction)namedElement;
                        if (!(function.isConstructor() || this.pSkipExportDPIFunctionsValue && function.isExportDPI() || this.isUsedFunction(function))) {
                            this.localAddHit(namedElement, "Unused " + elementKind + " '" + namedElement.getFullName() + "()'!");
                        }
                    } else if (namedElement instanceof RfField && ((RfField)namedElement).isArgument()) {
                        if (!this.isUsedArgument((RfField)namedElement)) {
                            RfNamedElement argumentScope = namedElement.getEnclosingScope();
                            this.localAddHit(namedElement, "Unused " + elementKind + " '" + namedElement.getFullName() + "'" + (argumentScope == null ? "" : " of '" + argumentScope.getFullName() + "()'") + "!");
                        }
                    } else if (namedElement instanceof RfField && ((RfField)namedElement).isVariable()) {
                        RfNamedElement variableScope = namedElement.getEnclosingScope(RfFunction.class);
                        this.localAddHit(namedElement, "Unused " + elementKind + " '" + namedElement.getFullName() + "'" + (variableScope == null ? "" : " of '" + variableScope.getFullName() + "()'") + "!");
                    } else if (namedElement instanceof RfField && ((RfField)namedElement).isEnumElement()) {
                        RfNamedElement packageScope = namedElement.getEnclosingScope(RfPackage.class);
                        this.localAddHit(namedElement, "Unused " + elementKind + " '" + (packageScope == null ? "" : String.valueOf(packageScope.getName()) + "::") + namedElement.getName() + "'" + "!");
                    } else {
                        RfStruct associatedEnum;
                        IRfNamedElement associatedType;
                        String dataName;
                        DataType dataType;
                        boolean reportIt = true;
                        if (namedElement instanceof RfTypeAlias && (dataType = ((RfTypeAlias)namedElement).getDataType()) != null && (dataName = dataType.getType()) != null && dataName.startsWith("enum") && (associatedType = ((RfTypeAlias)namedElement).getAssociatedTypeNoLastLevelParams(RfTypesResolver.create((IRfScopeElement)namedElement.getEnclosingScope(), this.fOVMProject.getRfProject(), 10))) instanceof RfStruct && (associatedEnum = (RfStruct)associatedType).isEnum() && this.isReferenced(associatedEnum)) {
                            reportIt = false;
                        }
                        if (namedElement instanceof RfField) {
                            for (Map.Entry<RfPort, Set<RfNamedElement>> entry : this.implicitPortsWithScopesOfInstance.entrySet()) {
                                RfPort port = entry.getKey();
                                Set<RfNamedElement> scopes = entry.getValue();
                                if (!port.getName().equals(namedElement.getName()) || !scopes.contains(namedElement.getEnclosingScope())) continue;
                                reportIt = false;
                                break;
                            }
                        }
                        if (reportIt) {
                            String message = String.valueOf(elementKind) + " '" + namedElement.getFullName() + "'";
                            if (this.hasMultipleInputs(namedElement)) {
                                message = String.valueOf(message.substring(0, 1).toUpperCase()) + message.substring(1);
                                message = String.valueOf(message) + " connects two or more inputs (not connected to a driver)";
                            } else if (this.hasMultipleOutputs(namedElement)) {
                                message = String.valueOf(message.substring(0, 1).toUpperCase()) + message.substring(1);
                                message = String.valueOf(message) + " connects two or more outputs (not connected to a load)";
                            } else {
                                message = "Unused " + message + "!";
                            }
                            this.localAddHit(namedElement, message);
                        }
                    }
                }
            }
            return true;
        };
        rfProject.accept(neVisitor);
        this.referencedInfo.clear();
    }

    protected void checkIfUsedInPatternAssignment(HidOperator hidObject) {
        IHidObject lhValue = hidObject.getLHValue();
        if (!(lhValue instanceof RfHid)) {
            return;
        }
        RfHid rfHid = (RfHid)lhValue;
        if (!(rfHid.getElement() instanceof RfField)) {
            return;
        }
        this.setReference(rfHid.getElement(), ReferencedInfo.ReferenceEnum.REFERENCED);
    }

    private void localAddHit(RfNamedElement elm, String details) {
        if (this.topModules.contains(elm)) {
            return;
        }
        if (this.pSkipPublicAPIValue && this.isPublicAPI(elm)) {
            return;
        }
        if (this.pSkipPublicFunctionArgumentsValue && this.isPublicFunctionArgument(elm)) {
            return;
        }
        if (this.pSkipProtectedAPIValue && this.isProtectedAPI(elm)) {
            return;
        }
        if (this.pSkipProtectedFunctionArgumentsValue && this.isProtectedFunctionArgument(elm)) {
            return;
        }
        if (this.pSkipPackageAPIValue && this.isPackageAPI(elm)) {
            return;
        }
        if (this.pSkipGlobalAPIValue && this.isGlobalAPI(elm)) {
            return;
        }
        if (this.pSkipModulesValue && this.isModule(elm)) {
            return;
        }
        this.addHit(elm, details, new VerissimoAutofixAdditionalInfo(elm));
    }

    private boolean isModule(RfNamedElement elm) {
        if (elm == null) {
            return false;
        }
        return elm instanceof RfModule;
    }

    private boolean isPublicAPI(RfNamedElement elm) {
        if (elm == null) {
            return false;
        }
        return !(!elm.isPublic() || elm instanceof RfField && ((RfField)elm).isLocalParameter() || elm instanceof RfField && ((RfField)elm).isVariable() || elm instanceof RfField && ((RfField)elm).isArgument());
    }

    private boolean isPublicFunctionArgument(RfNamedElement elm) {
        RfNamedElement elmScope;
        if (elm == null) {
            return false;
        }
        return elm instanceof RfField && ((RfField)elm).isArgument() && (elmScope = elm.getEnclosingScope()) instanceof RfFunction && this.isPublicAPI(elmScope);
    }

    private boolean isProtectedAPI(RfNamedElement elm) {
        if (elm == null) {
            return false;
        }
        return !(!elm.isProtected() || elm instanceof RfField && ((RfField)elm).isLocalParameter() || elm instanceof RfField && ((RfField)elm).isVariable() || elm instanceof RfField && ((RfField)elm).isArgument());
    }

    private boolean isProtectedFunctionArgument(RfNamedElement elm) {
        RfNamedElement elmScope;
        if (elm == null) {
            return false;
        }
        return elm instanceof RfField && ((RfField)elm).isArgument() && (elmScope = elm.getEnclosingScope()) instanceof RfFunction && this.isProtectedAPI(elmScope);
    }

    private boolean isPackageAPI(RfNamedElement elm) {
        if (elm == null) {
            return false;
        }
        if (elm instanceof RfClass) {
            return false;
        }
        RfNamedElement elmScope = elm.getEnclosingScope();
        while (elmScope != null) {
            if (elmScope instanceof RfClass) {
                return false;
            }
            if (elmScope instanceof RfPackage) {
                return true;
            }
            elmScope = elmScope.getEnclosingScope();
        }
        return false;
    }

    private boolean isGlobalAPI(RfNamedElement elm) {
        if (elm == null) {
            return false;
        }
        RfNamedElement elmScope = elm.getEnclosingScope();
        while (elmScope != null) {
            if (elmScope instanceof RfPackage) {
                return false;
            }
            elmScope = elmScope.getEnclosingScope();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isUsedFunction(RfFunction function) {
        if (function == null) {
            return false;
        }
        enclosingScope = function.getEnclosingScope();
        if (enclosingScope == null || !(enclosingScope instanceof RfClass)) {
            return this.isReferenced(function);
        }
        classs = (RfClass)enclosingScope;
        result = this.isReferenced(function);
        if (result) {
            return true;
        }
        parentClass = classs.getParent();
        if (!this.shouldSkipImplementedMethods(classs, parentClass, function)) ** GOTO lbl20
        return true;
lbl-1000:
        // 1 sources

        {
            if (parentClass instanceof RfSpecializedClass) {
                parentClass = parentClass.getGenericClass();
            }
            if ((parentFunction = parentClass.getLocalMember(RfFunction.class, function.getName(), false)) != null) {
                v0 = result = result != false || this.isReferenced(parentFunction) != false;
            }
            if (parentFunction != null && parentFunction.hasVirtualQualifier() && result) {
                return true;
            }
            parentClass = parentClass.getParent();
lbl20:
            // 2 sources

            ** while (parentClass != null)
        }
lbl21:
        // 1 sources

        return this.isReferenced(function);
    }

    private boolean shouldSkipImplementedMethods(RfClass classs, RfClass parentClass, RfFunction function) {
        if (this.pSkipImplementedMethods) {
            RfFunction parentFunction;
            List<RfClass> parentInterfaces = classs.getParentInterfaces();
            if (parentInterfaces != null && !parentInterfaces.isEmpty()) {
                for (RfClass parentInterface : parentInterfaces) {
                    RfFunction interfaceFunction = parentInterface.getFunctionWithPrefix(function.getName(), 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                    if (interfaceFunction == null || !interfaceFunction.isPure() || !interfaceFunction.hasVirtualQualifier() || function.isPure()) continue;
                    return true;
                }
            }
            if (parentClass != null && (parentFunction = parentClass.getFunctionWithPrefix(function.getName(), 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) != null && parentFunction.isPure() && parentFunction.hasVirtualQualifier() && !function.isPure()) {
                return true;
            }
        }
        return false;
    }

    private boolean isUsedClass(RfClass classs) {
        if (classs == null) {
            return false;
        }
        if (this.isReferenced(classs)) {
            return true;
        }
        Set<RfClass> children = classs.getChildren();
        return children != null && !children.isEmpty();
    }

    private boolean isUsedArgument(RfField field) {
        if (field == null || !field.isArgument()) {
            return false;
        }
        if (this.isReferenced(field)) {
            return true;
        }
        RfNamedElement argumentScope = field.getEnclosingScope();
        if (argumentScope == null || !(argumentScope instanceof RfFunction)) {
            return false;
        }
        RfFunction function = (RfFunction)argumentScope;
        if (function.isImportDPI()) {
            return true;
        }
        if (function.isPure() && function.isVirtual()) {
            return true;
        }
        RfNamedElement functionScope = function.getEnclosingScope();
        if (functionScope == null || !(functionScope instanceof RfClass)) {
            return false;
        }
        RfClass parentClass = ((RfClass)functionScope).getParent();
        if (this.shouldSkipImplementedMethods((RfClass)functionScope, parentClass, function)) {
            return true;
        }
        RfFunction topVirtualFunction = LintUtils.getTopVirtualFunction(function);
        if (topVirtualFunction == null) {
            return false;
        }
        RfNamedElement topVirtualScope = topVirtualFunction.getEnclosingScope();
        if (topVirtualScope == null || !(topVirtualScope instanceof RfClass)) {
            return false;
        }
        if (LintUtils.isInsidePackageWithPrefix(topVirtualScope, this.pSkipFunctionArgumentsDefinedInPackagesWithPrefixesValue)) {
            return true;
        }
        return this.isUsedArgumentDownstream(new HashSet<RfClass>(), (RfClass)topVirtualScope, topVirtualFunction.getName(), field.getName());
    }

    private boolean isUsedArgumentDownstream(Set<RfClass> visited, RfClass classs, String functionName, String argumentName) {
        RfField argument;
        if (classs == null) {
            return false;
        }
        if (visited.contains(classs)) {
            return false;
        }
        visited.add(classs);
        RfFunction function = classs.getLocalMember(RfFunction.class, functionName, false);
        if (function != null && (argument = function.getLocalMember(RfField.class, argumentName, false)) != null && this.isReferenced(argument)) {
            return true;
        }
        Set<RfClass> children = classs.getChildren();
        if (children == null || children.isEmpty()) {
            return false;
        }
        for (RfClass child : children) {
            if (!this.isUsedArgumentDownstream(visited, child, functionName, argumentName)) continue;
            return true;
        }
        return false;
    }

    private RfFunction getFunctionFromResultImplicitVariable(RfHid hid) {
        IRfNamedElement hidNamedElement = hid.getElement();
        if (hidNamedElement == null || !(hidNamedElement instanceof RfResultImplicitVariable)) {
            return null;
        }
        if (hid.isMethodCall(false)) {
            RfNamedElement enclosingScope = ((RfResultImplicitVariable)hidNamedElement).getEnclosingScope();
            if (enclosingScope != null && enclosingScope instanceof RfFunction) {
                return (RfFunction)enclosingScope;
            }
            return null;
        }
        return null;
    }

    private void notifyCheckAliveLowGranularity() {
        ++this.ncalgCounter;
        if (this.ncalgCounter == 1000) {
            this.ncalgCounter = 0;
            this.notifyCheckAlive();
        }
    }

    private void createNameTAHidMap() {
        this.fNameTAHidMap = new HashMap<String, List<RfHid>>();
        for (RfHid taHid : this.fTypeAccessHids) {
            if (taHid == null || !taHid.hasAccesses()) continue;
            ListContainer taHidAccesses = taHid.getAccesses();
            for (HidAccess taHidAccess : taHidAccesses) {
                ListContainer taHidAccessChildren = taHidAccess.getHids();
                if (taHidAccessChildren == null) continue;
                for (Hid taHidChildHid : taHidAccessChildren) {
                    if (taHidChildHid == null) continue;
                    String taHidChildHidName = taHidChildHid.getName();
                    List<RfHid> nameHids = this.fNameTAHidMap.get(taHidChildHidName);
                    if (nameHids == null) {
                        nameHids = new ArrayList<RfHid>();
                        this.fNameTAHidMap.put(taHidChildHidName, nameHids);
                    }
                    nameHids.add((RfHid)taHidChildHid);
                }
            }
        }
    }

    private void analyzeNameTAHids(RfNamedElement namedElement) {
        if (namedElement == null) {
            return;
        }
        RfClass namedElementEnclosingClass = namedElement.getEnclosingScope(RfClass.class);
        if (namedElementEnclosingClass == null) {
            return;
        }
        List<RfHid> nameHids = this.fNameTAHidMap.get(namedElement.getName());
        if (nameHids == null) {
            return;
        }
        for (RfHid hid : nameHids) {
            IRfNamedElement parentElement;
            Hid parentHid;
            this.notifyCheckAlive();
            HidAccess parentAccess = hid.getParentAccess();
            if (parentAccess == null || (parentHid = parentAccess.getParentHid()) == null || (parentElement = parentHid.getElement()) == null) continue;
            RfField parameter = null;
            boolean shortcut = false;
            if (parentElement instanceof RfField && ((RfField)parentElement).isTypeParameter()) {
                parameter = (RfField)parentElement;
                shortcut = true;
            } else if (parentElement instanceof RfAssociatedType) {
                RfNamedElement enclosingType;
                String dataTypeName;
                DataType dataType = ((RfAssociatedType)parentElement).getDataType();
                if (dataType == null || (dataTypeName = dataType.getType()) == null || (enclosingType = ((RfAssociatedType)parentElement).getClosestTypeContainer()) == null) continue;
                parameter = enclosingType.getLocalMember(RfField.class, dataTypeName, false);
            }
            if (parameter == null || !parameter.isTypeParameter() || !(parentElement instanceof RfNamedElement)) continue;
            RfHid parentHidClone = (RfHid)parentHid.deepCopy();
            if (shortcut) {
                parentHidClone.setElement(namedElementEnclosingClass);
            } else {
                parentHidClone.setElement(parentElement);
                ListContainer accesses = parentHidClone.getAccesses();
                for (HidAccess access : accesses) {
                    access.setAssociatedType((IRfNamedElement)namedElementEnclosingClass);
                }
            }
            try {
                ConfigInfo configInfo = new ConfigInfo(false, this.fOVMProject.getRfProject(), null, true, null);
                RfNamedElement enclosingScope = ((RfNamedElement)parentElement).getEnclosingScope();
                parentHidClone.resolve(configInfo, (Object2ObjectMap<IHidObject, RfHidHolder.HidContextInfo>)new Object2ObjectOpenHashMap(), enclosingScope, enclosingScope, parentElement.getDeclaration().getParserPath(), RfTypesResolver.create((IRfScopeElement)enclosingScope, this.fOVMProject.getRfProject(), 30), null, (byte)3, true, false, false);
                RfHidVisitor hidVisitor = new RfHidVisitor(){

                    public boolean visit(RfHid hid) {
                        IRfNamedElement hidNamedElement;
                        Check_SVTB_31_1_0.this.notifyCheckAliveLowGranularity();
                        if (hid != null && (hidNamedElement = hid.getElement()) instanceof RfNamedElement) {
                            Check_SVTB_31_1_0.this.setReference(hidNamedElement, ReferencedInfo.ReferenceEnum.REFERENCED);
                        }
                        return true;
                    }
                };
                parentHidClone.visitHidObject(this.fOVMProject.getRfProject(), hidVisitor);
            }
            catch (BuildCancelException e) {
                this.fOVMProject.notifyCheckException(this, (Exception)((Object)e));
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private void flagUnusedSignals(RfProject rfProject) {
        Collection<RfLibrary> libraries = rfProject.getAllLibraries();
        if (libraries == null || libraries.isEmpty()) {
            return;
        }
        List<RfInstanceHolder> modulesAndInterfaces = rfProject.getAllInstanceHolders(libraries, null, true, false, true);
        if (modulesAndInterfaces.isEmpty()) {
            return;
        }
        HashMap dummyPortMap = new HashMap();
        for (RfInstanceHolder instanceHolder : modulesAndInterfaces) {
            List<RfInstance> instances = instanceHolder.getLocalMembers(RfInstance.class);
            if (instances == null || instances.isEmpty()) continue;
            for (RfInstance instance : instances) {
                Map ports = DesignUtils.mapInstancePortConnections((DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)instance), dummyPortMap, HID_FLATTENING);
                if (ports == null || ports.isEmpty()) continue;
                for (Map.Entry entry : ports.entrySet()) {
                    IRfPortElement port = (IRfPortElement)entry.getKey();
                    for (TCConnSignal signal : (Set)entry.getValue()) {
                        IRfNamedElement hidNamedElement = DesignUtils.resolveSignal((Object)signal.signal, (DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)instance.getEnclosingScope()), null, dummyPortMap);
                        if (!DesignUtils.isValidSignalCandidate((IRfNamedElement)hidNamedElement, null)) continue;
                        ReferencedInfo.ReferenceEnum signalDirection = ReferencedInfo.ReferenceEnum.NO_REFERENCE;
                        signalDirection = this.resolveSignalDirection((IRfNamedElement)port, false);
                        if (this.resolveParentChildCase(signalDirection, hidNamedElement)) continue;
                        this.resolveReferencedFlagForPortConnections(hidNamedElement, signalDirection);
                    }
                }
            }
        }
    }

    private void resolveReferencedFlagForPortConnections(IRfNamedElement element, ReferencedInfo.ReferenceEnum newDirection) {
        IRfNamedElement signal;
        RfNamedElement hidNamedElement = null;
        if (element instanceof RfNamedElement) {
            hidNamedElement = (RfNamedElement)element;
        }
        if (element instanceof HierarchicalElement && (signal = ((HierarchicalElement)element).getLastSegment()) instanceof RfNamedElement) {
            hidNamedElement = (RfNamedElement)signal;
        }
        if (hidNamedElement == null) {
            return;
        }
        if (this.isReferencedInPortConnOrContAssign(hidNamedElement)) {
            return;
        }
        block0 : switch (this.getReference(hidNamedElement)) {
            case REF_AS_IN_PORT: {
                switch (newDirection) {
                    case REF_AS_OUT_PORT: 
                    case REF_AS_INOUT_PORT: {
                        this.setHasChangedReference(hidNamedElement, true);
                        this.markTCHierarchicalSignalParticularAsReferenced(element);
                        break block0;
                    }
                    case REF_AS_IN_PORT: {
                        this.setHasMultipleInputs(hidNamedElement, true);
                        break block0;
                    }
                }
                break;
            }
            case REF_AS_OUT_PORT: {
                switch (newDirection) {
                    case REF_AS_IN_PORT: 
                    case REF_AS_INOUT_PORT: {
                        this.setHasChangedReference(hidNamedElement, true);
                        this.markTCHierarchicalSignalParticularAsReferenced(element);
                        break block0;
                    }
                    case REF_AS_OUT_PORT: {
                        this.setHasMultipleOutputs(hidNamedElement, true);
                        break block0;
                    }
                }
                break;
            }
            case REF_AS_INOUT_PORT: {
                switch (newDirection) {
                    case REF_AS_IN_PORT: 
                    case REF_AS_OUT_PORT: 
                    case REF_AS_INOUT_PORT: {
                        this.setHasChangedReference(hidNamedElement, true);
                        this.markTCHierarchicalSignalParticularAsReferenced(element);
                        break block0;
                    }
                }
                break;
            }
            default: {
                this.setReference(hidNamedElement, newDirection);
            }
        }
    }

    private boolean resolveParentChildCase(ReferencedInfo.ReferenceEnum childReferenced, IRfNamedElement element) {
        IRfNamedElement signal;
        RfNamedElement childNamedElement = null;
        if (element instanceof RfNamedElement) {
            childNamedElement = (RfNamedElement)element;
        }
        if (element instanceof HierarchicalElement && (signal = ((HierarchicalElement)element).getLastSegment()) instanceof RfNamedElement) {
            childNamedElement = (RfNamedElement)signal;
        }
        if (childNamedElement == null) {
            return false;
        }
        if (childReferenced == ReferencedInfo.ReferenceEnum.REFERENCED && this.getHasChangedReference(childNamedElement)) {
            return true;
        }
        ReferencedInfo.ReferenceEnum parentDirection = this.getParentDirection(element);
        switch (parentDirection) {
            case REF_AS_IN_PORT_PARENT: {
                switch (childReferenced) {
                    case REF_AS_IN_PORT: 
                    case REF_AS_INOUT_PORT: {
                        this.setHasChangedReference(childNamedElement, true);
                        this.markTCHierarchicalSignalParticularAsReferenced(element);
                        return true;
                    }
                }
                return false;
            }
            case REF_AS_OUT_PORT_PARENT: {
                switch (childReferenced) {
                    case REF_AS_OUT_PORT: 
                    case REF_AS_INOUT_PORT: {
                        this.setHasChangedReference(childNamedElement, true);
                        this.markTCHierarchicalSignalParticularAsReferenced(element);
                        return true;
                    }
                }
                return false;
            }
            case REF_AS_INOUT_PORT_PARENT: {
                switch (childReferenced) {
                    case REF_AS_IN_PORT: 
                    case REF_AS_OUT_PORT: 
                    case REF_AS_INOUT_PORT: {
                        this.setHasChangedReference(childNamedElement, true);
                        this.markTCHierarchicalSignalParticularAsReferenced(element);
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private ReferencedInfo.ReferenceEnum getParentDirection(IRfNamedElement hidNamedElement) {
        IRfScopeElement enclScope = hidNamedElement.getEnclosingScope();
        RfPort parent = null;
        ReferencedInfo.ReferenceEnum parentDirection = ReferencedInfo.ReferenceEnum.NO_REFERENCE;
        if (enclScope instanceof RfInstanceHolder || enclScope instanceof RfGenerateBlock) {
            parent = ((RfNamedElement)enclScope).getLocalMember(RfPort.class, hidNamedElement.getName(), true);
        }
        if (parent != null) {
            parentDirection = this.resolveSignalDirection(parent, true);
        }
        return parentDirection;
    }

    private ReferencedInfo.ReferenceEnum resolveSignalDirection(IRfNamedElement namedElement, boolean resolveParent) {
        if (namedElement instanceof IRfPortElement) {
            IRfPortElement port = (IRfPortElement)namedElement;
            if (resolveParent) {
                if (port.isInout()) {
                    return ReferencedInfo.ReferenceEnum.REF_AS_INOUT_PORT_PARENT;
                }
                if (port.isInput()) {
                    return ReferencedInfo.ReferenceEnum.REF_AS_IN_PORT_PARENT;
                }
                if (port.isOutput()) {
                    return ReferencedInfo.ReferenceEnum.REF_AS_OUT_PORT_PARENT;
                }
            } else {
                if (port.isInout()) {
                    return ReferencedInfo.ReferenceEnum.REF_AS_INOUT_PORT;
                }
                if (port.isInput()) {
                    return ReferencedInfo.ReferenceEnum.REF_AS_IN_PORT;
                }
                if (port.isOutput()) {
                    return ReferencedInfo.ReferenceEnum.REF_AS_OUT_PORT;
                }
            }
        }
        return ReferencedInfo.ReferenceEnum.NO_REFERENCE;
    }

    private void flagUnusedContinuousAssigns(RfProject rfProject) {
        HidOperatorVisitor operatorVisitor = new HidOperatorVisitor(new HidOperatorQualifier[]{HidOperatorQualifier.IS_CONTINUOUS_ASSIGN, HidOperatorQualifier.IS_ALIAS});
        rfProject.visitHidObject(rfProject, (IHidVisitor<?>)operatorVisitor);
        List allAssigns = operatorVisitor.getObjects();
        if (allAssigns == null) {
            return;
        }
        for (IHidOperator operator : allAssigns) {
            TCLogic logic = new TCLogic();
            DesignUtils.collectConcurrentDriversAndLoads((IHidOperator)operator, (TCLogic)logic, (Set)DesignUtils.ASSIGN_HID_FLATTENING);
            Map loadDrivers = logic.getLoadDrivers();
            for (Map.Entry entry : loadDrivers.entrySet()) {
                IHid load = (IHid)entry.getKey();
                Collection drivers = (Collection)entry.getValue();
                IRfNamedElement hidNamedElement = load.getElement();
                if (DesignUtils.isValidSignalCandidate((IRfNamedElement)hidNamedElement, null)) {
                    this.resolveReferencedFlagForElementsInContinuousAssigns(load, hidNamedElement, loadDrivers.keySet(), drivers, false);
                }
                for (IHid driver : drivers) {
                    IRfNamedElement driverNamedElement = driver.getElement();
                    if (!DesignUtils.isValidSignalCandidate((IRfNamedElement)hidNamedElement, null)) continue;
                    this.resolveReferencedFlagForElementsInContinuousAssigns(driver, driverNamedElement, loadDrivers.keySet(), drivers, true);
                }
            }
        }
    }

    private void resolveReferencedFlagForElementsInContinuousAssigns(IHid hid, IRfNamedElement element, Collection<IHid> loads, Collection<IHid> drivers, boolean isDriver) {
        IRfNamedElement signal;
        RfNamedElement namedElement = null;
        if (element instanceof RfNamedElement) {
            namedElement = (RfNamedElement)element;
        }
        if (element instanceof HierarchicalElement && (signal = ((HierarchicalElement)element).getLastSegment()) instanceof RfNamedElement) {
            namedElement = (RfNamedElement)signal;
        }
        if (namedElement == null) {
            return;
        }
        if (namedElement.getEnclosingScope() instanceof RfInterface && this.getReference(namedElement) == ReferencedInfo.ReferenceEnum.REFERENCED || this.isReferencedInPortConnOrContAssign(namedElement)) {
            return;
        }
        switch (this.getReference(namedElement)) {
            case REF_AS_IN_PORT: {
                if (isDriver) {
                    if (loads.contains(hid) && loads.size() <= 1) break;
                    this.setHasChangedReference(namedElement, true);
                    this.markTCHierarchicalSignalParticularAsReferenced(element);
                    break;
                }
                if (drivers.contains(hid)) {
                    this.setReference(namedElement, ReferencedInfo.ReferenceEnum.REF_AS_INOUT_PORT);
                    break;
                }
                this.setHasMultipleInputs(namedElement, true);
                break;
            }
            case REF_AS_OUT_PORT: {
                if (!isDriver) {
                    this.setHasChangedReference(namedElement, true);
                    this.markTCHierarchicalSignalParticularAsReferenced(element);
                    break;
                }
                this.setHasMultipleOutputs(namedElement, true);
                break;
            }
            case REF_AS_INOUT_PORT: {
                if (isDriver && loads.contains(hid) && loads.size() <= 1) break;
                this.setHasChangedReference(namedElement, true);
                this.markTCHierarchicalSignalParticularAsReferenced(element);
                break;
            }
            default: {
                if (isDriver) {
                    if (!loads.contains(hid)) {
                        this.setReference(namedElement, ReferencedInfo.ReferenceEnum.REF_AS_OUT_PORT);
                    }
                } else if (drivers.contains(hid)) {
                    this.setReference(namedElement, ReferencedInfo.ReferenceEnum.REF_AS_INOUT_PORT);
                } else {
                    this.setReference(namedElement, ReferencedInfo.ReferenceEnum.REF_AS_IN_PORT);
                }
                this.resolveParentChildCase(this.getReference(namedElement), namedElement);
            }
        }
    }

    private void markTCHierarchicalSignalParticularAsReferenced(IRfNamedElement element) {
        IRfNamedElement particular;
        if (element instanceof HierarchicalElement && (particular = ((HierarchicalElement)element).getFirstSegment()) instanceof RfNamedElement) {
            this.setReference(particular, ReferencedInfo.ReferenceEnum.REFERENCED);
        }
    }

    private boolean getHasChangedReference(IRfNamedElement namedElement) {
        ReferencedInfo info = this.referencedInfo.get(namedElement);
        if (info == null) {
            info = new ReferencedInfo();
            this.referencedInfo.put(namedElement, info);
        }
        return info.getHasChangedReference();
    }

    private boolean isReferenced(IRfNamedElement namedElement) {
        ReferencedInfo info = this.referencedInfo.get(namedElement);
        if (info == null) {
            info = new ReferencedInfo();
            this.referencedInfo.put(namedElement, info);
        }
        return info.isReferenced();
    }

    private boolean isReferencedInPortConnOrContAssign(IRfNamedElement namedElement) {
        ReferencedInfo info = this.referencedInfo.get(namedElement);
        if (info == null) {
            info = new ReferencedInfo();
            this.referencedInfo.put(namedElement, info);
        }
        return info.isReferencedInPortConnOrContAssign();
    }

    private void setHasMultipleInputs(IRfNamedElement namedElement, boolean hasMultipleInputs) {
        ReferencedInfo info = this.referencedInfo.get(namedElement);
        if (info == null) {
            info = new ReferencedInfo();
            this.referencedInfo.put(namedElement, info);
        }
        info.setHasMultipleInputs(hasMultipleInputs);
    }

    private void setHasMultipleOutputs(IRfNamedElement namedElement, boolean hasMultipleOutputs) {
        ReferencedInfo info = this.referencedInfo.get(namedElement);
        if (info == null) {
            info = new ReferencedInfo();
            this.referencedInfo.put(namedElement, info);
        }
        info.setHasMultipleOutputs(hasMultipleOutputs);
    }

    private void setHasChangedReference(IRfNamedElement namedElement, boolean hasChanged) {
        ReferencedInfo info = this.referencedInfo.get(namedElement);
        if (info == null) {
            info = new ReferencedInfo();
            this.referencedInfo.put(namedElement, info);
        }
        info.setHasChangedReference(hasChanged);
    }

    private void setReference(IRfNamedElement namedElement, ReferencedInfo.ReferenceEnum referenced) {
        ReferencedInfo info = this.referencedInfo.get(namedElement);
        if (info == null) {
            info = new ReferencedInfo();
            this.referencedInfo.put(namedElement, info);
        }
        info.setReference(referenced);
    }

    private ReferencedInfo.ReferenceEnum getReference(IRfNamedElement namedElement) {
        ReferencedInfo info = this.referencedInfo.get(namedElement);
        if (info == null) {
            info = new ReferencedInfo();
            this.referencedInfo.put(namedElement, info);
        }
        return info.getReference();
    }

    private boolean hasMultipleInputs(IRfNamedElement namedElement) {
        ReferencedInfo info = this.referencedInfo.get(namedElement);
        if (info == null) {
            info = new ReferencedInfo();
            this.referencedInfo.put(namedElement, info);
        }
        return info.hasMultipleInputs();
    }

    private boolean hasMultipleOutputs(IRfNamedElement namedElement) {
        ReferencedInfo info = this.referencedInfo.get(namedElement);
        if (info == null) {
            info = new ReferencedInfo();
            this.referencedInfo.put(namedElement, info);
        }
        return info.hasMultipleOutputs();
    }

    private void resetLinterFlags(RfNamedElement namedElement) {
        this.referencedInfo.put(namedElement, new ReferencedInfo());
    }

    @Override
    public String getAdditionalInfoForDisplayString(OVMComplianceCheckHit hit) {
        VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
        if (additionalInfo == null) {
            return null;
        }
        Object element = additionalInfo.getElement();
        if (!(element instanceof RfNamedElement)) {
            return null;
        }
        return String.valueOf(LintUtils.getElementKind((RfNamedElement)element)) + " '" + ((RfNamedElement)element).getName() + "'";
    }

    public static RfNamedElement getAssociatedType(IRfAssociatedTypeElement aAssociatedType, IRfNamedElement scope) {
        if (aAssociatedType == null) {
            return null;
        }
        HashSet<String> typeAliasNames = new HashSet<String>();
        IRfNamedElement associatedType = aAssociatedType instanceof RfAssociatedType ? ((RfAssociatedType)aAssociatedType).getAssociatedType(RfTypesResolver.create((IRfScopeElement)scope, scope.getRfProject(), 10)) : aAssociatedType.getAssociatedType();
        while (associatedType instanceof RfTypeAlias) {
            String associatedTypeSig = String.valueOf(associatedType.getName()) + ((RfAssociatedType)associatedType).getUnpackedDimension();
            if (typeAliasNames.contains(associatedTypeSig)) {
                return (RfNamedElement)associatedType;
            }
            if (!(associatedType instanceof RfTypeAlias)) continue;
            typeAliasNames.add(associatedTypeSig);
            associatedType = ((RfTypeAlias)associatedType).getAssociatedType();
        }
        return associatedType instanceof RfNamedElement ? (RfNamedElement)associatedType : null;
    }

    private void checkIfIsNamedImplicitPortConnection(HidOperator hidOperator, RfInstance instance) {
        if (hidOperator == null || instance == null) {
            return;
        }
        ListContainer rhValues = hidOperator.getRHValues();
        if (rhValues.size() > 1) {
            return;
        }
        IHidObject rhHid = (IHidObject)rhValues.get(0);
        if (!(rhHid instanceof RfHidImplicit) || !((RfHidImplicit)rhHid).isConnectedAssociation()) {
            return;
        }
        if (hidOperator.getLHValue() == null) {
            return;
        }
        if (!(hidOperator.getLHValue() instanceof RfHid) && !(hidOperator.getLHValue() instanceof RfHidImplicit)) {
            return;
        }
        if (hidOperator.getLHValue() instanceof RfHidImplicit && ((RfHidImplicit)hidOperator.getLHValue()).isDotStarAssociation()) {
            IRfDesignElement instanceDesign = (IRfDesignElement)instance.getGenericDesign(null);
            if (instanceDesign == null) {
                return;
            }
            List listOfPorts = instanceDesign.getPortsWithPrefix("", 2);
            if (listOfPorts == null || listOfPorts.isEmpty()) {
                return;
            }
            for (IRfPortElement portElement : listOfPorts) {
                if (!(portElement instanceof RfPort)) continue;
                RfPort port = (RfPort)portElement;
                Set<RfNamedElement> scopes = this.implicitPortsWithScopesOfInstance.get(port);
                if (scopes == null) {
                    scopes = new HashSet<RfNamedElement>();
                }
                RfNamedElement instanceHolderScope = instance.getEnclosingScope();
                while (!(instanceHolderScope instanceof RfInstanceHolder) && instanceHolderScope != null) {
                    instanceHolderScope = instanceHolderScope.getEnclosingScope();
                }
                if (instanceHolderScope != null) {
                    scopes.add(instanceHolderScope);
                }
                this.implicitPortsWithScopesOfInstance.put(port, scopes);
            }
            return;
        }
        if (hidOperator.getLHValue() instanceof RfHidImplicit) {
            return;
        }
        RfHid lhValue = (RfHid)hidOperator.getLHValue();
        RfPort port = (RfPort)lhValue.getElement();
        Set<RfNamedElement> scopes = this.implicitPortsWithScopesOfInstance.get(port);
        if (scopes == null) {
            scopes = new HashSet<RfNamedElement>();
        }
        RfNamedElement instanceHolderScope = instance.getEnclosingScope();
        while (!(instanceHolderScope instanceof RfInstanceHolder) && instanceHolderScope != null) {
            instanceHolderScope = instanceHolderScope.getEnclosingScope();
        }
        if (instanceHolderScope != null) {
            scopes.add(instanceHolderScope);
        }
        this.implicitPortsWithScopesOfInstance.put(port, scopes);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.checkPreWaivers(fileDef.getParserPath());
    }

    @Override
    public void clean() {
        super.clean();
        if (this.referencedInfo != null) {
            this.referencedInfo.clear();
        }
        if (this.fConstructorAssignments != null) {
            this.fConstructorAssignments.clear();
        }
        if (this.instanceHolderClasses != null) {
            this.instanceHolderClasses.clear();
        }
        if (this.topModules != null) {
            this.topModules.clear();
        }
        if (this.implicitPortsWithScopesOfInstance != null) {
            this.implicitPortsWithScopesOfInstance.clear();
        }
    }
}

