/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_31_2_0;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.VlogFileInstance;

@CheckVersion(value="3.5.24")
@CheckID(value="SVTB.31.2.0")
@CheckName(value="SVTB.31.2.0")
@CheckLabel(labels={RuleLabel.DEAD_CODE, RuleLabel.MACRO})
@CheckTitle(value="Unused macro")
@CheckDescription(value="Flags unused macros.\n\nExamples:\n`define MACRO1 1 // allowed\n`define MACRO2 2 // not allowed (not used)\nint x = `MACRO1;\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_SVTB_31_2_0.class)
@CheckReapplyDisable
public class Check_SVTB_31_2_0
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="uvm,UVM, m_uvm, M_UVM, M_FIELD_QDA_ENUM", description="Comma separated list of macro prefixes.", name="skipMacrosWithPrefixes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipMacrosWithPrefixesValue;
    @CheckParameter(defaultValue="false", description="If true, the macros defined by another macro using its arguments are ignored.", name="skipMacrosDefinedByMacroArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipMacrosDefinedByMacroArguments;

    public Check_SVTB_31_2_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        rfProject.visitMacros(macroInfo -> {
            if (macroInfo != null && !rfProject.lintIsMacroCalled(macroInfo)) {
                ReparseInfo.ReparseElement lastReparseElement;
                VlogFileInstance fileInstance = macroInfo.getFileInstance();
                if (fileInstance == null) {
                    return true;
                }
                String fileName = fileInstance.getShortFileName();
                if (fileName.startsWith("__vlog__")) {
                    return true;
                }
                this.notifyCheckAlive();
                ParserPath parserPath = fileInstance.getParserPath();
                if (this.checkPreWaivers(parserPath)) {
                    return true;
                }
                String macroName = macroInfo.getName();
                if (macroName == null) {
                    return true;
                }
                boolean skipMacro = false;
                for (String prefix : this.pSkipMacrosWithPrefixesValue) {
                    if (!macroName.startsWith(prefix)) continue;
                    skipMacro = true;
                    break;
                }
                if (this.pSkipMacrosDefinedByMacroArguments && !skipMacro && (lastReparseElement = macroInfo.getReparseElement()) != null && lastReparseElement.getReparseMacroParams() != null && lastReparseElement.getReparseMacroParams().length != 0) {
                    String[] stringArray = lastReparseElement.getReparseMacroParams();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String macroParam = stringArray[n2];
                        if (macroName.equals(macroParam)) {
                            skipMacro = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!skipMacro && parserPath != null && !parserPath.isEmpty()) {
                    this.addHit(parserPath, macroInfo.getLine(), "Unused macro '" + macroName + "'!", null, new VerissimoAutofixAdditionalInfo(macroInfo));
                }
            }
            return true;
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

