/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfMacroVisitor;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogException;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroParameter;
import ro.amiq.vlogdt.parser.VlogMacroText;

@CheckVersion(value="17.1.45")
@CheckID(value="SVTB.31.2.1")
@CheckName(value="SVTB.31.2.1")
@CheckLabel(labels={RuleLabel.DEAD_CODE, RuleLabel.MACRO, RuleLabel.ARGUMENT})
@CheckTitle(value="Unused macro parameter")
@CheckDescription(value="Flags unused macro parameters.\n\nCheck supports pre-waiving.")
public class Check_SVTB_31_2_1
extends OVMComplianceCheck {
    public Check_SVTB_31_2_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        IRfMacroVisitor visitor = new IRfMacroVisitor(){

            @Override
            public boolean visit(VlogMacroInfo macroInfo) {
                if (macroInfo == null) {
                    return true;
                }
                VlogFileInstance fileInstance = macroInfo.getFileInstance();
                if (fileInstance == null || fileInstance.getShortFileName().startsWith("__vlog__")) {
                    return true;
                }
                if (Check_SVTB_31_2_1.this.checkPrewaivers(fileInstance.getParserPath())) {
                    return true;
                }
                if (!macroInfo.hasParams()) {
                    return true;
                }
                Check_SVTB_31_2_1.this.notifyCheckAlive();
                List<VlogMacroInfo> macroLayers = macroInfo.getMacroZoneLayers();
                try {
                    for (VlogMacroInfo macroLayer : macroLayers) {
                        List<VlogMacroParameter> parameters;
                        VlogMacroText macroText = macroLayer.getMacroText();
                        if (macroText == null || (parameters = macroText.getMacroParameters()) == null || parameters.isEmpty()) continue;
                        String[] generatedParams = new String[parameters.size()];
                        int i = 0;
                        while (i < parameters.size()) {
                            generatedParams[i] = RandomStringUtils.randomAlphabetic((int)16);
                            ++i;
                        }
                        String replacedString = macroText.getReplacement(fileInstance, generatedParams);
                        int i2 = 0;
                        while (i2 < parameters.size()) {
                            if (!replacedString.contains(generatedParams[i2])) {
                                Check_SVTB_31_2_1.this.addHit(fileInstance.getParserPath(), macroLayer.getLine(), "Unused macro parameter '" + parameters.get(i2).getName() + "' in macro '" + macroLayer.getName() + "'!", null, new VerissimoAutofixAdditionalInfo(parameters.get(i2), macroLayer));
                            }
                            ++i2;
                        }
                    }
                }
                catch (VlogException e) {
                    Check_SVTB_31_2_1.this.fOVMProject.notifyCheckException(Check_SVTB_31_2_1.this, e);
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                return true;
            }
        };
        rfProject.visitMacros(visitor);
    }

    @Override
    public String getAdditionalInfoForDisplayString(OVMComplianceCheckHit hit) {
        VerissimoAutofixAdditionalInfo additionalInfo = hit.getAutofixAdditionalInfo();
        if (additionalInfo == null) {
            return null;
        }
        Object element = additionalInfo.getElement();
        if (!(element instanceof VlogMacroParameter)) {
            return null;
        }
        return ((VlogMacroParameter)element).getName();
    }

    private boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

