/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_31_3_0;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.Check_SVTB_31_3_base;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="20.1.14")
@CheckID(value="SVTB.31.3.0")
@CheckName(value="SVTB.31.3.0")
@CheckLabel(labels={RuleLabel.DEAD_CODE})
@CheckTitle(value="Empty statement")
@CheckDescription(value="Flags empty statements.\n\nExample:\n ;; // flagged\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
@CheckAutofix(value=Autofix_SVTB_31_3_0.class)
public class Check_SVTB_31_3_0
extends Check_SVTB_31_3_base {
    private static final String EMPTY_STATEMENT_MESSAGE = "Empty statement found!";
    private static final String EMPTY_STATEMENT_IN_MACRO_MESSAGE = "Empty statement found in macro ''`{0}''!";
    private static final String MACRO_FINISHING_IN_SEMI_MESSAGE = "Macro ''`{0}'' is followed by a semicolon!";
    private static final String EMPTY_CASE_BLOCK = "Case block contains only empty case items!";
    private static final String ALWAYS = "always";
    private static final String CASE_ITEM = "case_item";
    private static final String ELSE = "else";
    private static final String IF = "if";
    @CheckParameter(defaultValue="", description="Comma separated list of statements that will be checked. When no value is specified, all empty statements will be reported. Allowed values: always, case_item, do, else, for, foreach, forever, if, repeat, while", name="checkedStatements", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pCheckedStatements;
    private final Map<SVTBIssues, RfDefElement> defElementOfIssue = new HashMap<SVTBIssues, RfDefElement>();

    public Check_SVTB_31_3_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        if (this.pCheckedStatements.contains(ALWAYS)) {
            this.trackStatements.add(IRfActionBlockElement.BlockQualifier.ALWAYS.name());
        }
        if (this.pCheckedStatements.contains(CASE_ITEM)) {
            this.trackStatements.add(IRfActionBlockElement.BlockQualifier.CASE_ITEM.name());
        }
        if (this.pCheckedStatements.contains("do")) {
            this.trackStatements.add(IRfActionBlockElement.BlockQualifier.DO.name());
        }
        if (this.pCheckedStatements.contains(ELSE)) {
            this.trackStatements.add(IRfActionBlockElement.BlockQualifier.ELSE.name());
        }
        if (this.pCheckedStatements.contains("for")) {
            this.trackStatements.add(IRfActionBlockElement.BlockQualifier.FOR.name());
        }
        if (this.pCheckedStatements.contains("forever")) {
            this.trackStatements.add(IRfActionBlockElement.BlockQualifier.FOREVER.name());
        }
        if (this.pCheckedStatements.contains("foreach")) {
            this.trackStatements.add(IRfActionBlockElement.BlockQualifier.FOREACH.name());
        }
        if (this.pCheckedStatements.contains(IF)) {
            this.trackStatements.add(IRfActionBlockElement.BlockQualifier.IF.name());
        }
        if (this.pCheckedStatements.contains("repeat")) {
            this.trackStatements.add(IRfActionBlockElement.BlockQualifier.REPEAT.name());
        }
        if (this.pCheckedStatements.contains("while")) {
            this.trackStatements.add(IRfActionBlockElement.BlockQualifier.WHILE.name());
        }
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(129);
        aRfProject.lintTrackP2LInfo(112);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        String messageForHit = issue.getMessageForHit();
        if (messageForHit != null) {
            return messageForHit;
        }
        if (issue.getReparseInfo() != null) {
            ReparseInfo reparseInfo = issue.getReparseInfo();
            if (reparseInfo == null) {
                return EMPTY_STATEMENT_MESSAGE;
            }
            ReparseInfo.ReparseElement lastReparseElement = reparseInfo.getLastReparseElement();
            if (lastReparseElement == null) {
                return EMPTY_STATEMENT_MESSAGE;
            }
            String name = lastReparseElement.getReparseMacroName();
            if (name == null) {
                return EMPTY_STATEMENT_MESSAGE;
            }
            return MessageFormat.format(EMPTY_STATEMENT_IN_MACRO_MESSAGE, name);
        }
        return EMPTY_STATEMENT_MESSAGE;
    }

    private Map<ParserPath, List<SVTBIssues>> groupSVTBIssues(Map<ParserPath, List<SVTBIssues>> issues) {
        HashMap<ParserPath, List<SVTBIssues>> result = new HashMap<ParserPath, List<SVTBIssues>>();
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : issues.entrySet()) {
            ParserPath path = entry.getKey();
            HashMap<SVTBIssues, RfActionBlock> caseItemOfIssue = new HashMap<SVTBIssues, RfActionBlock>();
            HashMap groupedCaseItems = new HashMap();
            block1: for (SVTBIssues issue : entry.getValue()) {
                RfDefElement defElement = this.fOVMProject.getRfProject().getFileDefUsingParserPath(path).getScope(issue.getOffset(), true);
                this.defElementOfIssue.put(issue, defElement);
                RfNamedElement iterNamedElement = defElement.getNamedElement();
                while (iterNamedElement instanceof RfActionBlock) {
                    if (((RfActionBlock)iterNamedElement).isCaseItem()) {
                        RfActionBlock caseItem = (RfActionBlock)iterNamedElement;
                        if (!(caseItem.getEnclosingScope() instanceof RfActionBlock)) continue block1;
                        RfActionBlock caseBlock = (RfActionBlock)caseItem.getEnclosingScope();
                        groupedCaseItems.putIfAbsent(caseBlock, new HashSet());
                        ((Set)groupedCaseItems.get(caseBlock)).add(caseItem);
                        caseItemOfIssue.put(issue, caseItem);
                        continue block1;
                    }
                    iterNamedElement = iterNamedElement.getEnclosingScope();
                }
            }
            HashSet<SVTBIssues> groupedIssues = new HashSet<SVTBIssues>();
            for (SVTBIssues issue : entry.getValue()) {
                if (caseItemOfIssue.containsKey(issue)) {
                    RfActionBlock caseItem = (RfActionBlock)caseItemOfIssue.get(issue);
                    if (!(caseItem.getEnclosingScope() instanceof RfActionBlock)) continue;
                    RfActionBlock caseBlock = (RfActionBlock)caseItem.getEnclosingScope();
                    if (((Set)groupedCaseItems.get(caseBlock)).size() == caseBlock.getMembers().size()) {
                        SVTBIssues caseBlockIssue = new SVTBIssues(issue.getKind(), caseBlock.getLine(), caseBlock.getStartOffset(), caseBlock.getStartOffset(), issue.getCarry(), null, null, null, null, null);
                        caseBlockIssue.setMessageForHit(EMPTY_CASE_BLOCK);
                        groupedIssues.add(caseBlockIssue);
                        this.defElementOfIssue.put(caseBlockIssue, caseBlock.getDeclaration());
                        continue;
                    }
                    groupedIssues.add(issue);
                    continue;
                }
                groupedIssues.add(issue);
            }
            result.put(path, new ArrayList(groupedIssues));
        }
        return result;
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        Map<ParserPath, List<SVTBIssues>> semiAfterMacroMap = this.fOVMProject.getSVTBIssuesWithKind(112);
        Map<ParserPath, List<SVTBIssues>> emptyStatementsMap = super.getSVTBIssues();
        Map<ParserPath, List<SVTBIssues>> result = super.getSVTBIssues();
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : emptyStatementsMap.entrySet()) {
            ParserPath path = entry.getKey();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this) || !semiAfterMacroMap.containsKey(path)) continue;
            List<SVTBIssues> emptyStatementIssues = entry.getValue();
            List<SVTBIssues> semiAfterMacroIssues = semiAfterMacroMap.get(path);
            for (SVTBIssues emptyStatementIssue : emptyStatementIssues) {
                for (SVTBIssues semiAfterMacroIssue : semiAfterMacroIssues) {
                    if (emptyStatementIssue.getOffset() != semiAfterMacroIssue.getOffset()) continue;
                    String info = semiAfterMacroIssue.getInfo();
                    emptyStatementIssue.setMessageForHit(MessageFormat.format(MACRO_FINISHING_IN_SEMI_MESSAGE, info));
                }
            }
            result.put(path, emptyStatementIssues);
        }
        return this.groupSVTBIssues(result);
    }

    @Override
    protected VerissimoAutofixAdditionalInfo getVerissimoAutofixAdditionalInfo(SVTBIssues issue) {
        RfDefElement defElement = this.defElementOfIssue.get(issue);
        return new VerissimoAutofixAdditionalInfo(issue, defElement);
    }
}

