/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.Check_SVTB_31_3_base;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="15.1.9")
@CheckID(value="SVTB.31.3.1")
@CheckName(value="SVTB.31.3.1")
@CheckLabel(labels={RuleLabel.DEAD_CODE, RuleLabel.CONDITIONAL, RuleLabel.IF})
@CheckTitle(value="Empty if/else")
@CheckDescription(value="Flags empty conditional if/else statements.\n\nExample:\n if(...); // flagged\n if(...) begin end // flagged, passes if allowEmptyBeginEnd\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_31_3_1
extends Check_SVTB_31_3_base {
    public Check_SVTB_31_3_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.trackStatements.add(IRfActionBlockElement.BlockQualifier.IF.name());
        this.trackStatements.add(IRfActionBlockElement.BlockQualifier.ELSE.name());
        this.trackStatements.add(IRfActionBlockElement.BlockQualifier.ELSIF.name());
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        if (issue != null && IRfActionBlockElement.BlockQualifier.IF.name().equals(issue.getInfo())) {
            return "Empty if statement!";
        }
        if (issue != null && IRfActionBlockElement.BlockQualifier.ELSE.name().equals(issue.getInfo())) {
            return "Empty else statement!";
        }
        return "Empty if/else statement!";
    }
}

