/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.parser.SVTBIssues;

public abstract class Check_SVTB_31_3_base
extends AbstractSVTBSimpleIssues
implements IWhitespaceParserCheck {
    protected Set<String> trackStatements = new HashSet<String>();
    @CheckParameter(defaultValue="false", description="Do not flag empty begin - end blocks.", name="allowEmptyBeginEnd", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowEmptyBeginEndValue;
    @CheckParameter(defaultValue="false", description="Do not flag begin - end blocks that contain only comments.", name="allowEmptyBeginEndWithComments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowEmptyBeginEndWithComments;
    @CheckParameter(defaultValue="false", description="Do not flag begin - end blocks that contain inactive code.", name="allowBeginEndWithInactiveCode", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowBeginEndWithInactiveCode;
    @CheckParameter(defaultValue="false", description="Do not flag empty statements inside macros.", name="allowEmptyStatementInsideMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowEmptyStatementInsideMacrosValue;

    public Check_SVTB_31_3_base(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(129);
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        HashMap<ParserPath, List<SVTBIssues>> resultMap = new HashMap<ParserPath, List<SVTBIssues>>();
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(129);
        if (allIssues == null || allIssues.isEmpty()) {
            return resultMap;
        }
        Set<ParserPath> allFilenamesWithIssues = allIssues.keySet();
        for (ParserPath eachFilenameWithIssues : allFilenamesWithIssues) {
            List<SVTBIssues> issues;
            RfFileDef filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(eachFilenameWithIssues);
            if (filedef == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(eachFilenameWithIssues, this) || (issues = allIssues.get(eachFilenameWithIssues)) == null || issues.isEmpty()) continue;
            issues.removeIf(issue -> "wait".equals(issue.getInfo()) && issue.getCarry() != 1 || issue.getAdditionalInfo() != null && "hasProceduralTimingControl".equals(issue.getAdditionalInfo()) || "isEventControl".equals(issue.getAdditionalInfo()) && !"ALWAYS".equals(issue.getInfo()));
            this.notifyCheckAlive();
            ArrayList<SVTBIssues> resultList = new ArrayList<SVTBIssues>();
            for (SVTBIssues issue2 : issues) {
                if (issue2 == null || this.trackStatements != null && !this.trackStatements.isEmpty() && !this.trackStatements.contains(issue2.getInfo()) || this.pAllowEmptyStatementInsideMacrosValue && issue2.getReparseInfo() != null) continue;
                if ((this.pAllowEmptyBeginEndValue || this.pAllowEmptyBeginEndWithComments || this.pAllowBeginEndWithInactiveCode) && issue2.getCarry() == 1) {
                    LiteralToken token;
                    if (issue2.getReparseInfo() != null || (token = this.getWSParser().getToken(issue2.getOffset(), eachFilenameWithIssues)) == null) continue;
                    LiteralToken adjToken = token;
                    boolean searchForValidToken = true;
                    boolean hasInactiveCode = false;
                    int ifdefDepth = 0;
                    while (searchForValidToken) {
                        adjToken = this.getWSParser().getPrevToken(adjToken, eachFilenameWithIssues);
                        if (adjToken == null) break;
                        if (adjToken.getZone() == SVTBWhitespaceParser.ZoneType.CODE) {
                            if (adjToken.getStringToken().contains("endif")) {
                                hasInactiveCode = true;
                                ++ifdefDepth;
                            } else if ((adjToken.getStringToken().contains("ifdef") || adjToken.getStringToken().contains("ifndef")) && --ifdefDepth < 0) {
                                ifdefDepth = 0;
                            }
                        }
                        if (ifdefDepth != 0) continue;
                        if (adjToken.getZone() == SVTBWhitespaceParser.ZoneType.SINGLE_COMMENT || adjToken.getZone() == SVTBWhitespaceParser.ZoneType.MULTILINE_COMMENT) {
                            searchForValidToken = false;
                        }
                        if (adjToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE || !adjToken.getStringToken().contains("begin")) continue;
                        searchForValidToken = false;
                    }
                    if (this.pAllowBeginEndWithInactiveCode && hasInactiveCode || this.pAllowEmptyBeginEndWithComments && adjToken != null && (adjToken.getZone() == SVTBWhitespaceParser.ZoneType.SINGLE_COMMENT || adjToken.getZone() == SVTBWhitespaceParser.ZoneType.MULTILINE_COMMENT) || this.pAllowEmptyBeginEndValue && adjToken != null && adjToken.getZone() == SVTBWhitespaceParser.ZoneType.CODE && adjToken.getStringToken().contains("begin")) continue;
                }
                RfDefElement defElement = this.fOVMProject.getRfProject().getFileDefUsingParserPath(eachFilenameWithIssues).getScope(issue2.getOffset(), true);
                RfNamedElement namedElement = defElement.getNamedElement();
                boolean skip = false;
                if (issue2.getInfo() != null && !issue2.getInfo().isEmpty() && namedElement != null) {
                    List<RfField> fields = namedElement.getLocalMembers(RfField.class);
                    if (fields != null && !fields.stream().filter(e -> !e.isForLoopParameter()).collect(Collectors.toList()).isEmpty()) {
                        skip = true;
                    } else {
                        RfHidHolder hidHolder = namedElement.getHidHolder();
                        if (hidHolder != null && !hidHolder.isHidObjectsEmpty()) {
                            for (Map.Entry entry : hidHolder.getHidObjectsMap().entrySet()) {
                                ParserPath entryPath = (ParserPath)entry.getKey();
                                if (eachFilenameWithIssues.equals((Object)entryPath) || ((ListContainer)entry.getValue()).isEmpty()) continue;
                                skip = true;
                                break;
                            }
                        }
                    }
                }
                if (skip) continue;
                resultList.add(issue2);
            }
            resultMap.put(eachFilenameWithIssues, resultList);
        }
        return resultMap;
    }
}

