/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="20.1.31")
@CheckID(value="SVTB.31.4")
@CheckName(value="SVTB.31.4")
@CheckLabel(labels={RuleLabel.DEAD_CODE, RuleLabel.CLASS, RuleLabel.FIELD, RuleLabel.METHOD, RuleLabel.ARGUMENT})
@CheckTitle(value="Class variables and members not read or written")
@CheckDescription(value="Flags class fields, function variables and arguments that are not read or written.\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_SVTB_31_4
extends OVMComplianceCheck {
    private static final Set<String> LIST_WRITE_METHODS = new HashSet<String>();
    private static final Set<String> LIST_READ_METHODS = new HashSet<String>();
    private static final Set<String> ASSOCIATIVE_ARRAY_WRITE_METHODS = new HashSet<String>();
    private static final Set<String> ASSOCIATIVE_ARRAY_READ_METHODS = new HashSet<String>();
    private static final Set<String> DYNAMIC_ARRAY_WRITE_METHODS = new HashSet<String>();
    private static final Set<String> DYNAMIC_ARRAY_READ_METHODS = new HashSet<String>();
    private static final Set<String> QUEUE_WRITE_METHODS = new HashSet<String>();
    private static final Set<String> QUEUE_READ_METHODS = new HashSet<String>();
    Map<String, Set<RfField>> readElements = new HashMap<String, Set<RfField>>(32768);
    Map<String, Set<RfField>> writtenElements = new HashMap<String, Set<RfField>>(32768);
    LinkedList<RfField> allfields = new LinkedList();
    Map<String, Set<RfField>> usedFields = new HashMap<String, Set<RfField>>(32768);
    boolean pCheckRead;
    boolean pCheckWrite;
    RfClass libAnalysisPortClass;
    @CheckParameter(defaultValue="read, write", description="Comma separated list of read, write.", name="checkAccessType", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pCheckAccessType;

    static {
        LIST_WRITE_METHODS.add("reverse");
        LIST_WRITE_METHODS.add("sort");
        LIST_WRITE_METHODS.add("rsort");
        LIST_WRITE_METHODS.add("shuffle");
        LIST_READ_METHODS.add("and");
        LIST_READ_METHODS.add("find");
        LIST_READ_METHODS.add("find_first");
        LIST_READ_METHODS.add("find_first_index");
        LIST_READ_METHODS.add("find_index");
        LIST_READ_METHODS.add("find_last");
        LIST_READ_METHODS.add("find_last_index");
        LIST_READ_METHODS.add("max");
        LIST_READ_METHODS.add("min");
        LIST_READ_METHODS.add("or");
        LIST_READ_METHODS.add("product");
        LIST_READ_METHODS.add("sum");
        LIST_READ_METHODS.add("unique");
        LIST_READ_METHODS.add("unique_index");
        LIST_READ_METHODS.add("xor");
        ASSOCIATIVE_ARRAY_WRITE_METHODS.addAll(LIST_WRITE_METHODS);
        ASSOCIATIVE_ARRAY_WRITE_METHODS.add("delete");
        ASSOCIATIVE_ARRAY_READ_METHODS.addAll(LIST_READ_METHODS);
        ASSOCIATIVE_ARRAY_READ_METHODS.add("empty");
        ASSOCIATIVE_ARRAY_READ_METHODS.add("exists");
        ASSOCIATIVE_ARRAY_READ_METHODS.add("first");
        ASSOCIATIVE_ARRAY_READ_METHODS.add("last");
        ASSOCIATIVE_ARRAY_READ_METHODS.add("next");
        ASSOCIATIVE_ARRAY_READ_METHODS.add("num");
        ASSOCIATIVE_ARRAY_READ_METHODS.add("prev");
        ASSOCIATIVE_ARRAY_READ_METHODS.add("size");
        DYNAMIC_ARRAY_WRITE_METHODS.addAll(LIST_WRITE_METHODS);
        DYNAMIC_ARRAY_WRITE_METHODS.add("delete");
        DYNAMIC_ARRAY_READ_METHODS.addAll(LIST_READ_METHODS);
        DYNAMIC_ARRAY_READ_METHODS.add("size");
        QUEUE_WRITE_METHODS.addAll(LIST_WRITE_METHODS);
        QUEUE_WRITE_METHODS.add("delete");
        QUEUE_WRITE_METHODS.add("insert");
        QUEUE_WRITE_METHODS.add("pop_back");
        QUEUE_WRITE_METHODS.add("pop_front");
        QUEUE_WRITE_METHODS.add("push_back");
        QUEUE_WRITE_METHODS.add("push_front");
        QUEUE_READ_METHODS.addAll(LIST_READ_METHODS);
        QUEUE_READ_METHODS.add("empty");
        QUEUE_READ_METHODS.add("size");
        QUEUE_READ_METHODS.add("pick");
        QUEUE_READ_METHODS.add("pop_back");
        QUEUE_READ_METHODS.add("pop_front");
    }

    public Check_SVTB_31_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String libAnalysisPortName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_analysis_port");
        this.libAnalysisPortClass = this.fOVMProject.getRfProject().getClass(libAnalysisPortName, false);
        RfProject rfProject = this.fOVMProject.getRfProject();
        RfClass[] allClasses = rfProject.getAllClasses();
        this.pCheckRead = this.pCheckAccessType.contains("read");
        this.pCheckWrite = this.pCheckAccessType.contains("write");
        RfClass[] rfClassArray = allClasses;
        int n = allClasses.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass rfClass = rfClassArray[n2];
            if (!this.fOVMProject.isOVMElement(rfClass)) {
                this.notifyCheckAlive();
                RfFileDef fileDef = rfClass.getFile();
                if (fileDef == null || !this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this)) {
                    List<RfField> parameters;
                    rfClass.visitHidObject(null, new ClassHidVisitor());
                    List<RfField> allFields = rfClass.getFields();
                    if (allFields != null && !allFields.isEmpty()) {
                        for (RfField rfField : allFields) {
                            this.removeIfUsed(rfField);
                        }
                        this.allfields.addAll(allFields);
                    }
                    if ((parameters = rfClass.getParametersWithPrefix("", 128, 2, 1)) != null && !parameters.isEmpty()) {
                        for (RfField rfField : parameters) {
                            if (rfField.isTypeParameter()) continue;
                            this.removeIfUsed(rfField);
                        }
                        this.allfields.addAll(parameters);
                    }
                    List<RfFunction> allFunctions = rfClass.getLocalFunctions();
                    for (RfFunction rfFunction : allFunctions) {
                        if (rfFunction.isPredefined()) continue;
                        List<RfField> functionArguments = rfFunction.getArgumentsWithPrefix("", 2);
                        List<RfField> functionFields = rfFunction.getFields();
                        if (functionArguments != null && !functionArguments.isEmpty()) {
                            boolean isOverriden = false;
                            RfFunction topFunction = LintUtils.getTopFunction(rfFunction);
                            if (topFunction != rfFunction) {
                                isOverriden = true;
                            }
                            for (RfField rfField : functionArguments) {
                                if (isOverriden) {
                                    this.addReadField(rfField);
                                }
                                this.removeIfUsed(rfField);
                            }
                            this.allfields.addAll(functionArguments);
                        }
                        if (functionFields == null || functionFields.isEmpty()) continue;
                        for (RfField rfField : functionFields) {
                            this.removeIfUsed(rfField);
                        }
                        this.allfields.addAll(functionFields);
                    }
                    List<RfFunction> allTasks = rfClass.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC);
                    for (RfFunction rfFunction : allTasks) {
                        List<RfField> functionArguments = rfFunction.getArgumentsWithPrefix("", 2);
                        List<RfField> functionFields = rfFunction.getFields();
                        if (functionArguments != null && !functionArguments.isEmpty()) {
                            boolean isOverriden = false;
                            RfFunction topFunction = LintUtils.getTopFunction(rfFunction);
                            if (topFunction != rfFunction) {
                                isOverriden = true;
                            }
                            for (RfField rfField : functionArguments) {
                                if (isOverriden) {
                                    this.addReadField(rfField);
                                }
                                this.removeIfUsed(rfField);
                            }
                            this.allfields.addAll(functionArguments);
                        }
                        if (functionFields == null || functionFields.isEmpty()) continue;
                        for (RfField rfField : functionFields) {
                            this.removeIfUsed(rfField);
                        }
                        this.allfields.addAll(functionFields);
                    }
                }
            }
            ++n2;
        }
        for (RfField rfField : this.allfields) {
            if (rfField.isFromEmbeddedCovergroupDef()) continue;
            Set<RfField> localUsedFields = this.usedFields.get(rfField.getFullName());
            if (localUsedFields == null || !localUsedFields.contains(rfField)) {
                this.checkField(rfField);
                continue;
            }
            localUsedFields.remove(rfField);
        }
        this.readElements.clear();
        this.writtenElements.clear();
        this.allfields.clear();
        this.usedFields.clear();
    }

    public void removeIfUsed(RfField rfField) {
        Set<RfField> localReadElements = this.readElements.get(rfField.getFullName());
        Set<RfField> localWrittenElements = this.writtenElements.get(rfField.getFullName());
        if (localReadElements == null || localWrittenElements == null) {
            return;
        }
        if (localReadElements.contains(rfField) && localWrittenElements.contains(rfField)) {
            this.writtenElements.get(rfField.getFullName()).remove(rfField);
            this.readElements.get(rfField.getFullName()).remove(rfField);
            Set<RfField> localUsedFields = this.usedFields.get(rfField.getFullName());
            if (localUsedFields == null) {
                localUsedFields = new HashSet<RfField>();
                localUsedFields.add(rfField);
                this.usedFields.put(rfField.getFullName(), localUsedFields);
            } else {
                localUsedFields.add(rfField);
            }
        }
    }

    private void checkField(RfField rfField) {
        Set<RfField> localWrittenElements;
        Set<RfField> localReadElements;
        boolean isRead = false;
        boolean isWritten = false;
        if (rfField.getInitialValue(false) != null) {
            isWritten = true;
        }
        if ((localReadElements = this.readElements.get(rfField.getFullName())) != null && localReadElements.contains(rfField) || this.isWrittenOnly(rfField)) {
            isRead = true;
            if (localReadElements != null) {
                localReadElements.remove(rfField);
            }
        }
        if ((localWrittenElements = this.writtenElements.get(rfField.getFullName())) != null && localWrittenElements.contains(rfField) || this.isReadOnly(rfField)) {
            isWritten = true;
            if (localWrittenElements != null) {
                localWrittenElements.remove(rfField);
            }
        }
        String elementKind = DVTStringUtil.capitalizeFirstLetter((String)LintUtils.getElementKind(rfField));
        if (this.pCheckRead && this.pCheckWrite && !isRead && !isWritten) {
            this.addHit(rfField, String.valueOf(elementKind) + " '" + rfField.getFullName() + "' is never read or written!");
            return;
        }
        if (this.pCheckRead && !isRead) {
            this.addHit(rfField, String.valueOf(elementKind) + " '" + rfField.getFullName() + "' is never read!");
            return;
        }
        if (this.pCheckWrite && !isWritten) {
            this.addHit(rfField, String.valueOf(elementKind) + " '" + rfField.getFullName() + "' is never written!");
        }
    }

    private boolean isWrittenOnly(RfField argument) {
        return argument.isOutput() || argument.isRef() && !argument.isConstRef();
    }

    private boolean isReadOnly(RfField argument) {
        return argument.isInput() || argument.isConstRef() || argument.isRef() || argument.isParameter();
    }

    private void addReadField(RfField rfField) {
        if (!this.pCheckRead) {
            return;
        }
        if (rfField instanceof RfResultImplicitVariable || rfField.isPredefined()) {
            return;
        }
        RfNamedElement enclosingScope = rfField.getEnclosingScope();
        if (enclosingScope instanceof RfClass || enclosingScope instanceof RfFunction) {
            Set<RfField> localReadElements = this.readElements.get(rfField.getFullName());
            if (localReadElements == null) {
                localReadElements = new HashSet<RfField>();
                localReadElements.add(rfField);
                this.readElements.put(rfField.getFullName(), localReadElements);
            } else {
                localReadElements.add(rfField);
            }
        }
    }

    private void addWrittenField(RfField rfField) {
        if (!this.pCheckWrite) {
            return;
        }
        if (rfField instanceof RfResultImplicitVariable || rfField.isPredefined()) {
            return;
        }
        RfNamedElement enclosingScope = rfField.getEnclosingScope();
        if (enclosingScope instanceof RfClass || enclosingScope instanceof RfFunction) {
            Set<RfField> localWrittenElements = this.writtenElements.get(rfField.getFullName());
            if (localWrittenElements == null) {
                localWrittenElements = new HashSet<RfField>();
                localWrittenElements.add(rfField);
                this.writtenElements.put(rfField.getFullName(), localWrittenElements);
            } else {
                localWrittenElements.add(rfField);
            }
        }
    }

    class ClassHidVisitor
    implements IHidVisitor<IHidObject> {
        ClassHidVisitor() {
        }

        public boolean visit(IHidObject hidObject) {
            if (hidObject instanceof RfHid) {
                this.handleHid((RfHid)hidObject);
            } else if (hidObject instanceof RfHidOperator) {
                this.handleOperator((RfHidOperator)hidObject);
            } else if (hidObject instanceof RfHidAccess && ((RfHidAccess)hidObject).isSelect()) {
                this.handleSelect((RfHidAccess)hidObject);
            }
            return true;
        }

        private void handleHid(RfHid hidObject) {
            if (!hidObject.isMethodCall(false)) {
                if (hidObject.getElement() instanceof RfField) {
                    RfField field = (RfField)hidObject.getElement();
                    if (field.isRand() || field.isRandc()) {
                        Check_SVTB_31_4.this.addWrittenField(field);
                        this.handleAccess(hidObject, false, false, true);
                        return;
                    }
                    RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
                    if (fieldType != null && Check_SVTB_31_4.this.libAnalysisPortClass != null && LintUtils.isSubClassOf(fieldType, Check_SVTB_31_4.this.libAnalysisPortClass)) {
                        Check_SVTB_31_4.this.addReadField(field);
                        this.handleAccess(hidObject, false, false, false);
                        return;
                    }
                }
                return;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return;
            }
            for (MethodCall methodCall : methodCalls) {
                this.handleMethodCall(methodCall);
            }
            this.handleAccess(hidObject, true, false, false);
        }

        private void handleAccess(RfHid hidObject, boolean isMethodCall, boolean isAssignment, boolean isWrite) {
            HidAccess parentAccess = hidObject.getParentAccess();
            if (!(parentAccess instanceof RfHidAccess)) {
                return;
            }
            RfHidAccess hidAccess = (RfHidAccess)parentAccess;
            IRfNamedElement asocType = hidAccess.getAssociatedType();
            Hid parentHid = hidAccess.getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return;
            }
            IRfNamedElement hidElement = parentHid.getElement();
            String hidName = hidObject.getName();
            while (hidElement instanceof RfField) {
                if (isAssignment) {
                    Check_SVTB_31_4.this.addWrittenField((RfField)hidElement);
                } else if (asocType instanceof RfClass) {
                    if (!isWrite) {
                        Check_SVTB_31_4.this.addReadField((RfField)hidElement);
                    } else {
                        Check_SVTB_31_4.this.addWrittenField((RfField)hidElement);
                    }
                } else if (asocType instanceof RfListType && isMethodCall) {
                    if (((RfListType)asocType).isAssociativeArray()) {
                        this.handleAssociativeArrayCall((RfField)hidElement, hidName);
                    } else if (((RfListType)asocType).isDynamicArray()) {
                        this.handleDynamicArrayCall((RfField)hidElement, hidName);
                    } else if (((RfListType)asocType).isQueue()) {
                        this.handleQueueCall((RfField)hidElement, hidName);
                    } else {
                        this.handleListCall((RfField)hidElement, hidName);
                    }
                }
                parentAccess = parentHid.getParentAccess();
                if (!(parentAccess instanceof RfHidAccess)) {
                    return;
                }
                hidAccess = (RfHidAccess)parentAccess;
                parentHid = hidAccess.getParentHid();
                if (!(parentHid instanceof RfHid)) {
                    return;
                }
                hidElement = parentHid.getElement();
            }
        }

        private void handleMethodCall(MethodCall methodCall) {
            if (methodCall.argumentValuesMap == null || methodCall.argumentValuesMap.isEmpty()) {
                return;
            }
            Set entrySet = methodCall.argumentValuesMap.entrySet();
            if (entrySet == null || entrySet.isEmpty()) {
                return;
            }
            for (Map.Entry argumentValue : entrySet) {
                IRfNamedElement key = (IRfNamedElement)argumentValue.getKey();
                if (!(key instanceof RfField)) continue;
                RfField argument = (RfField)key;
                Set values = (Set)argumentValue.getValue();
                if (values == null || values.isEmpty()) continue;
                boolean isReadOnly = Check_SVTB_31_4.this.isReadOnly(argument) || argument.isInout();
                boolean isWriteOnly = Check_SVTB_31_4.this.isWrittenOnly(argument) || argument.isInout();
                for (IHid value : values) {
                    if (!(value instanceof RfHid) || !(value.getElement() instanceof RfField)) continue;
                    IRfNamedElement element = value.getElement();
                    if (isReadOnly) {
                        Check_SVTB_31_4.this.addReadField((RfField)element);
                        this.handleAccess((RfHid)value, false, false, false);
                    }
                    if (!isWriteOnly && (!methodCall.getMethodName().equals("$cast") || !key.getName().equals("dest_var"))) continue;
                    Check_SVTB_31_4.this.addWrittenField((RfField)element);
                    this.handleAccess((RfHid)value, false, false, true);
                }
            }
        }

        private void handleAssociativeArrayCall(RfField field, String hidName) {
            if (ASSOCIATIVE_ARRAY_READ_METHODS.contains(hidName)) {
                Check_SVTB_31_4.this.addReadField(field);
            }
            if (ASSOCIATIVE_ARRAY_WRITE_METHODS.contains(hidName)) {
                Check_SVTB_31_4.this.addWrittenField(field);
            }
        }

        private void handleDynamicArrayCall(RfField field, String hidName) {
            if (DYNAMIC_ARRAY_READ_METHODS.contains(hidName)) {
                Check_SVTB_31_4.this.addReadField(field);
            }
            if (DYNAMIC_ARRAY_WRITE_METHODS.contains(hidName)) {
                Check_SVTB_31_4.this.addWrittenField(field);
            }
        }

        private void handleQueueCall(RfField field, String hidName) {
            if (QUEUE_READ_METHODS.contains(hidName)) {
                Check_SVTB_31_4.this.addReadField(field);
            }
            if (QUEUE_WRITE_METHODS.contains(hidName)) {
                Check_SVTB_31_4.this.addWrittenField(field);
            }
        }

        private void handleListCall(RfField field, String hidName) {
            if (LIST_READ_METHODS.contains(hidName)) {
                Check_SVTB_31_4.this.addReadField(field);
            }
            if (LIST_WRITE_METHODS.contains(hidName)) {
                Check_SVTB_31_4.this.addWrittenField(field);
            }
        }

        private void handleOperator(RfHidOperator hidObject) {
            ListContainer rhValues;
            IRfNamedElement element;
            if (hidObject.isAssociation()) {
                return;
            }
            IHidObject lhValue = hidObject.getLHValue();
            if (lhValue == null) {
                return;
            }
            ISDataAbstract operatorResolvedType = hidObject.getOperatorResolvedType();
            if (hidObject.isAssignment() && operatorResolvedType instanceof SDataVariable) {
                this.addWrittenVariable((SDataVariable)operatorResolvedType);
            }
            if (!hidObject.isAssignment()) {
                IHidObject select;
                List selects;
                if (lhValue instanceof RfHid) {
                    IRfNamedElement element2 = ((RfHid)lhValue).getElement();
                    if (element2 instanceof RfField) {
                        Check_SVTB_31_4.this.addReadField((RfField)element2);
                        this.handleAccess((RfHid)lhValue, false, false, false);
                        if (hidObject.isIncrementOrDecrement()) {
                            Check_SVTB_31_4.this.addWrittenField((RfField)element2);
                            this.handleAccess((RfHid)lhValue, false, false, true);
                        }
                    }
                } else if (lhValue instanceof RfHidAccess && ((RfHidAccess)lhValue).isSelect() && (selects = ((RfHidAccess)lhValue).getSelects()) != null && !selects.isEmpty() && (select = (IHidObject)selects.get(0)) instanceof RfHid && ((RfHid)select).getElement() instanceof RfField) {
                    Check_SVTB_31_4.this.addReadField((RfField)((RfHid)select).getElement());
                    this.handleAccess((RfHid)select, false, false, false);
                }
            }
            Hid parent = null;
            if (lhValue instanceof RfHidAccess) {
                RfHidAccess rfHidAccess = (RfHidAccess)lhValue;
                parent = rfHidAccess.getParentHid();
            } else if (lhValue instanceof RfHid) {
                parent = ((RfHid)lhValue).getParentHid();
            }
            if (parent instanceof RfHid && (element = parent.getElement()) instanceof RfField) {
                if (hidObject.isAssignment()) {
                    Check_SVTB_31_4.this.addWrittenField((RfField)element);
                    this.handleAccess((RfHid)parent, false, true, true);
                } else {
                    Check_SVTB_31_4.this.addReadField((RfField)element);
                    this.handleAccess((RfHid)parent, false, false, false);
                }
            }
            if ((rhValues = hidObject.getRHValues()) == null || rhValues.isEmpty()) {
                return;
            }
            for (IHidObject rhValue : rhValues) {
                if (rhValue instanceof RfHidAccess) {
                    rhValue = ((RfHidAccess)rhValue).getParentHid();
                }
                if (!(rhValue instanceof RfHid)) continue;
                IRfNamedElement element3 = ((RfHid)rhValue).getElement();
                if (element3 == null || element3.isPredefined()) {
                    return;
                }
                if (!(element3 instanceof RfField)) continue;
                Check_SVTB_31_4.this.addReadField((RfField)element3);
                this.handleAccess((RfHid)rhValue, false, false, false);
            }
        }

        private void addWrittenVariable(SDataVariable sDataNamedVariable) {
            IRfNamedElement variable = sDataNamedVariable.getVariable();
            if (variable instanceof RfField) {
                Check_SVTB_31_4.this.addWrittenField((RfField)variable);
            }
        }

        private void handleSelect(RfHidAccess hidObject) {
            List selects = hidObject.getSelects();
            if (selects == null || selects.isEmpty()) {
                return;
            }
            IHidObject select = (IHidObject)selects.get(0);
            if (!(select instanceof RfHid)) {
                return;
            }
            RfHid rfHid = (RfHid)select;
            if (!(rfHid.getElement() instanceof RfField)) {
                return;
            }
            Check_SVTB_31_4.this.addReadField((RfField)rfHid.getElement());
            this.handleAccess(rfHid, false, false, false);
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

