/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="20.1.42")
@CheckID(value="SVTB.31.5")
@CheckName(value="SVTB.31.5")
@CheckLabel(labels={RuleLabel.DEAD_CODE, RuleLabel.CONDITIONAL})
@CheckTitle(value="Do not use useless if/assert blocks")
@CheckDescription(value="If and assert blocks should not have conditions that always yield true or false.\n\nExamples:\nif (1) // NOT ALLOWED\nassert (0) // NOT ALLOWED\nassert (var) // ALLOWED\n\nCheck supports pre-waiving.")
public class Check_SVTB_31_5
extends OVMComplianceCheck {
    public Check_SVTB_31_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        IRfNamedElementVisitor namedElementVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (!(namedElement instanceof RfActionBlock) && !(namedElement instanceof RfAssertExpect)) {
                    return true;
                }
                if (Check_SVTB_31_5.this.checkPreWaivers(namedElement)) {
                    return true;
                }
                Check_SVTB_31_5.this.notifyCheckAlive();
                if (namedElement instanceof RfActionBlock) {
                    RfActionBlock actionBlock = (RfActionBlock)namedElement;
                    if (!actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.IF)) {
                        return true;
                    }
                    IHidObject conditionalBlockExpression = actionBlock.getConditionalBlockExpression();
                    if (conditionalBlockExpression == null) {
                        return true;
                    }
                    String condition = conditionalBlockExpression.toString();
                    Check_SVTB_31_5.this.addHitForCondition(namedElement, condition, "if");
                } else {
                    RfAssertExpect assertExpect = (RfAssertExpect)namedElement;
                    IHidObject assertBlockExpression = assertExpect.getExpression();
                    if (assertBlockExpression == null) {
                        return true;
                    }
                    String condition = assertBlockExpression.toString();
                    Check_SVTB_31_5.this.addHitForCondition(namedElement, condition, LintUtils.getElementKind(namedElement));
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().accept(namedElementVisitor);
    }

    private void addHitForCondition(RfNamedElement namedElement, String condition, String blockType) {
        if (!LintUtils.isIntegralNumber(condition)) {
            return;
        }
        Number number = DVTStringUtil.parseNumberVLOG((String)condition, null, (boolean)false);
        if (number != null) {
            if (number.longValue() == 0L) {
                this.addHit(namedElement, "Useless " + blockType + " block. Condition is always false!");
            } else if (number.longValue() > 0L) {
                this.addHit(namedElement, "Useless " + blockType + " block. Condition is always true!");
            }
        }
    }

    public boolean checkPreWaivers(RfNamedElement namedElement) {
        if (namedElement.getFile() == null) {
            return true;
        }
        ParserPath parserPath = namedElement.getFile().getParserPath();
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

