/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="20.1.44")
@CheckID(value="SVTB.31.6")
@CheckName(value="SVTB.31.6")
@CheckLabel(labels={RuleLabel.DEAD_CODE, RuleLabel.FIELD, RuleLabel.COMPARISON})
@CheckTitle(value="Do not compare a variable to itself")
@CheckDescription(value="This rule flags comparisons that have the same variable on both sides.\n\nExamples:\n\nif (x >= x) // not allowed\n\t$display(\"false\");\nif (x >= 5) // allowed\n\t$display(\"true\");\n\nCheck supports pre-waiving.")
public class Check_SVTB_31_6
extends OVMComplianceCheck {
    private static final Set<Integer> OPERATOR_TYPE_TOKENS = new HashSet<Integer>(Arrays.asList(482, 483, 484, 485, 502, 504, 486, 487, 488, 489));

    public Check_SVTB_31_6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new OperatorVisior());
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class OperatorVisior
    implements IHidVisitor<RfHidOperator> {
        ParserPath parserPath;

        private OperatorVisior() {
        }

        public boolean visit(RfHidOperator hidObject) {
            if (Check_SVTB_31_6.this.checkPrewaivers(this.parserPath)) {
                return true;
            }
            Check_SVTB_31_6.this.notifyCheckAlive();
            if (hidObject.getOperatorKind() == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR && OPERATOR_TYPE_TOKENS.contains(hidObject.getOperatorType())) {
                if (hidObject.isAssignment()) {
                    return true;
                }
                IHidObject lhValue = hidObject.getLHValue();
                ListContainer rhValues = hidObject.getRHValues();
                if (!(lhValue instanceof RfHid)) {
                    return true;
                }
                if (rhValues == null || rhValues.size() != 1) {
                    return true;
                }
                IHidObject rhValue = (IHidObject)rhValues.get(0);
                if (lhValue.equals(rhValue)) {
                    Check_SVTB_31_6.this.addHit(this.parserPath, (HidOccurrence)hidObject.getOccurrence(), "Variable '" + ((RfHid)lhValue).getName() + "' is compared with itself!");
                }
            }
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

