/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.1")
@CheckID(value="SVTB.31.7")
@CheckName(value="SVTB.31.7")
@CheckLabel(labels={RuleLabel.DEAD_CODE, RuleLabel.PREDEFINED_METHOD, RuleLabel.ARGUMENT, RuleLabel.RANGE})
@CheckTitle(value="Do not call substr() with argument values outside of the expected bounds")
@CheckDescription(value="Calling str.substr(i, j) with i < 0, j < 0, j < i, i >= str.len() or j >= str.len() will return the empty string.\n\nExamples:\n\nstring my_string = \"abcdefghi\";\n\nmy_string = my_string.substr(0, 2);  // allowed\nmy_string = my_string.substr(-1, 2);  // not allowed\nmy_string = my_string.substr(3, 1);  // not allowed\n\nCheck supports pre-waiving.")
public class Check_SVTB_31_7
extends OVMComplianceCheck {
    public Check_SVTB_31_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfHidVisitor callVisitor = new RfHidVisitor(){

            public boolean visit(RfHid rfHid) {
                if (Check_SVTB_31_7.this.checkPrewaivers(this.parserPath)) {
                    return true;
                }
                Check_SVTB_31_7.this.notifyCheckAlive();
                if (!rfHid.isMethodCall(false)) {
                    return true;
                }
                if (!rfHid.getName().equals("substr")) {
                    return true;
                }
                HidAccess parentAccess = rfHid.getParentAccess();
                if (parentAccess == null || parentAccess.getAccessKind() != 0) {
                    return true;
                }
                RfNamedElement associatedType = (RfNamedElement)parentAccess.getAssociatedType();
                if (associatedType == null || !associatedType.getName().equals("string")) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return true;
                }
                for (MethodCall methodCall : methodCalls) {
                    if (methodCall.argumentValuesMapRaw == null) continue;
                    IHidObject firstArgumentValue = null;
                    IHidObject secondArgumentValue = null;
                    for (Map.Entry argument : methodCall.argumentValuesMapRaw.entrySet()) {
                        IHidObject argumentValue = (IHidObject)argument.getValue();
                        if (argumentValue == null) {
                            return true;
                        }
                        if (((IRfFieldElement)argument.getKey()).getName().equals("i")) {
                            firstArgumentValue = argumentValue;
                            continue;
                        }
                        if (!((IRfFieldElement)argument.getKey()).getName().equals("j")) continue;
                        secondArgumentValue = argumentValue;
                    }
                    long firstArgumentLongValue = Check_SVTB_31_7.this.checkMethodArguments(this.parserPath, rfHid, firstArgumentValue);
                    long secondArgumentLongValue = Check_SVTB_31_7.this.checkMethodArguments(this.parserPath, rfHid, secondArgumentValue);
                    if (firstArgumentLongValue == Long.MAX_VALUE || secondArgumentLongValue == Long.MAX_VALUE || secondArgumentLongValue >= firstArgumentLongValue) continue;
                    Check_SVTB_31_7.this.addHit(this.parserPath, rfHid, "Second argument value " + secondArgumentLongValue + " is lower than first argument value " + firstArgumentLongValue + " for the substr() method called on '" + parentAccess.getParentHid().getName() + "' variable!");
                    return true;
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(null, callVisitor);
    }

    private long checkMethodArguments(ParserPath parserPath, RfHid rfHid, IHidObject firstArgumentValue) {
        RfHid firstArgumentParentHid;
        HidAccess parentAccess = rfHid.getParentAccess();
        Number argumentNumber = null;
        long argumentLongValue = Long.MAX_VALUE;
        if (firstArgumentValue instanceof RfHidImplicit) {
            argumentNumber = DVTStringUtil.parseNumberVLOG((String)((RfHidImplicit)firstArgumentValue).getName(), null, (boolean)false);
            if (argumentNumber != null) {
                argumentLongValue = argumentNumber.longValue();
            }
        } else if (firstArgumentValue instanceof RfHidOperator && (((RfHidOperator)firstArgumentValue).getLHValue() instanceof RfHidImplicit && ((RfHidOperator)firstArgumentValue).getRHValues() == null || ((RfHidOperator)firstArgumentValue).getRHValues().isEmpty())) {
            argumentNumber = DVTStringUtil.parseNumberVLOG((String)((RfHidOperator)firstArgumentValue).getLHValue().toString(), null, (boolean)false);
            if (argumentNumber != null && ((RfHidOperator)firstArgumentValue).getOperatorText().equals("-")) {
                argumentLongValue = -1L * argumentNumber.longValue();
            } else if (argumentNumber != null && ((RfHidOperator)firstArgumentValue).getOperatorText().equals("+")) {
                argumentLongValue = argumentNumber.longValue();
            }
        }
        if (argumentNumber != null && argumentLongValue < 0L) {
            this.addHit(parserPath, rfHid, "Argument " + argumentLongValue + " of substr() method called on '" + parentAccess.getParentHid().getName() + "' variable is outside of expected bounds!");
            return Long.MAX_VALUE;
        }
        if (firstArgumentValue instanceof RfHidAccessArgs && ((RfHidAccessArgs)firstArgumentValue).getParentHid() instanceof RfHid && (firstArgumentParentHid = (RfHid)((RfHidAccessArgs)firstArgumentValue).getParentHid()).getName().equals("len") && firstArgumentParentHid.getParentHid() instanceof RfHid && firstArgumentParentHid.getParentHid().equals((Object)parentAccess.getParentHid())) {
            this.addHit(parserPath, rfHid, "Argument " + HidUtils.toNiceString((IHidObject)firstArgumentParentHid) + " of substr() method called on '" + parentAccess.getParentHid().getName() + "' variable is outside of expected bounds!");
            return Long.MAX_VALUE;
        }
        return argumentLongValue;
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

