/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractArgumentTypePerformanceCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="3.5.19")
@CheckID(value="SVTB.32.1.0")
@CheckName(value="SVTB.32.1.0")
@CheckLabel(labels={RuleLabel.PERFORMANCE, RuleLabel.ARRAY, RuleLabel.ARGUMENT, RuleLabel.METHOD})
@CheckTitle(value="Pass arrays by reference unless otherwise needed")
@CheckDescription(value="Pass arrays by reference to avoid useless copies. When the arguments are large, it can be undesirable to copy the arguments.\n\nFrom the SystemVerilog standard chapter 'Arrays as arguments to subroutines':\nWhen an array argument is passed by value, a copy of the array is passed to the called subroutine. This is true for all array types: fixed-size, dynamic, queue, or associative.\n\nFor example, calling the following function copies 1000 bytes each time the call is made:\nfunction automatic int crc( byte packet [1000:1] );\n for( int j= 1; j <= 1000; j++ ) begin\n  crc ^= packet[j];\n end\nendfunction\n\nFYR, an argument has one of the following directions:\n- input // copy value in at beginning\n- output // copy value out at end\n- inout // copy in at beginning and out at end\n- [const] ref // pass reference")
public class Check_SVTB_32_1_0
extends AbstractArgumentTypePerformanceCheck {
    private static final List<String> LIST_MODIFIERS = Arrays.asList("delete", "reverse", "shuffle", "sort", "rsort", "insert", "push_back", "push_front", "pop_back", "pop_front");
    @CheckParameter(defaultValue="false", description="Do not flag array of class type arguments.", name="skipArraysOfClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipArraysOfClassesValue;
    @CheckParameter(defaultValue="false", description="Do not flag array if it is modified inside of function.", name="skipArrayIfModified", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipArrayIfMOdifiedValue;
    @CheckParameter(defaultValue="false", description="Do not flag array if it is assigned to a non local variable.", name="skipArrayIfAssignedToNonLocalVariable", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipArrayIfAssignedToNonLocalVariableValue;

    public Check_SVTB_32_1_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    void checkArgument(RfFunction function, RfField argument) {
        String assocTypeName;
        String[] assocTypeNameParts;
        RfNamedElement aft;
        if (argument.isRef()) {
            return;
        }
        RfCovergroup enclosingCovergroup = argument.getEnclosingScope(RfCovergroup.class);
        if (enclosingCovergroup != null && function.getName().equals("sample")) {
            return;
        }
        IRfNamedElement argumentType = argument.getAssociatedType(RfTypesResolver.create((IRfScopeElement)function, function.getRfProject(), 10));
        if (argumentType instanceof RfTypeAlias) {
            argumentType = ((RfTypeAlias)argumentType).getTranslatedType();
        }
        if (!(argumentType instanceof RfListType)) {
            return;
        }
        String unpackedDimension = ((RfListType)argumentType).getUnpackedDimension();
        if (unpackedDimension == null || unpackedDimension.isEmpty()) {
            return;
        }
        if (this.pSkipArraysOfClassesValue && (aft = LintUtils.getAssociatedFinalType(argument)) instanceof RfClass) {
            return;
        }
        if (this.pSkipArrayIfMOdifiedValue || this.pSkipArrayIfAssignedToNonLocalVariableValue) {
            CheckIfModifiedOrAssigned visitor = new CheckIfModifiedOrAssigned(function, argument);
            function.visitHidObject(null, visitor);
            if (this.pSkipArrayIfMOdifiedValue && visitor.isModified) {
                return;
            }
            if (this.pSkipArrayIfAssignedToNonLocalVariableValue && visitor.isAssignedToNonLocal) {
                return;
            }
        }
        if ((assocTypeNameParts = RfListType.splitUnpackedDimesnions(assocTypeName = argument.getAssociatedTypeName(function, 2))) != null && assocTypeNameParts.length > 0) {
            this.addHit(argument, String.valueOf(argument.getDirectionString()) + " argument '" + assocTypeNameParts[0] + " " + argument.getName() + (assocTypeNameParts.length > 1 ? assocTypeNameParts[1] : "") + "' of " + function.getFullName() + "() should be passed by reference!");
        }
    }

    class CheckIfModifiedOrAssigned
    implements IHidVisitor<IHidObject> {
        protected IHidHolder holder;
        protected ParserPath parserPath;
        protected RfField argument;
        protected RfFunction function;
        protected boolean isModified;
        protected boolean isAssignedToNonLocal;

        public CheckIfModifiedOrAssigned(RfFunction function, RfField argument) {
            this.function = function;
            this.argument = argument;
        }

        public boolean visit(IHidObject hidObject) {
            switch (hidObject.getHidKind()) {
                case OPERATOR: {
                    ListContainer rhValues;
                    RfHidOperator hidOperator = (RfHidOperator)hidObject;
                    if (!hidOperator.isAssignment()) {
                        return true;
                    }
                    IHidObject lhValue = hidOperator.getLHValue();
                    if (lhValue == null) {
                        return true;
                    }
                    if (lhValue instanceof RfHid) {
                        if (((RfHid)lhValue).getElement() != null && ((RfHid)lhValue).getElement().equals(this.argument)) {
                            this.isModified = true;
                            return false;
                        }
                    } else if (lhValue instanceof RfHidAccess) {
                        RfHidAccess hidAccess = (RfHidAccess)lhValue;
                        Hid parentAccess = hidAccess.getParentHid();
                        if (parentAccess != null) {
                            parentAccess = parentAccess.getAncestorHid();
                        }
                        if (parentAccess != null && parentAccess.getElement() != null && parentAccess.getElement().equals(this.argument)) {
                            this.isModified = true;
                            return false;
                        }
                    }
                    if ((rhValues = hidOperator.getRHValues()) == null || rhValues.isEmpty()) {
                        return true;
                    }
                    boolean containsOurArray = false;
                    for (IHidObject rhValue : rhValues) {
                        if (!(rhValue instanceof RfHid) || ((RfHid)rhValue).getElement() == null || !((RfHid)rhValue).getElement().equals(this.argument)) continue;
                        containsOurArray = true;
                        break;
                    }
                    if (lhValue instanceof RfHid && containsOurArray) {
                        RfHid leftList = (RfHid)lhValue;
                        IRfNamedElement element = leftList.getElement();
                        if (element == null) {
                            return true;
                        }
                        RfNamedElement namedElement = (RfNamedElement)element;
                        RfFunction enclosingScope = namedElement.getEnclosingScope(RfFunction.class);
                        if (enclosingScope != this.function) {
                            this.isAssignedToNonLocal = true;
                            return false;
                        }
                    }
                    return true;
                }
                case HID: {
                    RfHid hid = (RfHid)hidObject;
                    if (!hid.isMethodCall(false)) {
                        return true;
                    }
                    IRfNamedElement namedElement = hid.getElement();
                    if (!(namedElement instanceof RfPredefinedFunction)) {
                        return true;
                    }
                    Hid parentAccess = hid.getParentHid();
                    if (parentAccess != null) {
                        parentAccess = parentAccess.getAncestorHid();
                    }
                    if (parentAccess == null) {
                        return true;
                    }
                    if (parentAccess.getElement() == null) {
                        return true;
                    }
                    if (parentAccess.getElement().equals(this.argument) && LIST_MODIFIERS.contains(namedElement.getName())) {
                        this.isModified = true;
                        return false;
                    }
                    return true;
                }
            }
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.holder = holder;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

