/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;

@CheckVersion(value="20.1.4")
@CheckID(value="SVTB.32.1.1")
@CheckName(value="SVTB.32.1.1")
@CheckLabel(labels={RuleLabel.PERFORMANCE, RuleLabel.ARRAY, RuleLabel.ARGUMENT, RuleLabel.METHOD})
@CheckTitle(value="Pass arrays by reference instead of having arrays as method return type")
@CheckDescription(value="This rule flags arrays which are method return types, because those arrays would be returned by value.\nReturning by value creates a copy of the array.\nPass arrays by reference to avoid useless copies.\n\nCheck supports pre-waiving.")
public class Check_SVTB_32_1_1
extends OVMComplianceCheck {
    public Check_SVTB_32_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (!(namedElement instanceof RfFunction)) {
                    return true;
                }
                RfFunction function = (RfFunction)namedElement;
                if (Check_SVTB_32_1_1.this.checkPreWaivers(function.getFile())) {
                    return true;
                }
                if (function.isDPI() || function.isLet()) {
                    return true;
                }
                Check_SVTB_32_1_1.this.notifyCheckAlive();
                IRfNamedElement argumentType = function.getAssociatedType();
                if (argumentType instanceof RfTypeAlias) {
                    argumentType = ((RfTypeAlias)argumentType).getTranslatedType();
                }
                if (!(argumentType instanceof RfListType)) {
                    return true;
                }
                String unpackedDimension = ((RfListType)argumentType).getUnpackedDimension();
                if (unpackedDimension == null || unpackedDimension.isEmpty()) {
                    return true;
                }
                Check_SVTB_32_1_1.this.addHit(function, "Function '" + function.getFullName() + "() has array as return type!");
                return true;
            }
        };
        rfProject.accept(neVisitor);
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

