/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractArgumentTypePerformanceCheck;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;

@CheckVersion(value="3.5.24")
@CheckID(value="SVTB.32.2.0")
@CheckName(value="SVTB.32.2.0")
@CheckLabel(labels={RuleLabel.PERFORMANCE, RuleLabel.STRING, RuleLabel.ARGUMENT, RuleLabel.METHOD})
@CheckTitle(value="Pass strings by reference unless otherwise needed")
@CheckDescription(value="Pass strings by reference to avoid useless copies. When the arguments are large, it can be undesirable to copy the arguments.\n\nFYR, an argument has one of the following directions:\n- input // copy value in at beginning\n- output // copy value out at end\n- inout // copy in at beginning and out at end\n- [const] ref // pass reference")
public class Check_SVTB_32_2_0
extends AbstractArgumentTypePerformanceCheck {
    @CheckParameter(defaultValue="false", description="Do not flag constructor arguments.", name="skipConstructors", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipConstructorsValue;

    public Check_SVTB_32_2_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    void checkArgument(RfFunction function, RfField argument) {
        if (this.pSkipConstructorsValue && function.isConstructor()) {
            return;
        }
        IRfNamedElement argumentType = argument.getAssociatedType();
        if (argumentType instanceof RfTypeAlias) {
            argumentType = ((RfTypeAlias)argumentType).getTranslatedType();
        }
        if (argumentType instanceof RfScalarType && "string".equals(argumentType.getName()) && !argument.isRef()) {
            this.addHit(argument, String.valueOf(argument.getDirectionString()) + " argument '" + argument.getAssociatedTypeName() + " " + argument.getName() + "' of " + function.getFullName() + "() should be passed by reference!");
        }
    }
}

