/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="21.1.3")
@CheckID(value="SVTB.32.3")
@CheckName(value="SVTB.32.3")
@CheckLabel(labels={RuleLabel.PERFORMANCE, RuleLabel.LOOP})
@CheckTitle(value="Do not use infinite loops")
@CheckDescription(value="Loops must always have a way to end.\n\nExamples:\n\nfor (int i = 0;; i++) begin //NOT ALLOWED\n\nend\n\nwhile (a) begin //NOT ALLOWED\n...\nend\n\nwhile (a) begin //ALLOWED\n...\na--;\nend\n\nwhile(1) begin //ALLOWED\n...\nbreak;\nend\n\nCheck supports pre-waiving.")
public class Check_SVTB_32_3
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, allow infinite loops in fork join_any/none blocks if followed by disable fork or process kill.", name="allowLoopsInForkJoin", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowLoopsInForkJoinBlocks;
    private String FATAL;
    private String FATAL_CONTEXT;
    private String FATAL_BEGIN;
    private String FATAL_CONTEXT_BEGIN;
    private String FATAL_END;
    private String FATAL_CONTEXT_END;
    private Set<String> fatalMacros;

    public Check_SVTB_32_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.FATAL = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_fatal");
        this.FATAL_CONTEXT = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_fatal_context");
        this.FATAL_BEGIN = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_fatal_begin");
        this.FATAL_CONTEXT_BEGIN = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_fatal_context_begin");
        this.FATAL_END = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_fatal_end");
        this.FATAL_CONTEXT_END = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_fatal_context_end");
        this.fatalMacros = new HashSet<String>(Arrays.asList(this.FATAL, this.FATAL_CONTEXT, this.FATAL_BEGIN, this.FATAL_CONTEXT_BEGIN, this.FATAL_END, this.FATAL_CONTEXT_END));
        List<RfActionBlock> allActionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        for (RfActionBlock rfActionBlock : allActionBlocks) {
            RfDefElement declaration = rfActionBlock.getDeclaration();
            if (declaration == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(declaration.getParserPath(), this)) continue;
            this.notifyCheckAlive();
            if (rfActionBlock.isFor()) {
                this.handleFor(rfActionBlock);
                continue;
            }
            if (rfActionBlock.isWhile()) {
                this.handleWhile(rfActionBlock, true);
                continue;
            }
            if (!rfActionBlock.isDoWhile()) continue;
            this.handleWhile(rfActionBlock, false);
        }
    }

    private void handleWhile(RfActionBlock rfActionBlock, boolean useForWhile) {
        RfHidHolder hidHolder = rfActionBlock.getHidHolder();
        if (hidHolder == null) {
            return;
        }
        if (hidHolder.getHidObjectsMap() == null) {
            return;
        }
        ParserPath loopDeclaration = rfActionBlock.getDeclaration().getParserPath();
        ListContainer loopOperators = (ListContainer)hidHolder.getHidObjectsMap().get(loopDeclaration);
        if (loopOperators == null || loopOperators.isEmpty()) {
            return;
        }
        IHidObject hidObject = useForWhile ? (IHidObject)loopOperators.get(0) : (IHidObject)loopOperators.get(loopOperators.size() - 1);
        if (!(hidObject instanceof RfHidOperator)) {
            return;
        }
        if (!((RfHidOperator)hidObject).getOperatorText().equals("while")) {
            return;
        }
        IHidObject conditionValue = ((RfHidOperator)hidObject).getLHValue();
        Boolean hit = false;
        String errorMessage = "";
        if (conditionValue instanceof RfHidImplicit && !((RfHidImplicit)conditionValue).getName().equals("0")) {
            ActionBlockVisitor actionBlockVisitor = new ActionBlockVisitor(true, null, hit, rfActionBlock);
            rfActionBlock.visitHidObject(this.fOVMProject.getRfProject(), actionBlockVisitor);
            if (actionBlockVisitor.found.booleanValue()) {
                return;
            }
            MethodCallVisitor methodCallVisitor = new MethodCallVisitor(null, rfActionBlock);
            rfActionBlock.visitHidObject(this.fOVMProject.getRfProject(), methodCallVisitor);
            if (methodCallVisitor.found.booleanValue()) {
                return;
            }
            errorMessage = "Loop needs a way to end!";
        } else if (conditionValue instanceof RfHid) {
            RfNamedElement element = (RfNamedElement)((RfHid)conditionValue).getElement();
            if (element == null || this.isListType(element)) {
                return;
            }
            ActionBlockVisitor actionBlockVisitor = new ActionBlockVisitor(false, element, hit, rfActionBlock);
            rfActionBlock.visitHidObject(this.fOVMProject.getRfProject(), actionBlockVisitor);
            if (actionBlockVisitor.found.booleanValue()) {
                return;
            }
            MethodCallVisitor methodCallVisitor = new MethodCallVisitor(element, rfActionBlock);
            rfActionBlock.visitHidObject(this.fOVMProject.getRfProject(), methodCallVisitor);
            if (methodCallVisitor.found.booleanValue()) {
                return;
            }
            errorMessage = "Condition variable '" + LintUtils.getNamedElementFullName(element) + "' is never changed inside the loop!";
        }
        if (errorMessage.isEmpty()) {
            return;
        }
        if (!this.pAllowLoopsInForkJoinBlocks) {
            this.addHit(rfActionBlock, errorMessage);
            return;
        }
        this.checkIfLoopInForkJoinBlock(rfActionBlock, errorMessage);
    }

    private boolean isListType(RfNamedElement element) {
        if (!(element instanceof RfAssociatedType)) {
            return false;
        }
        HashSet<String> typeAliasNames = new HashSet<String>();
        IRfNamedElement associatedType = ((RfAssociatedType)element).getAssociatedType();
        while (associatedType instanceof RfTypeAlias) {
            String associatedTypeSig = String.valueOf(associatedType.getName()) + ((RfAssociatedType)associatedType).getUnpackedDimension();
            if (typeAliasNames.contains(associatedTypeSig)) break;
            typeAliasNames.add(associatedTypeSig);
            associatedType = ((RfTypeAlias)associatedType).getAssociatedType();
        }
        return associatedType instanceof RfListType;
    }

    private void handleFor(RfActionBlock rfActionBlock) {
        RfHidHolder hidHolder = rfActionBlock.getHidHolder();
        if (rfActionBlock.getExpression() == null || !rfActionBlock.getExpression().trim().contains("(;;)")) {
            if (hidHolder == null) {
                return;
            }
            if (hidHolder.getHidObjectsMap() == null) {
                return;
            }
            if (rfActionBlock.getDeclaration() == null) {
                return;
            }
            ParserPath loopDeclaration = rfActionBlock.getDeclaration().getParserPath();
            ListContainer loopOperators = (ListContainer)hidHolder.getHidObjectsMap().get(loopDeclaration);
            if (loopOperators == null || loopOperators.isEmpty()) {
                return;
            }
            for (IHidObject operator : loopOperators) {
                if (!(operator instanceof RfHidOperator) || !((RfHidOperator)operator).isForCondition()) continue;
                return;
            }
        }
        ActionBlockVisitor actionBlockVisitor = new ActionBlockVisitor(true, null, false, rfActionBlock);
        rfActionBlock.visitHidObject(this.fOVMProject.getRfProject(), actionBlockVisitor);
        if (actionBlockVisitor.found.booleanValue()) {
            return;
        }
        MethodCallVisitor methodCallVisitor = new MethodCallVisitor(null, rfActionBlock);
        rfActionBlock.visitHidObject(this.fOVMProject.getRfProject(), methodCallVisitor);
        if (methodCallVisitor.found.booleanValue()) {
            return;
        }
        if (!this.pAllowLoopsInForkJoinBlocks) {
            this.addHit(rfActionBlock, "Loop needs a way to end!");
            return;
        }
        this.checkIfLoopInForkJoinBlock(rfActionBlock, "Loop needs a way to end!");
    }

    private RfNamedElement getForkJoinEnclosure(RfActionBlock rfActionBlock) {
        RfNamedElement scope = rfActionBlock.getEnclosingScope();
        while (scope != null) {
            if (scope instanceof RfActionBlock && (((RfActionBlock)scope).isForkJoinAny() || ((RfActionBlock)scope).isForkJoinNone())) {
                return scope;
            }
            scope = scope.getEnclosingScope();
        }
        return null;
    }

    private DVTPair<Set<RfNamedElement>, RfNamedElement> getNonForkJoinScopes(RfActionBlock rfActionBlock) {
        HashSet<RfNamedElement> scopes = new HashSet<RfNamedElement>();
        RfNamedElement lastScope = null;
        RfNamedElement scope = rfActionBlock.getEnclosingScope();
        while (!(scope instanceof RfLibrary)) {
            if (scope instanceof RfClass || scope instanceof RfModule || scope instanceof RfInterface || scope instanceof RfProgram || scope instanceof RfPackage) break;
            if (!(scope instanceof RfActionBlock)) {
                scopes.add(scope);
                lastScope = scope;
            } else if (!((RfActionBlock)scope).isSimpleForkJoin()) {
                scopes.add(scope);
                lastScope = scope;
            }
            scope = scope.getEnclosingScope();
        }
        return new DVTPair(scopes, lastScope);
    }

    private void checkIfLoopInForkJoinBlock(RfActionBlock rfActionBlock, String errorMessage) {
        RfNamedElement enclosingForkJoinBlock = this.getForkJoinEnclosure(rfActionBlock);
        if (enclosingForkJoinBlock == null) {
            this.addHit(rfActionBlock, errorMessage);
            return;
        }
        DVTPair<Set<RfNamedElement>, RfNamedElement> scopesAndLastScope = this.getNonForkJoinScopes((RfActionBlock)enclosingForkJoinBlock);
        Set forkJoinScopes = (Set)scopesAndLastScope.getKey();
        if (forkJoinScopes.isEmpty()) {
            this.addHit(rfActionBlock, errorMessage);
            return;
        }
        ForkJoinScopesVisitor forkJoinScopesVisitor = new ForkJoinScopesVisitor(forkJoinScopes, enclosingForkJoinBlock.getEndOffset());
        if (scopesAndLastScope.getValue() != null) {
            ((RfNamedElement)scopesAndLastScope.getValue()).visitHidObject(this.fOVMProject.getRfProject(), forkJoinScopesVisitor);
        }
        if (forkJoinScopesVisitor.foundDisableOrKill) {
            return;
        }
        this.addHit(rfActionBlock, errorMessage);
    }

    /*
     * Unable to fully structure code
     */
    public boolean isInTheSameScopeRecursive(RfNamedElement scope, RfActionBlock varScope) {
        if (scope instanceof RfActionBlock) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (scope.equals(varScope)) {
                return true;
            }
            scope = scope.getEnclosingScope();
lbl6:
            // 2 sources

            ** while (scope instanceof RfActionBlock)
        }
lbl7:
        // 1 sources

        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isInTheSameScope(RfNamedElement scope, RfActionBlock varScope) {
        if (scope instanceof RfActionBlock) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            if ((scope = scope.getEnclosingScope()) instanceof RfActionBlock) continue;
            return false;
lbl5:
            // 2 sources

            ** while (!((RfActionBlock)scope).isLoop())
        }
lbl6:
        // 1 sources

        return scope.equals(varScope) != false;
    }

    private class ActionBlockVisitor
    implements IHidVisitor<RfHidOperator> {
        private boolean lookForBreak;
        private RfNamedElement variable;
        private RfActionBlock varScope;
        RfNamedElement scope;
        Boolean found;

        public ActionBlockVisitor(boolean lookForBreak, RfNamedElement variable, Boolean found, RfActionBlock actionBlock) {
            this.lookForBreak = lookForBreak;
            this.variable = variable;
            this.found = found;
            this.varScope = actionBlock;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public boolean visit(RfHidOperator hidObject) {
            if (this.lookForBreak) {
                if (hidObject.getOperatorText().equals("break") && Check_SVTB_32_3.this.isInTheSameScope(this.scope, this.varScope) || hidObject.getOperatorText().equals("return") && Check_SVTB_32_3.this.isInTheSameScopeRecursive(this.scope, this.varScope)) {
                    this.found = true;
                    return false;
                }
            } else {
                IHidObject lhValue = hidObject.getLHValue();
                if (hidObject.getOperatorText().equals("while")) {
                    return true;
                }
                if (lhValue instanceof RfHid && this.variable.equals(((RfHid)lhValue).getElement())) {
                    this.found = true;
                    return false;
                }
            }
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }

    private class ForkJoinScopesVisitor
    implements IHidVisitor<IHidObject> {
        private Set<RfNamedElement> forkJoinScopes;
        private RfNamedElement scope;
        private int forkJoinEndOffset;
        private boolean foundDisableOrKill;

        public ForkJoinScopesVisitor(Set<RfNamedElement> forkJoinScopes, int forkJoinEndOffset) {
            this.forkJoinScopes = forkJoinScopes;
            this.forkJoinEndOffset = forkJoinEndOffset;
        }

        public boolean visit(IHidObject hidObject) {
            switch (hidObject.getHidKind()) {
                case HID: {
                    Hid hid = (Hid)hidObject;
                    if (hid.getOffset() <= this.forkJoinEndOffset) {
                        return true;
                    }
                    if (!hid.isMethodCall(false)) {
                        return true;
                    }
                    if (!LintUtils.getHidFullName((IHid)hid).equals("std::process.kill")) {
                        return true;
                    }
                    RfNamedElement killScope = this.scope;
                    return this.checkScope(killScope);
                }
                case OPERATOR: {
                    HidOperator operator = (HidOperator)hidObject;
                    if (operator.getOffset() <= this.forkJoinEndOffset) {
                        return true;
                    }
                    if (!operator.isDisableStatement()) {
                        return true;
                    }
                    if (!(operator.getLHValue() instanceof RfHidImplicit)) {
                        return true;
                    }
                    if (!((RfHidImplicit)operator.getLHValue()).isDisableFork()) {
                        return true;
                    }
                    RfNamedElement operatorScope = this.scope;
                    return this.checkScope(operatorScope);
                }
            }
            return true;
        }

        private boolean checkScope(RfNamedElement scope) {
            while (scope != null) {
                if (this.forkJoinScopes.contains(scope)) {
                    this.foundDisableOrKill = true;
                    return false;
                }
                if (scope instanceof RfActionBlock && ((RfActionBlock)scope).isSimpleForkJoin()) {
                    return true;
                }
                scope = scope.getEnclosingScope();
            }
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }

    private class MethodCallVisitor
    implements IHidVisitor<RfHid> {
        Boolean found;
        private RfNamedElement variable;
        private RfActionBlock varScope;
        RfNamedElement scope;
        private int beginMacrosOpen;

        public MethodCallVisitor(RfNamedElement variable, RfActionBlock actionBlock) {
            this.variable = variable;
            this.found = false;
            this.varScope = actionBlock;
            this.beginMacrosOpen = 0;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public boolean visit(RfHid hidObject) {
            boolean sameScope;
            block9: {
                ReparseInfo.ReparseElement[] macroStack;
                sameScope = Check_SVTB_32_3.this.isInTheSameScopeRecursive(this.scope, this.varScope);
                if (hidObject.getReparseInfo() == null || !sameScope) break block9;
                ReparseInfo.ReparseElement[] reparseElementArray = macroStack = ((ReparseInfo)hidObject.getReparseInfo()).getReparseStack();
                int n = macroStack.length;
                int n2 = 0;
                while (n2 < n) {
                    block10: {
                        block12: {
                            String macroName;
                            block11: {
                                ReparseInfo.ReparseElement macro = reparseElementArray[n2];
                                macroName = macro.getReparseMacroName();
                                if (!Check_SVTB_32_3.this.fatalMacros.contains(macroName)) break block10;
                                if (!macroName.equals(Check_SVTB_32_3.this.FATAL_BEGIN) && !macroName.equals(Check_SVTB_32_3.this.FATAL_CONTEXT_BEGIN)) break block11;
                                ++this.beginMacrosOpen;
                                break block10;
                            }
                            if (!macroName.equals(Check_SVTB_32_3.this.FATAL_END) && !macroName.equals(Check_SVTB_32_3.this.FATAL_CONTEXT_END)) break block12;
                            if (this.beginMacrosOpen == 0) break block10;
                            --this.beginMacrosOpen;
                        }
                        this.found = true;
                        return false;
                    }
                    ++n2;
                }
            }
            if (!hidObject.isMethodCall(false)) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                Map argMap;
                if (methodCall.method instanceof RfPredefinedFunction && (methodCall.method.getName().equals("$fatal") || methodCall.method.getName().equals("$finish")) && sameScope) {
                    this.found = true;
                    return false;
                }
                if (this.variable == null || (argMap = methodCall.argumentValuesMapRaw) == null || argMap.isEmpty()) continue;
                for (Map.Entry entry : argMap.entrySet()) {
                    if (!(entry.getKey() instanceof RfField) || ((RfField)entry.getKey()).isInput() || !(entry.getValue() instanceof Hid) || !((Hid)entry.getValue()).getElement().equals(this.variable)) continue;
                    this.found = true;
                    return false;
                }
            }
            return true;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

