/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_32_4;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="21.1.6")
@CheckID(value="SVTB.32.4")
@CheckName(value="SVTB.32.4")
@CheckLabel(labels={RuleLabel.PERFORMANCE, RuleLabel.CONDITIONAL, RuleLabel.IF})
@CheckTitle(value="Do not use long if else if chains")
@CheckDescription(value="Do not use long if else if chains because performance can be hindered. Use case statements instead, which can be parsed much faster.\n\nExamples for maxChainSize = 3:\nif (a == 1) begin x = 10; end // not allowed\nelse if (a == 2) begin x = 25; end\nelse if (a == 3) begin x = 50; end\nelse if (a == 4) begin x = 60; end\nelse begin x = 100; end\n\nif (a == 1) begin x = 10; end // allowed\nelse if (a == 2) begin x = 25; end\nelse begin x = 100; end\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_32_4.class)
public class Check_SVTB_32_4
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="20", description="Defines the maximum count of 'if/else if's allowed in a chain.", name="maxChainSize", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int fMaxChainSize;
    private Map<RfActionBlock, List<RfActionBlock>> ifChains = new HashMap<RfActionBlock, List<RfActionBlock>>();

    public Check_SVTB_32_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.ifChains.clear();
        List<ParserPath> allFiles = this.fOVMProject.getAllFilesInOrder();
        for (ParserPath parserPath : allFiles) {
            if (this.fOVMProject.isOVMFile(parserPath.path) || this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            this.notifyCheckAlive();
            RfFileDef fileDef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(parserPath);
            if (fileDef == null) continue;
            this.checkDefElement(fileDef);
        }
        Set<RfActionBlock> chainStarts = this.ifChains.keySet();
        for (RfActionBlock chainStart : chainStarts) {
            List<RfActionBlock> list = this.ifChains.get(chainStart);
            if (list.size() + 1 <= this.fMaxChainSize) continue;
            list.add(0, chainStart);
            this.addHit(chainStart, "If/else if/else chain longer than allowed: " + this.fMaxChainSize + "!", new VerissimoAutofixAdditionalInfo(list));
        }
    }

    private void checkDefElement(RfDefElement elem) {
        Collection<RfDefElement> children = elem.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        RfActionBlock chainStart = null;
        for (RfDefElement child : children) {
            RfActionBlock actionBlock;
            RfNamedElement enclosingScope;
            RfNamedElement namedElement;
            this.checkDefElement(child);
            if (!(child instanceof RfActionBlockDef) || !((namedElement = ((RfActionBlockDef)child).getNamedElement()) instanceof RfActionBlock) || (enclosingScope = (actionBlock = (RfActionBlock)namedElement).getEnclosingScope()) instanceof RfConstraint || enclosingScope instanceof RfActionBlock && ((RfActionBlock)enclosingScope).isWith()) continue;
            if (actionBlock.isIf()) {
                chainStart = actionBlock;
                this.ifChains.put(chainStart, new LinkedList());
                continue;
            }
            if (!actionBlock.isElsIf() && !actionBlock.isElse() || chainStart == null) continue;
            List<RfActionBlock> list = this.ifChains.get(chainStart);
            list.add(actionBlock);
            this.ifChains.put(chainStart, list);
        }
    }

    @Override
    public void clean() {
        super.clean();
        if (this.ifChains != null) {
            this.ifChains.clear();
        }
    }
}

