/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.TokenEntry;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractCPDCheck;
import ro.amiq.vlogdt.model.reflection.LightToken;

@CheckVersion(value="15.1.12")
@CheckID(value="SVTB.33.2.0")
@CheckName(value="SVTB.33.2.0")
@CheckLabel(labels={RuleLabel.DUPLICATE_CODE, RuleLabel.METHOD})
@CheckTitle(value="Duplicate code in functions")
@CheckDescription(value="This rule looks for code duplication only inside functions.\nInappropriate code duplication may increase maintenance costs. Fixing a multiplicated mistake throughout the code or enhancing multiplicated code are problematic and error prone.\nDuplicate code may also indicate a sloppy design.\n\nCheck supports pre-waiving.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="showBoundaryDuplicateTokens", isVisible=false), @CheckParameterOverride(name="showDuplicateTokens", isVisible=false)})
@CheckReapplyDisable
public class Check_SVTB_33_2_0
extends AbstractCPDCheck {
    public Check_SVTB_33_2_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected List<LightToken> filterTokens(List<LightToken> tokens) {
        return this.isolateFunctions(tokens);
    }

    @Override
    protected List<Match> filterMatches(List<Match> matches) {
        LinkedList<Match> result = new LinkedList<Match>();
        LinkedHashMap<String, LinkedList<MatchProperties>> pathsToRegionsMap = new LinkedHashMap<String, LinkedList<MatchProperties>>();
        for (Match match : matches) {
            String markFilename;
            TokenEntry markTokenEntry;
            if (match == null) continue;
            int nofDuplicateTokens = match.getTokenCount();
            LinkedList<Mark> allMarks = new LinkedList<Mark>();
            for (Mark mark : match) {
                this.notifyCheckAlive();
                if (mark == null) continue;
                allMarks.add(mark);
            }
            Collections.sort(allMarks, new Comparator<Mark>(){

                @Override
                public int compare(Mark o1, Mark o2) {
                    if (o1.getFilename() == null || o2.getFilename() == null) {
                        return 0;
                    }
                    int stringCompare = o1.getFilename().compareTo(o2.getFilename());
                    if (stringCompare != 0) {
                        return stringCompare;
                    }
                    if (o1.getBeginLine() > o2.getBeginLine()) {
                        return 1;
                    }
                    if (o1.getBeginLine() < o2.getBeginLine()) {
                        return -1;
                    }
                    return 0;
                }
            });
            Mark mark = (Mark)allMarks.getFirst();
            if (mark == null || (markTokenEntry = mark.getToken()) == null || (markFilename = mark.getFilename()) == null) continue;
            List tokenEntriesInMap = (List)this.fTokenEntryMap.get(markFilename);
            int startTokenIndex = -1;
            int i = 0;
            while (i < tokenEntriesInMap.size()) {
                this.notifyCheckAlive();
                TokenEntry tokenEntry = (TokenEntry)tokenEntriesInMap.get(i);
                if (tokenEntry != null && tokenEntry.equals((Object)markTokenEntry) && tokenEntry.getBeginLine() == markTokenEntry.getBeginLine()) {
                    startTokenIndex = i;
                    break;
                }
                ++i;
            }
            int endTokenIndex = startTokenIndex + nofDuplicateTokens - 1;
            boolean isInKnownRegion = false;
            LinkedList<MatchProperties> regionMap = (LinkedList<MatchProperties>)pathsToRegionsMap.get(markFilename);
            if (regionMap != null) {
                for (MatchProperties matchInfo : regionMap) {
                    int existingStartIndex = matchInfo.getStartTokenEntryIndex();
                    int existingEndIndex = matchInfo.getEndTokenEntryIndex();
                    if (endTokenIndex > existingEndIndex || startTokenIndex < existingStartIndex) continue;
                    isInKnownRegion = true;
                    break;
                }
            }
            if (isInKnownRegion) continue;
            if (regionMap == null) {
                regionMap = new LinkedList<MatchProperties>();
            }
            regionMap.add(new MatchProperties(startTokenIndex, endTokenIndex));
            pathsToRegionsMap.put(markFilename, regionMap);
            result.add(match);
        }
        return result;
    }

    static class MatchProperties {
        int startTokenEntryIndex;
        int endTokenEntryIndex;

        public MatchProperties(int startTokenEntryIndex, int endTokenEntryIndex) {
            this.startTokenEntryIndex = startTokenEntryIndex;
            this.endTokenEntryIndex = endTokenEntryIndex;
        }

        public int getStartTokenEntryIndex() {
            return this.startTokenEntryIndex;
        }

        public int getEndTokenEntryIndex() {
            return this.endTokenEntryIndex;
        }
    }
}

