/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.TokenEntry;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractCPDCheck;
import ro.amiq.vlogdt.model.reflection.LightToken;

@CheckVersion(value="15.1.12")
@CheckID(value="SVTB.33.3.0")
@CheckName(value="SVTB.33.3.0")
@CheckLabel(labels={RuleLabel.DUPLICATE_CODE, RuleLabel.METHOD})
@CheckTitle(value="Duplicate functions")
@CheckDescription(value="This rule looks for duplicate functions.\nInappropriate code duplication may increase maintenance costs. Fixing a multiplicated mistake throughout the code or enhancing multiplicated code are problematic and error prone.\nDuplicate code may also indicate a sloppy design.\n\nCheck supports pre-waiving.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="showBoundaryDuplicateTokens", isVisible=false), @CheckParameterOverride(name="showDuplicateTokens", isVisible=false), @CheckParameterOverride(name="minNofTokens", defaultValue="30")})
@CheckReapplyDisable
public class Check_SVTB_33_3_0
extends AbstractCPDCheck {
    public Check_SVTB_33_3_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected List<LightToken> filterTokens(List<LightToken> tokens) {
        return this.isolateFunctions(tokens);
    }

    @Override
    protected List<Match> filterMatches(List<Match> matches) {
        LinkedList<Match> result = new LinkedList<Match>();
        for (Match match : matches) {
            TokenEntry endTokenEntry;
            String markFilename;
            TokenEntry markTokenEntry;
            Mark mark;
            if (match == null) continue;
            int nofDuplicateTokens = match.getTokenCount();
            Iterator markIterator = match.iterator();
            if (markIterator == null || !markIterator.hasNext() || (mark = (Mark)markIterator.next()) == null || (markTokenEntry = mark.getToken()) == null || !"function".equals(markTokenEntry.toString()) && !"task".equals(markTokenEntry.toString()) || (markFilename = mark.getFilename()) == null) continue;
            List tokenEntriesInMap = (List)this.fTokenEntryMap.get(markFilename);
            int markTokenEntryIndex = -1;
            int i = 0;
            while (i < tokenEntriesInMap.size()) {
                this.notifyCheckAlive();
                TokenEntry tokenEntry = (TokenEntry)tokenEntriesInMap.get(i);
                if (tokenEntry != null && tokenEntry.equals((Object)markTokenEntry)) {
                    markTokenEntryIndex = i;
                    break;
                }
                ++i;
            }
            int endTokenIndex = markTokenEntryIndex + nofDuplicateTokens - 1;
            if (markTokenEntryIndex == -1 || endTokenIndex >= tokenEntriesInMap.size() || !"endfunction".equals((endTokenEntry = (TokenEntry)tokenEntriesInMap.get(endTokenIndex)).toString()) && !"endtask".equals(endTokenEntry.toString())) continue;
            result.add(match);
        }
        return result;
    }
}

