/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.BuildFilePathLine;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogIncludingScope;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;
import ro.amiq.vlogdt.utils.SourceFileToBuildFileMapping;

@CheckVersion(value="21.1.8")
@CheckID(value="SVTB.33.4.0")
@CheckName(value="SVTB.33.4.0")
@CheckLabel(labels={RuleLabel.DUPLICATE_CODE, RuleLabel.FILE})
@CheckTitle(value="Do not compile the same file in multiple libraries")
@CheckDescription(value="Compiling the same file in multiple libraries can have an impact on the code maintenance costs.\nIt can also lead to issues when using different types of compilation modes supported by simulators.\n\nCheck supports pre-waiving.")
public class Check_SVTB_33_4_0
extends OVMComplianceCheck {
    private static final String HIT_BASE_MESSAGE = "File is compiled in multiple libraries: ";
    private static final String ENTRY_START = " (included in: ";
    private static final String AT_LINE = " at line ";
    private static final String ENTRY_END = ")";
    private static final String ELEM_SEPARATOR = ", ";
    private static final String PATH_SEPARATOR = "/";
    private RfProject rfProject;

    public Check_SVTB_33_4_0(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.rfProject = this.fOVMProject.getRfProject();
        if (this.rfProject == null) {
            return;
        }
        VlogPreprocessingInfo preprocessingTable = this.rfProject.getPreprocessingTable();
        if (preprocessingTable == null) {
            return;
        }
        VlogFileInstance topFile = preprocessingTable.getTopFileInstance();
        if (topFile == null) {
            return;
        }
        List<VlogFileInstance> files = topFile.getIncludedInstances();
        if (files == null || files.isEmpty()) {
            return;
        }
        Map<ParserPath, List<VlogFileInstance>> instances = this.getFileInstancesWithDuplicates(files);
        this.checkForDuplicates(instances);
    }

    private Map<ParserPath, List<VlogFileInstance>> getFileInstancesWithDuplicates(List<VlogFileInstance> files) {
        HashMap<ParserPath, List<VlogFileInstance>> instances = new HashMap<ParserPath, List<VlogFileInstance>>();
        int i = 0;
        while (i < files.size()) {
            this.notifyCheckAlive();
            VlogFileInstance fileInstance = files.get(i);
            File file = new File(fileInstance.getParserPath().path);
            String name = fileInstance.getShortFileName();
            if (name.startsWith("__vlog__") && name.endsWith(".libfile")) {
                files.addAll(fileInstance.getIncludedInstances());
            }
            if (file.exists()) {
                ParserPath filePath = fileInstance.getParserPath();
                if (!this.fOVMProject.isOVMFile(filePath.path) && !this.fOVMProject.getProjectWaivers().pathIsPrewaived(filePath, this)) {
                    if (instances.get(filePath) == null) {
                        instances.put(filePath, new ArrayList());
                    }
                    ((List)instances.get(filePath)).add(fileInstance);
                    files.addAll(fileInstance.getIncludedInstances());
                }
            }
            ++i;
        }
        return instances;
    }

    private void checkForDuplicates(Map<ParserPath, List<VlogFileInstance>> instances) {
        for (Map.Entry<ParserPath, List<VlogFileInstance>> filePathsAndInstances : instances.entrySet()) {
            this.notifyCheckAlive();
            ParserPath path = filePathsAndInstances.getKey();
            List<VlogFileInstance> fileInstances = filePathsAndInstances.getValue();
            if (fileInstances.size() <= 1) continue;
            LinkedHashMap fileLibs = new LinkedHashMap();
            for (VlogFileInstance fileInstance : fileInstances) {
                LineAndPath lineAndPath;
                RfNamedElement lib = fileInstance.getSemanticScope();
                if (!(lib instanceof RfLibrary)) {
                    lib = lib.getEnclosingLibrary();
                }
                if (lib == null || (lineAndPath = this.getLineAndPath(fileInstance)) == null) continue;
                String libName = lib.getName();
                if (fileLibs.get(libName) == null) {
                    fileLibs.put(libName, new ArrayList());
                }
                ((List)fileLibs.get(libName)).add(lineAndPath);
            }
            if (fileLibs.size() <= 1) continue;
            StringBuilder message = new StringBuilder(HIT_BASE_MESSAGE);
            for (Map.Entry entry : fileLibs.entrySet()) {
                message.append((CharSequence)this.computeEntryMessage((String)entry.getKey(), (List)entry.getValue()));
            }
            this.addHit(path, 0, String.valueOf(message.substring(0, message.length() - ELEM_SEPARATOR.length())) + "!", null);
        }
    }

    private LineAndPath getLineAndPath(VlogFileInstance fileInstance) {
        VlogIncludingScope includingScope = fileInstance.getIncludingScope();
        if (includingScope == null) {
            return null;
        }
        VlogFileInstance includingInstance = includingScope.getIncludingInstance();
        if (includingInstance == null) {
            return null;
        }
        String name = includingInstance.getShortFileName();
        if (!name.startsWith("__vlog__")) {
            return new LineAndPath(includingScope.getIncludingLine(), includingInstance.getParserPath().path, includingInstance.getShortFileName());
        }
        SourceFileToBuildFileMapping sourceFileToBuildMapping = this.rfProject.getSourceFileToBuildFileMapping();
        if (sourceFileToBuildMapping == null) {
            return null;
        }
        Map<Integer, BuildFilePathLine> includedTopFilesMap = sourceFileToBuildMapping.getIncludedTopFilesMap().get(fileInstance.getInvocNumber());
        if (includedTopFilesMap == null) {
            return null;
        }
        BuildFilePathLine includedTopFile = includedTopFilesMap.get(fileInstance.getIncludingScope().getIncludingLine());
        if (includedTopFile != null) {
            String[] tokens = includedTopFile.getPath().split(PATH_SEPARATOR);
            return new LineAndPath(includedTopFile.getBuildFileLine(), includedTopFile.getPath(), tokens[tokens.length - 1]);
        }
        Map<String, BuildFilePathLine> includedLibrariesMap = sourceFileToBuildMapping.getIncludedLibrariesMap().get(fileInstance.getInvocNumber());
        if (includedLibrariesMap == null) {
            return null;
        }
        BuildFilePathLine inclLibrary = includedLibrariesMap.get(fileInstance.getParserPath().path);
        if (inclLibrary == null) {
            return null;
        }
        IFile buildFile = DVTFileUtils.getInstance().getProjectFile(this.fOVMProject.getProject(), inclLibrary.getPath());
        if (buildFile == null) {
            return null;
        }
        String[] tokens = inclLibrary.getPath().split(PATH_SEPARATOR);
        return new LineAndPath(inclLibrary.getBuildFileLine(), inclLibrary.getPath(), tokens[tokens.length - 1]);
    }

    private StringBuilder computeEntryMessage(String name, List<LineAndPath> linesAndPaths) {
        StringBuilder message = new StringBuilder();
        message.append(String.valueOf(name) + ENTRY_START);
        int i = 0;
        while (i < linesAndPaths.size()) {
            LineAndPath current = linesAndPaths.get(i);
            int line = current.getLine();
            message.append(String.valueOf(this.link(current.getName(), current.getPath(), line)) + AT_LINE + line);
            if (i != linesAndPaths.size() - 1) {
                message.append(ELEM_SEPARATOR);
            }
            ++i;
        }
        return message.append("), ");
    }

    private static class LineAndPath {
        private int line;
        private String path;
        private String name;

        public LineAndPath(int line, String path, String name) {
            this.line = line;
            this.path = path;
            this.name = name;
        }

        public int getLine() {
            return this.line;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }
    }
}

