/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.4.1.4.1")
@CheckName(value="SVTB.4.1.4.1")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE, RuleLabel.DELAY, RuleLabel.DIRECTIVE, RuleLabel.TIMESCALE})
@CheckTitle(value="Specify time units for all delays with literal values")
@CheckDescription(value="Do not rely on the `timescale to define the delay's time unit.\n\nExamples:\n#1step // allowed\n#0 // allowed \n#5 // not allowed\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_4_1_4_1
extends AbstractSVTBSimpleIssues {
    public Check_SVTB_4_1_4_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(11);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return "Time literal without unit!";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        HashMap<ParserPath, List<SVTBIssues>> filteredMap = new HashMap<ParserPath, List<SVTBIssues>>();
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(11);
        Set<ParserPath> keySet = allIssues.keySet();
        for (ParserPath filename : keySet) {
            List<SVTBIssues> issues;
            RfFileDef filedef;
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(filename, this) || (filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(filename)) == null || (issues = allIssues.get(filename)) == null || issues.isEmpty()) continue;
            this.notifyCheckAlive();
            ArrayList<SVTBIssues> filteredList = new ArrayList<SVTBIssues>();
            for (SVTBIssues issue : issues) {
                if (issue.getCarry() == 1) continue;
                filteredList.add(issue);
            }
            filteredMap.put(filename, filteredList);
        }
        return filteredMap;
    }

    protected boolean isTimeValue(String str) {
        if (str == null) {
            return false;
        }
        return str.matches("0|1step") || LintUtils.isTimeValue(str);
    }
}

