/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_4_1_4_1_1;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.CodePreprocLineInfo;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.4.1.4.1.1")
@CheckName(value="SVTB.4.1.4.1.1")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE, RuleLabel.DIRECTIVE})
@CheckTitle(value="No space between time value and units")
@CheckDescription(value="The LRM specifies not spaces.\n0.1 ns // space not allowed\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_4_1_4_1_1.class)
@CheckParametersOverrides(value={@CheckParameterOverride(name="maxHitsPerFile", isVisible=false), @CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)})
public class Check_SVTB_4_1_4_1_1
extends AbstractSVTBSimpleIssues {
    public static final Pattern NUMBER = Pattern.compile("[0-9]+[_0-9]*$");
    public static final Pattern TIME_UNIT = Pattern.compile("^[munpf]?s($|[^a-zA-Z0-9_])");
    @CheckParameter(defaultValue="false", description="When true, inactive code regions are also checked.", name="checkInactiveCode", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckInactiveCode;

    public Check_SVTB_4_1_4_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        super.performCheckImpl();
        if (this.pCheckInactiveCode) {
            Map<ParserPath, CodePreprocFileInfo> codePreprocFileInfos = this.fOVMProject.getRfProject().getPreprocessingTable().getCodePreprocFileInfos();
            for (Map.Entry<ParserPath, CodePreprocFileInfo> codePreprocFileInfoEntry : codePreprocFileInfos.entrySet()) {
                TreeSet<Integer> lines;
                CodePreprocFileInfo preprocInfo;
                ParserPath path = codePreprocFileInfoEntry.getKey();
                if (path == null || this.checkPreWaivers(path) || (preprocInfo = codePreprocFileInfoEntry.getValue()) == null || (lines = preprocInfo.getLines()) == null || lines.isEmpty()) continue;
                Iterator<Integer> iterator = lines.iterator();
                int line1 = 0;
                int line2 = 0;
                if (iterator.hasNext()) {
                    line2 = iterator.next();
                }
                while (iterator.hasNext()) {
                    line1 = line2;
                    line2 = iterator.next();
                    CodePreprocLineInfo info = preprocInfo.getInfo(line1);
                    if (info.getType() == 0) continue;
                    int currentLine = line1;
                    while (currentLine <= line2) {
                        for (LiteralToken token : this.getWSParser().getTokensOnLine(path, currentLine)) {
                            LiteralToken nextToken = this.getWSParser().getNextToken(token, path);
                            if (nextToken == null) break;
                            if (token.getZone() != SVTBWhitespaceParser.ZoneType.CODE || nextToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) continue;
                            Matcher m1 = NUMBER.matcher(token.toString());
                            Matcher m2 = TIME_UNIT.matcher(nextToken.toString());
                            if (!m1.find() || !m2.find()) continue;
                            this.addHit(path, token.getLineNumber(), "Space found between time value and units at line offset " + nextToken.getOffsetLine() + "!", null, new VerissimoAutofixAdditionalInfo(nextToken.getOffsetFile()));
                        }
                        ++currentLine;
                    }
                }
            }
        }
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(10);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue, ParserPath parserPath) {
        IDocument document = this.docManager.getDocument(parserPath, this.getIProject());
        return "Space found between time value and units at line offset " + this.getOffsetOnLine(document, issue) + "!";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        return this.fOVMProject.getSVTBIssuesWithKind(10);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return null;
    }
}

